/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class EntitySpellEffect
extends Entity {
    private static final DataParameter<Integer> EFFECT = EntityDataManager.func_187226_a(EntitySpellEffect.class, (DataSerializer)DataSerializers.field_187192_b);
    public EntityLivingBase shootingEntity;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    private int ticksInAir;
    private int lifetime = -1;
    private int effectLevel;

    public EntitySpellEffect(World world) {
        super(world);
        this.field_70145_X = true;
    }

    public EntitySpellEffect(World world, EntityLivingBase thrower, double x, double y, double z, ProjectileSymbolEffect effect, int effectLevel) {
        super(world);
        this.shootingEntity = thrower;
        this.effectLevel = effectLevel;
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double d3 = MathHelper.func_76133_a((double)((x += this.field_70146_Z.nextGaussian() * 0.4) * x + (y += this.field_70146_Z.nextGaussian() * 0.4) * y + (z += this.field_70146_Z.nextGaussian() * 0.4) * z));
        this.accelerationX = x / d3 * 0.1;
        this.accelerationY = y / d3 * 0.1;
        this.accelerationZ = z / d3 * 0.1;
        this.setEffectID(SymbolEffect.REGISTRY.getId(effect));
    }

    public void setLifetime(int ticks) {
        this.lifetime = ticks;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EFFECT, (Object)0);
    }

    public int getEffectID() {
        return (Integer)this.field_70180_af.func_187225_a(EFFECT);
    }

    public void setEffectID(int effectID) {
        this.field_70180_af.func_187227_b(EFFECT, (Object)effectID);
    }

    public int getEffectLevel() {
        return this.effectLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175667_e(this.func_180425_c()))) {
            this.func_70106_y();
        } else {
            SymbolEffect effect;
            super.func_70071_h_();
            ++this.ticksInAir;
            if (this.ticksInAir == 200) {
                this.func_70106_y();
            }
            if (!this.field_70170_p.field_72995_K) {
                Vec3d vec4;
                Vec3d vec3 = this.func_174791_d();
                RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec4 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y));
                if (movingobjectposition != null) {
                    vec4 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
                }
                Entity entity = null;
                List list2 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (Entity entity2 : list2) {
                    double d2;
                    if (!entity2.func_70067_L() || entity2 == this.shootingEntity && this.ticksInAir < 25) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb = entity2.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition2 = axisalignedbb.func_72327_a(vec3, vec4);
                    if (movingobjectposition2 == null || !((d2 = vec3.func_72438_d(movingobjectposition2.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = entity2;
                    d0 = d2;
                }
                if (entity != null) {
                    movingobjectposition = new RayTraceResult(entity);
                }
                if (movingobjectposition != null || this.lifetime != -1 && this.lifetime-- <= 0) {
                    this.onImpact(movingobjectposition);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f2, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f3 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int k = 0; k < 4; ++k) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f3 = 0.8f;
            }
            if ((effect = SymbolEffect.REGISTRY.get(this.getEffectID())) == null) {
                this.func_70106_y();
            } else {
                if (effect.fallsToEarth() && this.getEffectLevel() == 1) {
                    this.accelerationX *= 0.8;
                    this.accelerationY *= 0.8;
                    this.accelerationZ *= 0.8;
                    this.field_70159_w += this.accelerationX;
                    this.field_70181_x += this.accelerationY;
                    this.field_70179_y += this.accelerationZ;
                    this.field_70181_x -= 0.05;
                } else {
                    this.field_70159_w += this.accelerationX;
                    this.field_70181_x += this.accelerationY;
                    this.field_70179_y += this.accelerationZ;
                    this.field_70159_w *= (double)f3;
                    this.field_70181_x *= (double)f3;
                    this.field_70179_y *= (double)f3;
                }
                this.field_70170_p.func_175688_a(effect.isCurse() ? EnumParticleTypes.SPELL_MOB : EnumParticleTypes.SLIME, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                if (effect.isCurse()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(RayTraceResult mop) {
        SymbolEffect effect;
        if (!this.field_70170_p.field_72995_K && (effect = SymbolEffect.REGISTRY.get(this.getEffectID())) instanceof ProjectileSymbolEffect) {
            if (effect.isCurse()) {
                this.func_184185_a(SoundEvents.field_187526_aP, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            } else {
                this.func_184185_a(SoundEvents.field_189110_fE, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            }
            if (mop != null) {
                ((ProjectileSymbolEffect)effect).onCollision(this.field_70170_p, this.shootingEntity, mop, this);
            }
        }
        this.func_70106_y();
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        nbtRoot.func_74778_a("Effect", SymbolEffect.REGISTRY.getKey(this.getEffectID()).toString());
        nbtRoot.func_74768_a("Lifetime", this.lifetime);
        nbtRoot.func_74768_a("Level", this.effectLevel);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.lifetime = tag.func_74762_e("Lifetime");
        if (tag.func_74764_b("EffectID")) {
            this.setEffectID(SymbolEffect.REGISTRY.getIdByKey(new ResourceLocation(tag.func_74779_i("Effect"))));
        } else {
            this.func_70106_y();
        }
        this.effectLevel = Math.max(tag.func_74762_e("Level"), 1);
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean canDeflect;
        if (par1DamageSource == DamageSource.field_76380_i) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        this.func_70018_K();
        Entity entity = par1DamageSource.func_76346_g();
        boolean bl = canDeflect = entity != null && SymbolEffect.REGISTRY.get(this.getEffectID()).getCanDeflect() && entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184614_ca().func_77973_b() == WitcheryGeneralItems.MYSTIC_BRANCH || ((EntityPlayer)entity).func_184592_cb().func_77973_b() == WitcheryGeneralItems.MYSTIC_BRANCH);
        if (canDeflect) {
            Vec3d vec3 = par1DamageSource.func_76346_g().func_70040_Z();
            this.field_70159_w = vec3.field_72450_a;
            this.field_70181_x = vec3.field_72448_b;
            this.field_70179_y = vec3.field_72449_c;
            this.accelerationX = this.field_70159_w * 0.1;
            this.accelerationY = this.field_70181_x * 0.1;
            this.accelerationZ = this.field_70179_y * 0.1;
            if (par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)par1DamageSource.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public int func_70070_b() {
        return 0xF000F0;
    }

    public ITextComponent func_145748_c_() {
        ResourceLocation key = SymbolEffect.REGISTRY.getKey(this.getEffectID());
        return new TextComponentTranslation("spell." + key.func_110624_b() + "." + key.func_110623_a(), new Object[0]);
    }
}

