/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.entity.ColoredSpiritEntity;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.entity.ai.EntityAIFlyingTempt;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntitySpirit
extends EntityFlyingTameable
implements ColoredSpiritEntity {
    private static final Ingredient TEMPTATIONS = Ingredient.func_193367_a((Item)WitcheryFumeItems.FOCUSED_WILL);
    public final EntityAIFlyingTempt aiTempt;
    private int lifetime = -1;
    private int spiritType;

    public EntitySpirit(World world) {
        super(world);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        ((PathNavigateFlying)this.func_70661_as()).func_192877_c(true);
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, TEMPTATIONS, true);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(5, new EntityAIFlyerFollowOwner<EntitySpirit>(this, 14.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.NONE));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public void setTarget(int type2) {
        BlockPos pos;
        IChunkGenerator cp;
        this.lifetime = 200;
        this.spiritType = type2;
        IChunkGenerator iChunkGenerator = cp = this.field_70170_p.func_72863_F() instanceof ChunkProviderServer ? ((ChunkProviderServer)this.field_70170_p.func_72863_F()).field_186029_c : null;
        if (cp != null && (pos = cp.func_180513_a(this.field_70170_p, this.field_70170_p.field_73011_w.func_186058_p() == DimensionType.NETHER ? "Fortress" : "Village", this.func_180425_c(), false)) != null) {
            this.homeX = pos.func_177958_n();
            this.homeY = pos.func_177956_o();
            this.homeZ = pos.func_177952_p();
            this.waypoint = new ItemStack(WitcheryIngredientItems.WAYSTONE);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("Lifetime", this.lifetime);
        tag.func_74768_a("SpiritType", this.spiritType);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.lifetime = tag.func_74762_e("Lifetime");
        this.spiritType = tag.func_74762_e("SpiritType");
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K && this.lifetime != -1 && --this.lifetime == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70628_a(false, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (this.spiritType == 2) {
            return;
        }
        ItemStack stack = this.spiritType == 1 ? new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT_VILLAGE) : new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT);
        this.func_70099_a(stack, 0.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.addParticle();
        }
    }

    private void addParticle() {
        int color2 = this.getColor();
        float red = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color2 & 0xFF) / 255.0f;
        WitcheryResurrectedClient.INSTANCE.addNaturePowerParticle(this.field_70170_p, this.field_70165_t - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.1 + this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 0.2, this.field_70161_v - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, red, green, blue, 10, -0.1f);
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public boolean func_70877_b(ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151103_aS;
    }

    public boolean func_70878_b(EntityAnimal animal) {
        return false;
    }

    @Override
    public int getColor() {
        return 0xFFCC00;
    }

    public boolean func_70601_bi() {
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            boolean superGetCanSpawnHere = this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            superGetCanSpawnHere = superGetCanSpawnHere && this.func_180484_a(pos) >= 0.0f && j >= 60;
            Block blockID = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
            return superGetCanSpawnHere && this.field_70170_p.field_73012_v.nextInt(10) == 0 && (blockID == Blocks.field_150349_c || blockID == Blocks.field_150354_m) && this.field_70170_p.func_175699_k(pos) > 8;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

