/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.entity.ai.EntityAITreefydWander;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class EntityTreefyd
extends EntityMob
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityTreefyd.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> SENTINAL = EntityDataManager.func_187226_a(EntityTreefyd.class, (DataSerializer)DataSerializers.field_187198_h);
    private static Set<Class<? extends Entity>> groupables;
    private final Set<UUID> knownPlayers = new LinkedHashSet<UUID>();
    private final Set<Class<? extends Entity>> knownCreatureTypes = new LinkedHashSet<Class<? extends Entity>>();
    private final Set<UUID> knownCreatures = new LinkedHashSet<UUID>();

    public EntityTreefyd(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITreefydWander(this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> {
            if (entity.getClass() == ((Object)((Object)this)).getClass() || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityFlying || entity instanceof EntityFlyingTameable || entity instanceof EntityAmbientCreature || entity instanceof EntityWaterMob || this.isFamiliar((Entity)entity) || entity instanceof EntityCovenWitch || entity instanceof EntitySleepingBody) {
                return false;
            }
            if (entity instanceof EntityPlayer && (entity.func_110124_au().equals(this.func_184753_b()) || this.knownPlayers.contains(entity.func_110124_au()))) {
                return false;
            }
            if (this.knownCreatures.contains(entity.func_110124_au())) {
                return false;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving creature2 = (EntityLiving)entity;
                return !this.knownCreatureTypes.contains(creature2.getClass());
            }
            return true;
        }));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        block31: {
            block33: {
                ItemStack stack;
                block32: {
                    if (this.field_70170_p.field_72995_K || hand != EnumHand.MAIN_HAND || !player.func_110124_au().equals(this.func_184753_b())) break block31;
                    stack = player.func_184586_b(hand);
                    if (stack.func_77973_b() != WitcheryGeneralItems.BOUND_TAGLOCK_KIT) break block32;
                    this.func_70624_b(null);
                    Class<? extends Entity> boundEntityType = ItemTaglockKit.getBoundEntityType(stack, 0);
                    UUID id = ItemTaglockKit.getBoundCreatureID(stack, 0);
                    if (boundEntityType == EntityPlayer.class) {
                        if (!player.func_110124_au().equals(id)) {
                            if (!player.func_70093_af() && !this.knownPlayers.contains(id)) {
                                this.knownPlayers.add(id);
                            } else {
                                if (!player.func_70093_af() || !this.knownPlayers.contains(id)) {
                                    this.showCurrentKnownEntities(player);
                                    return super.func_184645_a(player, hand);
                                }
                                this.knownPlayers.remove(id);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                            this.showCurrentKnownEntities(player);
                            return true;
                        }
                        break block33;
                    } else {
                        if (!id.equals(this.func_110124_au())) {
                            if (this.isGroupableCreature(boundEntityType)) {
                                if (!player.func_70093_af() && !this.knownCreatureTypes.contains(boundEntityType)) {
                                    this.knownCreatureTypes.add(boundEntityType);
                                } else {
                                    if (!player.func_70093_af() || !this.knownCreatureTypes.contains(boundEntityType)) {
                                        this.showCurrentKnownEntities(player);
                                        return super.func_184645_a(player, hand);
                                    }
                                    this.knownCreatureTypes.remove(boundEntityType);
                                }
                            } else if (!player.func_70093_af() && !this.knownCreatures.contains(id)) {
                                this.knownCreatures.add(id);
                            } else {
                                if (!player.func_70093_af() || !this.knownCreatures.contains(id)) {
                                    this.showCurrentKnownEntities(player);
                                    return super.func_184645_a(player, hand);
                                }
                                this.knownCreatures.remove(id);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                        }
                        this.showCurrentKnownEntities(player);
                        return true;
                    }
                }
                if (stack.func_77973_b() == WitcheryIngredientItems.TREEFYD_SEEDS) {
                    if (!this.field_70170_p.field_72995_K) {
                        EntityTreefyd entity = new EntityTreefyd(this.field_70170_p);
                        entity.func_70012_b(0.5 + this.field_70165_t, this.field_70163_u, 0.5 + this.field_70161_v, 0.0f, 0.0f);
                        entity.func_180482_a(this.field_70170_p.func_175649_E(entity.func_180425_c()), null);
                        entity.setOwnerId(player.func_110124_au());
                        entity.func_110163_bv();
                        entity.knownPlayers.addAll(this.knownPlayers);
                        entity.knownCreatureTypes.addAll(this.knownCreatureTypes);
                        entity.knownCreatures.addAll(this.knownCreatures);
                        this.field_70170_p.func_72838_d((Entity)entity);
                        this.func_184185_a(SoundEvents.field_187795_eZ, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                } else if (stack.func_77973_b() == WitcheryIngredientItems.CREEPER_HEART) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
                        this.func_70606_j(this.func_110138_aP());
                        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                        this.func_184185_a(SoundEvents.field_187795_eZ, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                } else if (stack.func_77973_b() == Item.func_150898_a((Block)WitcheryBlocks.DEMON_HEART)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
                        this.func_70606_j(this.func_110138_aP());
                        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
                        this.func_184185_a(SoundEvents.field_187525_aO, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                } else if (stack.func_77973_b() == WitcheryGeneralItems.BOLINE && !this.field_70170_p.field_72995_K) {
                    this.setSentinal(!this.isSentinal());
                }
            }
            this.showCurrentKnownEntities(player);
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    private void showCurrentKnownEntities(EntityPlayer player) {
        ITextComponent text2 = this.func_145748_c_().func_150258_a(" (");
        WorldServer serverWorld = (WorldServer)this.field_70170_p;
        PlayerProfileCache playerCache = serverWorld.func_73046_m().func_152358_ax();
        UUID ownerId = this.func_184753_b();
        int names = 0;
        if (ownerId != null) {
            Entity owner = this.func_70902_q();
            if (owner != null) {
                text2.func_150257_a(owner.func_145748_c_());
                ++names;
            } else {
                GameProfile gameProfile = playerCache.func_152652_a(ownerId);
                if (gameProfile != null) {
                    text2.func_150258_a(gameProfile.getName());
                    ++names;
                }
            }
        }
        for (UUID uUID : this.knownPlayers) {
            String name2;
            ITextComponent displayName;
            Entity otherPlayer = serverWorld.func_175733_a(uUID);
            if (otherPlayer == null) {
                GameProfile profile = playerCache.func_152652_a(uUID);
                String name3 = profile == null ? null : profile.getName();
                displayName = null;
            } else {
                name2 = null;
                displayName = otherPlayer.func_145748_c_();
            }
            if (displayName == null && name2 == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            if (displayName == null) {
                text2.func_150258_a(name2);
            } else {
                text2.func_150257_a(displayName);
            }
            ++names;
        }
        for (Class clazz : this.knownCreatureTypes) {
            EntityEntry entry2 = EntityRegistry.getEntry((Class)clazz);
            if (entry2 == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            text2.func_150258_a("#");
            text2.func_150257_a((ITextComponent)new TextComponentTranslation("entity." + entry2.getName() + ".name", new Object[0]));
            ++names;
        }
        for (UUID uUID : this.knownCreatures) {
            Entity entity = serverWorld.func_175733_a(uUID);
            if (entity == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            text2.func_150257_a(entity.func_145748_c_());
            ++names;
        }
        text2.func_150258_a(")");
        player.func_145747_a(text2);
    }

    private boolean isFamiliar(Entity entity) {
        if (Familiars.canBeFamiliar(entity)) {
            return Familiars.getFamiliarInstance(entity).isFamiliar();
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public boolean func_70652_k(Entity entity) {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_70644_a(MobEffects.field_76440_q)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0));
        }
        return super.func_70652_k(entity);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SENTINAL, (Object)false);
    }

    public boolean isSentinal() {
        return (Boolean)this.field_70180_af.func_187225_a(SENTINAL);
    }

    protected void setSentinal(boolean screaming) {
        this.field_70180_af.func_187227_b(SENTINAL, (Object)screaming);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        UUID ownerId = this.func_184753_b();
        if (ownerId != null) {
            tag.func_186854_a("Owner", ownerId);
        }
        if (!this.knownPlayers.isEmpty()) {
            NBTTagList players = new NBTTagList();
            for (UUID uUID : this.knownPlayers) {
                players.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.func_74782_a("KnownPlayers", (NBTBase)players);
        }
        if (!this.knownCreatureTypes.isEmpty()) {
            NBTTagList creatureTypes = new NBTTagList();
            for (Class clazz : this.knownCreatureTypes) {
                creatureTypes.func_74742_a((NBTBase)new NBTTagString(EntityList.func_191306_a((Class)clazz).toString()));
            }
            tag.func_74782_a("KnownCreatureTypes", (NBTBase)creatureTypes);
        }
        if (!this.knownCreatures.isEmpty()) {
            NBTTagList creatures = new NBTTagList();
            for (UUID uUID : this.knownCreatures) {
                creatures.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.func_74782_a("KnownCreatures", (NBTBase)creatures);
        }
        tag.func_74757_a("Sentinal", this.isSentinal());
    }

    public void func_70037_a(NBTTagCompound tag) {
        int i;
        super.func_70037_a(tag);
        if (tag.func_186855_b("Owner")) {
            this.setOwnerId(tag.func_186857_a("Owner"));
        }
        if (tag.func_74764_b("KnownPlayers")) {
            NBTTagList players = tag.func_150295_c("KnownPlayers", 10);
            this.knownPlayers.clear();
            for (i = 0; i < players.func_74745_c(); ++i) {
                this.knownPlayers.add(UUID.fromString(players.func_150307_f(i)));
            }
        }
        if (tag.func_74764_b("KnownCreatureTypes")) {
            NBTTagList creatureTypes = tag.func_150295_c("KnownCreatureTypes", 10);
            this.knownCreatureTypes.clear();
            for (i = 0; i < creatureTypes.func_74745_c(); ++i) {
                this.knownCreatureTypes.add(EntityList.getClass((ResourceLocation)new ResourceLocation(creatureTypes.func_150307_f(i))));
            }
        }
        if (tag.func_74764_b("KnownCreatures")) {
            NBTTagList creatures = tag.func_150295_c("KnownCreatures", 10);
            this.knownCreatures.clear();
            for (i = 0; i < creatures.func_74745_c(); ++i) {
                this.knownCreatures.add(UUID.fromString(creatures.func_150307_f(i)));
            }
        }
        this.setSentinal(tag.func_74767_n("Sentinal"));
    }

    private boolean isGroupableCreature(Class<? extends Entity> entity) {
        if (groupables == null) {
            groupables = new HashSet<Class<? extends Entity>>();
            this.addGroupableType(EntityVillager.class);
            this.addGroupableType(EntityGoblin.class);
            this.addGroupableType(EntitySheep.class);
            this.addGroupableType(EntityCow.class);
            this.addGroupableType(EntityMooshroom.class);
            this.addGroupableType(EntityChicken.class);
            this.addGroupableType(EntityPig.class);
            this.addGroupableType(EntityHorse.class);
        }
        return groupables.contains(entity);
    }

    private void addGroupableType(Class<? extends Entity> entity) {
        groupables.add(entity);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    @Nullable
    public Entity func_70902_q() {
        return WitcheryUtils.getPlayer(this.field_70170_p, this.func_184753_b());
    }

    public void setOwnerId(UUID owner) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)owner));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_TREEFYD_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

