/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBloodCrucible;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;

public class EntityVampire
extends EntityCreature
implements IHandleDeathTouch {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityVampire.class, (DataSerializer)DataSerializers.field_187192_b);
    float damageDone = 0.0f;
    private Village village;
    private BlockPos coffinPos = BlockPos.field_177992_a;

    public EntityVampire(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 0, false, true, entity -> entity instanceof EntityVillager && this.village != null));
        this.field_70728_aV = 20;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r()) {
                if (this.func_70643_av() == null) {
                    this.func_70624_b(null);
                }
                if (this.field_70173_aa % 100 == 2) {
                    this.village = null;
                    this.damageDone = 0.0f;
                    if (this.func_174818_b(this.coffinPos) > 16.0) {
                        this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                        EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos, 8);
                        this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                        this.func_175449_a(this.coffinPos, 4);
                    }
                }
                if (this.field_70173_aa % 20 == 2 && CreatureUtil.isInSunlight((EntityLivingBase)this)) {
                    this.func_70015_d(2);
                }
            } else if (this.damageDone >= 20.0f) {
                if (this.village != null) {
                    this.func_70624_b(null);
                    this.func_70604_c(null);
                    this.village = null;
                    this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos, 8);
                    this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    this.func_175449_a(this.coffinPos, 4);
                    this.tryFillBloodCrucible();
                }
            } else if (this.village == null && this.field_70173_aa % 500 == 2) {
                this.village = this.field_70170_p.field_72982_D.func_176056_a(this.func_180425_c(), 128);
                if (this.village != null) {
                    BlockPos townPos = this.village.func_180608_a();
                    this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, townPos, 8);
                    this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    this.func_175449_a(townPos, this.village.func_75568_b());
                }
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 1.6 - 0.8, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.5, this.field_70161_v + this.field_70146_Z.nextDouble() * 1.6 - 0.8, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void tryFillBloodCrucible() {
        int r = 6;
        for (int x = this.coffinPos.func_177958_n() - r; x <= this.coffinPos.func_177958_n() + r; ++x) {
            for (int z = this.coffinPos.func_177952_p() - r; z <= this.coffinPos.func_177952_p() + r; ++z) {
                for (int y = this.coffinPos.func_177956_o() - r; y <= this.coffinPos.func_177956_o() + r; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.field_70170_p.func_180495_p(pos).func_177230_c() != WitcheryBlocks.BLOOD_CRUCIBLE) continue;
                    TileEntityBloodCrucible crucible = WitcheryTileEntities.BLOOD_CRUCIBLE.getAt((IBlockAccess)this.field_70170_p, pos);
                    if (crucible != null) {
                        crucible.increaseBloodLevel();
                    }
                    return;
                }
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void setStalkingArea(int p_110171_1_, int p_110171_2_, int p_110171_3_) {
        this.coffinPos = new BlockPos(p_110171_1_, p_110171_2_, p_110171_3_);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected float func_70647_i() {
        return 0.6f;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (entity instanceof EntityVillager) {
            VillagerExtendedData villagerEx = WitcheryDataExtensions.VILLAGER.get((EntityVillager)entity);
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.damageDone += 4.0f;
                int taken = villagerEx.takeBlood(30, (EntityLivingBase)this);
                if (taken > 0) {
                    this.func_70691_i(4.0f);
                    this.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.8, entity.field_70161_v, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, this.func_184176_by(), 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.8, entity.field_70161_v, 0.5f, 0.2f, EnumParticleTypes.REDSTONE), entity);
                }
            }
            flag = true;
        } else {
            boolean needsBlood = this.damageDone < 20.0f;
            flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
            if (flag) {
                int j;
                if (i > 0) {
                    entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                    entity.func_70015_d(j * 4);
                }
                if (entity instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
                }
                EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            }
        }
        return flag;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    protected SoundEvent func_184588_d(int p_146067_1_) {
        return p_146067_1_ > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 0.0f;
    }

    public void func_70645_a(DamageSource source) {
        if (CreatureUtil.checkForVampireDeath((EntityLivingBase)this, source)) {
            return;
        }
        super.func_70645_a(source);
    }

    protected Item func_146068_u() {
        return Items.field_151097_aZ;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void addRandomArmor() {
        boolean male = this.field_70146_Z.nextBoolean();
        if (male) {
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)(this.field_70146_Z.nextInt(4) == 0 ? WitcheryEquipmentItems.VAMPIRE_HEELS : WitcheryEquipmentItems.VAMPIRE_SHOES)));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)(this.field_70146_Z.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_SKIRT : WitcheryEquipmentItems.VAMPIRE_TROUSERS)));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.field_70146_Z.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_CHESTPLATE : WitcheryEquipmentItems.VAMPIRE_WAIST_COAT)));
        } else {
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)(this.field_70146_Z.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_SHOES : WitcheryEquipmentItems.VAMPIRE_HEELS)));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)(this.field_70146_Z.nextInt(4) == 0 ? WitcheryEquipmentItems.VAMPIRE_TROUSERS : WitcheryEquipmentItems.VAMPIRE_SKIRT)));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.field_70146_Z.nextInt(3) == 0 ? WitcheryEquipmentItems.VAMPIRE_CHESTPLATE : WitcheryEquipmentItems.VAMPIRE_CORSET)));
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_180482_a(difficulty, p_110161_1_);
        this.addRandomArmor();
        this.coffinPos = this.func_180425_c();
        return p_110161_1_;
    }

    public int getGuardType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setGuardType(int p_82201_1_) {
        this.field_70180_af.func_187227_b(TYPE, (Object)p_82201_1_);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        if (nbtRoot.func_150297_b("GuardType", 99)) {
            byte b0 = nbtRoot.func_74771_c("GuardType");
            this.setGuardType(b0);
        }
        this.coffinPos = new BlockPos(nbtRoot.func_74762_e("BaseX"), nbtRoot.func_74762_e("BaseY"), nbtRoot.func_74762_e("BaseZ"));
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        nbtRoot.func_74774_a("GuardType", (byte)this.getGuardType());
        BlockPos home = this.func_180486_cf();
        nbtRoot.func_74768_a("BaseX", this.coffinPos.func_177958_n());
        nbtRoot.func_74768_a("BaseY", this.coffinPos.func_177956_o());
        nbtRoot.func_74768_a("BaseZ", this.coffinPos.func_177952_p());
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }
}

