/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.GlobalPos;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.ai.EntityAIDefendVillageGeneric;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.world.gen.structure.PointOfInterests;

public class EntityVillageGuard
extends EntityCreature
implements IRangedAttackMob,
EntityAIDefendVillageGeneric.IVillageGuard {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityVillageGuard.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BLOOD = EntityDataManager.func_187226_a(EntityVillageGuard.class, (DataSerializer)DataSerializers.field_187192_b);
    private final EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged(this, 1.0, 20, 15.0f){

        public void func_75249_e() {
            super.func_75249_e();
            EntityVillageGuard.this.func_184724_a(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityVillageGuard.this.func_184724_a(false);
        }
    };
    private final EntityAINearestAttackableTarget<EntityPlayer> aiAttackOnCollide = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false);
    Village village;
    private int homeCheckTimer;

    public EntityVillageGuard(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDefendVillageGeneric(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> {
            if (entity instanceof EntityVindicator) {
                return !entity.func_184614_ca().func_190926_b();
            }
            if (entity instanceof IMob && !(entity instanceof EntityWitchHunter) || entity instanceof EntityGoblin) {
                return true;
            }
            if (this.village != null && entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                EntityLivingBase target = player.func_70643_av();
                return target instanceof EntityPlayer && this.village.getPlayerReputation(target.func_110124_au()) == 10;
            }
            return false;
        }));
        if (!world.field_72995_K) {
            this.setCombatTask();
        }
        this.field_70728_aV = 5;
    }

    public static void createFrom(EntityVillager villager) {
        World world = villager.field_70170_p;
        EntityVillageGuard entity = new EntityVillageGuard(world);
        entity.func_110163_bv();
        entity.func_82149_j((Entity)villager);
        entity.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
        GlobalPos home = WitcheryDataExtensions.VILLAGER.get(villager).getHome();
        if (home != null) {
            WorldServer otherWorld = world.func_73046_m().func_71218_a(home.getDimension());
            PointOfInterests.INSTANCE.release((World)otherWorld, home.getPos());
        }
        world.func_72900_e((Entity)villager);
        world.func_72838_d((Entity)entity);
        world.func_72960_a((Entity)entity, (byte)5);
    }

    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t + this.field_70146_Z.nextDouble() * 1.2 - 0.6, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.8, this.field_70161_v + this.field_70146_Z.nextDouble() * 1.2 - 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> p_70686_1_) {
        return EntityCreeper.class != p_70686_1_ && this.getClass() != p_70686_1_;
    }

    public int getBlood() {
        return (Integer)this.field_70180_af.func_187225_a(BLOOD);
    }

    public void setBlood(int blood) {
        this.field_70180_af.func_187227_b(BLOOD, (Object)MathHelper.func_76125_a((int)blood, (int)0, (int)500));
    }

    public int takeBlood(int quantity, EntityLivingBase player) {
        PotionEffect effect = this.func_70660_b(WitcheryPotionEffects.PARALYSED);
        boolean transfixed = effect != null && effect.func_76458_c() >= 4;
        int blood = this.getBlood();
        quantity = (int)Math.ceil(0.66f * (float)quantity);
        int remainder = Math.max(blood - quantity, 0);
        int taken = blood - remainder;
        this.setBlood(remainder);
        if (blood < (int)Math.ceil(250.0)) {
            this.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)player), 2.0f);
        } else if (!transfixed) {
            this.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)player), 0.5f);
        }
        return taken;
    }

    public void giveBlood(int quantity) {
        int blood = this.getBlood();
        if (blood < 500) {
            this.setBlood(blood + quantity);
        }
    }

    @Override
    public Village getVillage() {
        return this.village;
    }

    @Override
    public EntityCreature getCreature() {
        return this;
    }

    protected void func_70619_bc() {
        int homeCheckTimer;
        this.homeCheckTimer = homeCheckTimer = this.homeCheckTimer - 1;
        if (homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            this.village = this.field_70170_p.field_72982_D.func_176056_a(this.func_180425_c(), 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos chunkcoordinates = this.village.func_180608_a();
                this.func_175449_a(chunkcoordinates, (int)((float)this.village.func_75568_b() * 1.5f));
                if (this.func_70638_az() == null) {
                    this.func_70691_i(1.0f);
                    if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
                        this.giveBlood(1);
                    }
                }
            }
        }
        super.func_70619_bc();
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(BLOOD, (Object)500);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected float func_70647_i() {
        return 0.8f;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return (source == DamageSource.field_76380_i || source.func_180136_u() || source.func_76346_g() == null || !(source.func_76346_g() instanceof EntityVillageGuard) && !(source.func_76346_g() instanceof EntityWitchHunter)) && super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (p_70652_1_ instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)p_70652_1_).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                p_70652_1_.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                p_70652_1_.func_70015_d(j * 4);
            }
            if (p_70652_1_ instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)p_70652_1_), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)p_70652_1_);
        }
        return flag;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    protected SoundEvent func_184588_d(int p_146067_1_) {
        return p_146067_1_ > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        if (this.field_70717_bb != null && this.village != null) {
            this.village.modifyPlayerReputation(this.field_70717_bb.func_110124_au(), -5);
        }
        super.func_70645_a(p_70645_1_);
    }

    protected Item func_146068_u() {
        return Items.field_151032_g;
    }

    protected void addRandomArmor() {
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)(this.field_70146_Z.nextInt(5) == 0 ? Items.field_151030_Z : Items.field_151027_R)));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)(this.field_70146_Z.nextInt(5) == 0 ? Items.field_151028_Y : Items.field_151024_Q)));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_180482_a(difficulty, p_110161_1_);
        this.addRandomArmor();
        return p_110161_1_;
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a(this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151031_f) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, this.aiAttackOnCollide);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        PotionEffect effect = this.func_70660_b(WitcheryPotionEffects.PARALYSED);
        if (effect != null && effect.func_76458_c() >= 4) {
            return;
        }
        EntityArrow entityarrow = ((ItemArrow)Items.field_151032_g).func_185052_a(this.field_70170_p, new ItemStack(Items.field_151032_g), (EntityLivingBase)this);
        double x = target.field_70165_t - this.field_70165_t;
        double y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        double horizontalSpeed = MathHelper.func_76133_a((double)(x * x + z * z));
        int difficulty = target instanceof EntityPlayer ? this.field_70170_p.func_175659_aa().func_151525_a() : 4 - this.field_70170_p.func_175659_aa().func_151525_a();
        entityarrow.func_70186_c(x, y + horizontalSpeed * 0.2, z, 1.6f, (float)(16 - difficulty * 4));
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.func_184614_ca());
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.func_184614_ca());
        entityarrow.func_70239_b((double)(distanceFactor * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)difficulty * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.func_184614_ca()) > 0) {
            entityarrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public void func_184724_a(boolean b) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)b);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        this.setCombatTask();
        if (nbtRoot.func_74764_b("BloodLevel")) {
            this.setBlood(nbtRoot.func_74762_e("BloodLevel"));
        }
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        nbtRoot.func_74768_a("BloodLevel", this.getBlood());
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }
}

