/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWerewolf
extends EntityMob {
    public EnumHand activeHand;
    boolean isSitting;
    private int attackTimer;
    @Nullable
    private NBTTagCompound villagerData;
    private boolean infectious;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation skinOverride;

    public EntityWerewolf(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, target -> !ShapeShift.INSTANCE.isAnimalForm((EntityPlayer)target)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false, false, null));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWitchHunter.class, true));
        this.field_70728_aV = 20;
    }

    public static void convertToVillager(EntityLiving target, NBTTagCompound data2, boolean infectious) {
        if (target != null && !target.field_70170_p.field_72995_K) {
            EntityWereVillager entity = new EntityWereVillager(target.field_70170_p, data2, infectious);
            entity.func_82187_q();
            EntityWerewolf.setProperties((EntityLiving)entity, target);
        }
    }

    public static void convertToCuredVillager(EntityLiving target, NBTTagCompound data2) {
        if (target != null && !target.field_70170_p.field_72995_K) {
            EntityVillager entity = new EntityVillager(target.field_70170_p);
            entity.func_70037_a(data2);
            entity.func_82187_q();
            EntityWerewolf.setProperties((EntityLiving)entity, target);
        }
    }

    public static void setProperties(EntityLiving entity, EntityLiving original) {
        entity.func_82149_j((Entity)original);
        entity.func_110163_bv();
        original.field_70170_p.func_72900_e((Entity)original);
        original.field_70170_p.func_72838_d((Entity)entity);
        original.field_70170_p.func_175718_b(1017, original.func_180425_c(), 0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(boolean p_70904_1_) {
        this.isSitting = p_70904_1_;
    }

    public int func_70658_aO() {
        int i = super.func_70658_aO() + 10;
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    public void func_70636_d() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.villagerData != null && this.field_70173_aa % 100 == 3 && !WitcheryUtils.isFullMoon(this.field_70170_p) && !this.func_70644_a(WitcheryPotionEffects.WOLFSBANE)) {
                EntityWerewolf.convertToVillager((EntityLiving)this, this.villagerData, this.infectious);
            } else if (this.field_70173_aa % 40 == 4 && this.func_70644_a(MobEffects.field_76436_u)) {
                this.func_184589_d(MobEffects.field_76436_u);
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (CreatureUtil.isSilverDamage(source)) {
            return super.func_70097_a(source, WitcheryUtils.capAround(damage * 1.5f, 15.0f));
        }
        return super.func_70097_a(source, WitcheryUtils.capAround(damage, 1.0f));
    }

    public boolean func_70652_k(Entity targetEntity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return super.func_70652_k(targetEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.func_70103_a(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 4;
    }

    protected SoundEvent func_184639_G() {
        return this.field_70170_p.field_73012_v.nextInt(20) == 0 ? WitcherySounds.ENTITY_WEREWOLF_HOWL : WitcherySounds.ENTITY_WEREWOLF_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_WEREWOLF_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_WEREWOLF_DEATH;
    }

    protected void func_70628_a(boolean p_70628_1_, int fortune) {
        super.func_70628_a(p_70628_1_, fortune);
    }

    protected Item func_146068_u() {
        return Items.field_151103_aS;
    }

    public NBTTagCompound getVillagerData() {
        return this.villagerData;
    }

    public void setVillagerData(NBTTagCompound data2) {
        this.villagerData = data2;
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        if (this.villagerData != null) {
            nbtRoot.func_74782_a("VillagerData", (NBTBase)this.villagerData);
        }
        nbtRoot.func_74757_a("Infectious", this.infectious);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        if (nbtRoot.func_74764_b("VillagerData")) {
            this.villagerData = nbtRoot.func_74775_l("VillagerData");
        }
        this.infectious = nbtRoot.func_74767_n("Infectious");
    }

    public void setInfectious() {
        this.infectious = true;
    }

    public boolean isInfectious() {
        return this.infectious;
    }

    public void func_70074_a(EntityLivingBase targetEntity) {
        super.func_70074_a(targetEntity);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_184598_c(EnumHand hand) {
        this.activeHand = hand;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkinResource() {
        return this.skinOverride;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSkinResource(ResourceLocation skinOverride) {
        this.skinOverride = skinOverride;
    }
}

