/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerMate;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.entity.ai.EntityAIFlyingTempt;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.Waypoint;

public class EntityWingedMonkey
extends EntityFlyingTameable {
    private static final DataParameter<Integer> TAME_SKIN = EntityDataManager.func_187226_a(EntityWingedMonkey.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FEATHER_COLOR = EntityDataManager.func_187226_a(EntityWingedMonkey.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient TEMPTATIONS = Ingredient.func_193368_a((Item[])new Item[]{Items.field_151147_al, Items.field_151082_bd});
    private int attackTimer;

    public EntityWingedMonkey(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.ENTITY_LIVING));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFlyingTempt((EntityCreature)this, TEMPTATIONS, true));
        this.field_70714_bg.func_75776_a(5, new EntityAIFlyerFollowOwner<EntityWingedMonkey>(this, 14.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFlyerMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + 5;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        nbtRoot.func_74774_a("FeatherColor", (byte)this.getFeatherColor());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        if (nbtRoot.func_74764_b("FeatherColor")) {
            this.setFeatherColor(nbtRoot.func_74771_c("FeatherColor"));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAME_SKIN, (Object)0);
        this.field_70180_af.func_187214_a(FEATHER_COLOR, (Object)(this.field_70170_p.field_73012_v.nextInt(100) == 0 ? 0 : this.field_70170_p.field_73012_v.nextInt(15) + 1));
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 6) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        int var3 = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + lootingModifier);
        for (int var4 = 0; var4 < var3; ++var4) {
            this.func_70099_a(new ItemStack(Items.field_151008_G), 0.0f);
        }
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_MONKEY_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_MONKEY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_MONKEY_DEATH;
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        this.func_70904_g(false);
        return super.func_70097_a(par1DamageSource, par2);
    }

    public double func_70042_X() {
        return !this.func_184188_bt().isEmpty() ? (double)(-((Entity)this.func_184188_bt().get((int)0)).field_70131_O) * 0.6 : 0.0;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (this.func_152114_e((EntityLivingBase)player) && !this.func_70877_b(itemstack)) {
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151100_aR) {
                    if (!this.field_70170_p.field_72995_K) {
                        int i = EnumDyeColor.func_176766_a((int)itemstack.func_77952_i()).func_176765_a();
                        this.setFeatherColor(i);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                    }
                } else {
                    if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151057_cb && itemstack.func_77973_b() != WitcheryGeneralItems.POLYNESIA_CHARM && itemstack.func_77973_b() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
                        return false;
                    }
                    if (itemstack.func_77973_b() == WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE || itemstack.func_77973_b() == WitcheryIngredientItems.BOUND_WAYSTONE) {
                        this.waypoint = itemstack.func_77946_l();
                        this.homeX = 0.0;
                        this.homeY = 0.0;
                        this.homeZ = 0.0;
                        Waypoint wp = this.getWaypoint();
                        this.homeX = wp.x;
                        this.homeY = wp.y;
                        this.homeZ = wp.z;
                        TeleportationUtil.bindToLocation(this.func_180425_c(), this.field_70170_p.field_73011_w.getDimension(), this.waypoint);
                        if (!this.field_70170_p.field_72995_K && this.func_70906_o()) {
                            this.field_70911_d.func_75270_a(false);
                        }
                        player.func_184220_m((Entity)this);
                        this.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    } else if (!itemstack.func_190926_b() && ItemTaglockKit.isTaglockPresent(itemstack, 0)) {
                        this.waypoint = itemstack.func_77946_l();
                        this.homeX = this.field_70165_t;
                        this.homeY = this.field_70163_u;
                        this.homeZ = this.field_70161_v;
                        this.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                    } else if (this.func_70068_e((Entity)player) < 9.0 && !this.field_70170_p.field_72995_K) {
                        if (!this.func_70906_o()) {
                            this.func_70661_as().func_75499_g();
                        }
                        this.field_70911_d.func_75270_a(!this.func_70906_o());
                    }
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(10.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        if (!itemstack.func_190926_b() && (itemstack.func_77973_b() == Items.field_151147_al || itemstack.func_77973_b() == Items.field_151082_bd) && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.setTameSkin(1 + this.field_70170_p.field_73012_v.nextInt(3));
                    this.func_193101_c(player);
                    this.func_110163_bv();
                    this.func_70908_e(true);
                    this.func_70661_as().func_75499_g();
                    this.func_70904_g(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return !this.func_70877_b(itemstack) && super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack itemstack) {
        return !itemstack.func_190926_b() && (itemstack.func_77973_b() == Items.field_151147_al || itemstack.func_77973_b() == Items.field_151082_bd);
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityWingedMonkey)) {
            return false;
        }
        EntityWingedMonkey entityocelot = (EntityWingedMonkey)par1EntityAnimal;
        return entityocelot.func_70909_n() && this.func_70880_s() && entityocelot.func_70880_s();
    }

    public int getFeatherColor() {
        return (Integer)this.field_70180_af.func_187225_a(FEATHER_COLOR) & 0xF;
    }

    public void setFeatherColor(int color2) {
        this.field_70180_af.func_187227_b(FEATHER_COLOR, (Object)(color2 & 0xF));
    }

    public int getTameSkin() {
        return (Integer)this.field_70180_af.func_187225_a(TAME_SKIN);
    }

    public void setTameSkin(int par1) {
        this.field_70180_af.func_187227_b(TAME_SKIN, (Object)par1);
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
            return false;
        }
        if (this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (j < 63) {
                return false;
            }
            BlockPos pos = new BlockPos(i, j - 1, k);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150349_c) {
                return true;
            }
            state.func_177230_c();
            return state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, pos);
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityWingedMonkey monkey = new EntityWingedMonkey(this.field_70170_p);
        if (this.func_70909_n()) {
            monkey.func_110163_bv();
            monkey.setTameSkin(this.getTameSkin());
            monkey.setFeatherColor(this.getFeatherColor());
        }
        return monkey;
    }
}

