/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryBoltItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemCrossbowPistol;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWitchHunter
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityWitchHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final double HUNTER_NOTICE_CHANCE = 0.1;
    private static final long HUNTER_DELAY = 2400L;
    private static final double HUNTER_TRIGGER_CHANCE = 0.01;
    private final EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 15.0f);
    private final EntityAINearestAttackableTarget<EntityLivingBase> aiAttackOnCollide = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false);
    private String targetPlayerName;

    public EntityWitchHunter(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, entity -> CreatureUtil.isUndead((Entity)entity) || CreatureUtil.isDemonic((Entity)entity) || entity instanceof EntityWitch || CreatureUtil.isWerewolf((Entity)entity) || entity instanceof EntityPlayer && (CreatureUtil.isWitch((Entity)entity) || CreatureUtil.isWerewolf((Entity)entity) || CreatureUtil.isVampire((Entity)entity) || this.targetPlayerName != null && !this.targetPlayerName.isEmpty() && entity.func_70005_c_().equals(this.targetPlayerName))));
        this.field_70728_aV = 5;
        this.targetPlayerName = "";
        if (!par1World.field_72995_K) {
            this.setCombatTask();
        }
    }

    public static void blackMagicPerformed(EntityPlayer player) {
        NBTTagCompound nbtPlayer;
        if (player != null && player.field_70170_p != null && !player.field_70170_p.field_72995_K && (nbtPlayer = player.getEntityData()) != null && nbtPlayer.func_74763_f("WitcheryHunterTrigger") <= 0L && player.field_70170_p.field_73012_v.nextDouble() < 0.1) {
            long totalWorldTicks = MinecraftServer.func_130071_aq() / 50L;
            nbtPlayer.func_74772_a("WitcheryHunterTrigger", totalWorldTicks);
        }
    }

    public static void handleWitchHunterEffects(EntityPlayer player) {
        NBTTagCompound nbtPlayer = player.getEntityData();
        long triggerTimeTicks = nbtPlayer.func_74763_f("WitcheryHunterTrigger");
        if (triggerTimeTicks > 0L && player.field_70170_p.func_82737_E() >= triggerTimeTicks + 2400L && player.field_70170_p.field_73012_v.nextDouble() < 0.01 || EntityWitchHunter.isVampireActive(player)) {
            nbtPlayer.func_82580_o("WitcheryHunterTrigger");
            int MAX_SPAWNS = 2;
            int tries = 3;
            int spawned = 0;
            for (int i = 0; i < tries && spawned < MAX_SPAWNS; ++i) {
                EntityWitchHunter creature2 = Infusion.spawnCreature(player.field_70170_p, EntityWitchHunter.class, player.func_180425_c(), (EntityLivingBase)player, 3, 8, EnumParticleTypes.SMOKE_NORMAL, null);
                if (creature2 == null) continue;
                ++spawned;
                creature2.targetPlayerName = player.func_70005_c_();
                creature2.func_180482_a(player.field_70170_p.func_175649_E(creature2.func_180425_c()), null);
                EntityUtil.setTarget((EntityLiving)creature2, (EntityLivingBase)player);
            }
            if (spawned > 0) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_HUNTER_COMING, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isVampireActive(EntityPlayer player) {
        Village village;
        if (WitcheryConfigOptions.vampireHunterSpawnChance <= 0.0 || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        if (playerEx.getTransformation(WitcheryCreatureTraits.VAMPIRE).getLevel() < 10) {
            return false;
        }
        if (player.field_70170_p.field_73012_v.nextDouble() * 100.0 < WitcheryConfigOptions.vampireHunterSpawnChance && (village = player.field_70170_p.field_72982_D.func_176056_a(player.func_180425_c(), 128)) != null && village.getPlayerReputation(player.func_110124_au()) < -1) {
            List hunters = player.field_70170_p.func_72872_a(EntityWitchHunter.class, player.func_174813_aQ().func_72321_a(64.0, 16.0, 64.0));
            return hunters.size() == 0;
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187579_bV, 0.15f, 1.0f);
    }

    public boolean func_70652_k(Entity targetEntity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                targetEntity.func_70015_d(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 2 && this.func_70644_a(MobEffects.field_76436_u)) {
            this.func_184589_d(MobEffects.field_76436_u);
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource.func_76346_g() != null && (damageSource.func_76346_g() instanceof EntityVillageGuard || damageSource.func_76346_g() instanceof EntityWitchHunter)) {
            return false;
        }
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!super.func_70097_a(damageSource, WitcheryUtils.capAround(damage, 9.0f))) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) != entity && this.func_184187_bx() != entity) {
            if (entity != this && entity instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return true;
    }

    protected SoundEvent func_184588_d(int distance) {
        return distance > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3 + par2);
        for (int k = 0; k < j; ++k) {
            this.func_70099_a(new ItemStack((Item)WitcheryBoltItems.WOODEN_BOLT), 0.0f);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setHunterType(this.field_70170_p.field_73012_v.nextInt(3));
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)WitcheryGeneralItems.CROSSBOW_PISTOL));
        this.func_180483_b(difficulty);
        return livingdata;
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a(this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == WitcheryGeneralItems.CROSSBOW_PISTOL) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, this.aiAttackOnCollide);
        }
    }

    public void func_82196_d(EntityLivingBase target, float par2) {
        ItemCrossbowPistol.Companion.launchNPCBolt(this.func_184614_ca(), this.field_70170_p, target, (EntityLiving)this, par2);
    }

    public void func_184724_a(boolean b) {
    }

    public int getHunterType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setHunterType(int par1) {
        this.field_70180_af.func_187227_b(TYPE, (Object)par1);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        if (nbtRoot.func_74764_b("HunterType")) {
            byte b0 = nbtRoot.func_74771_c("HunterType");
            this.setHunterType(b0);
        }
        this.targetPlayerName = nbtRoot.func_74779_i("HunterTarget");
        this.setCombatTask();
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        nbtRoot.func_74774_a("HunterType", (byte)this.getHunterType());
        nbtRoot.func_74778_a("HunterTarget", this.targetPlayerName);
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (!this.field_70170_p.field_72995_K && slot == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_175699_k(pos);
        if (this.field_70170_p.func_72911_I()) {
            int i2 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            l = this.field_70170_p.func_175699_k(pos);
            this.field_70170_p.func_175692_b(i2);
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    protected boolean func_146066_aG() {
        return true;
    }
}

