/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCircle;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockLog;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityWitchProjectile
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityWitchProjectile.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityWitchProjectile(World world) {
        super(world);
    }

    public EntityWitchProjectile(World world, EntityLivingBase entityLiving, ItemStack item) {
        super(world, entityLiving);
        this.setStack(item);
    }

    public EntityWitchProjectile(World world, double posX, double posY, double posZ, ItemStack item) {
        super(world, posX, posY, posZ);
        this.setStack(item);
    }

    public static void explodeIceBlock(World world, BlockPos pos, Entity entity) {
        boolean resistent;
        pos = pos.func_177977_b();
        Block block = Blocks.field_150432_aD;
        boolean bl = resistent = entity instanceof EntityDemon || entity instanceof EntityBlaze || entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityWither || entity instanceof EntityIronGolem;
        if (resistent) {
            EntityWitchProjectile.setBlockIfNotSolid(world, pos.func_177984_a(), (Block)Blocks.field_150358_i);
        } else {
            int HEIGHT = 4;
            for (int i = 0; i < HEIGHT; ++i) {
                BlockPos up = pos.func_177981_b(i);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-2, 0, -1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177985_f(2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-1, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177968_d(), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177974_f(), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(1, 0, -1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177964_d(2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-1, 0, -2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-2, 0, -2), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-2, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(1, 0, 1), block);
                EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(1, 0, -2), block);
            }
            EntityWitchProjectile.setBlockIfNotSolid(world, pos, block);
            BlockPos up = pos.func_177981_b(HEIGHT - 1);
            EntityWitchProjectile.setBlockIfNotSolid(world, up, block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177982_a(-1, 0, -1), block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177976_e(), block);
            EntityWitchProjectile.setBlockIfNotSolid(world, up.func_177978_c(), block);
            if (entity instanceof EntityCreeper) {
                EntityCreeper creeper = (EntityCreeper)entity;
                boolean flag = world.func_82736_K().func_82766_b("mobGriefing");
                if (creeper.func_70830_n()) {
                    world.func_72876_a((Entity)creeper, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, 6.0f, flag);
                } else {
                    world.func_72876_a((Entity)creeper, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, 3.0f, flag);
                }
                creeper.func_70106_y();
            }
        }
    }

    public static void explodeIceShield(World world, EntityLivingBase player, BlockPos pos, int height2) {
        double f1 = player != null ? (double)MathHelper.func_76134_b((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        double f2 = player != null ? (double)MathHelper.func_76126_a((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI)) : 0.0;
        Vec3d loc = new Vec3d(f2, 0.0, f1);
        if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            pos = pos.func_177977_b();
        }
        EntityWitchProjectile.explodeIceColumn(world, pos.func_177984_a(), height2);
        loc = loc.func_178785_b((float)Math.toRadians(90.0));
        EntityWitchProjectile.explodeIceColumn(world, pos.func_177963_a(loc.field_72450_a + 0.5, 1.0, loc.field_72449_c + 0.5), height2);
        loc = loc.func_178785_b((float)Math.toRadians(180.0));
        EntityWitchProjectile.explodeIceColumn(world, pos.func_177963_a(loc.field_72450_a + 0.5, 1.0, loc.field_72449_c + 0.5), height2);
    }

    public static void explodeIceColumn(World world, BlockPos pos, int height2) {
        for (int offsetPosY = 0; offsetPosY < height2; ++offsetPosY) {
            EntityWitchProjectile.setBlockIfNotSolid(world, pos.func_177981_b(height2), Blocks.field_150432_aD);
        }
    }

    public static void raiseDead(BlockPos pos, World world, EntityLivingBase raiser) {
        int y0 = world.func_180495_p(pos).func_185904_a().func_76220_a() ? pos.func_177956_o() : pos.func_177956_o() - 1;
        int MAX_DISTANCE = 3;
        int MAX_DROP = 6;
        EntityPlayer playerThrower = raiser instanceof EntityPlayer ? (EntityPlayer)raiser : null;
        EntityWitchProjectile.raiseUndead(world, new BlockPos(pos.func_177958_n(), y0, pos.func_177952_p()), playerThrower);
        int extraCount = 0;
        double chance = world.field_73012_v.nextDouble();
        if (chance < 0.1) {
            extraCount = 2;
        } else if (chance < 0.4) {
            extraCount = 1;
        }
        for (int i = 0; i < extraCount; ++i) {
            int x = pos.func_177958_n() - MAX_DISTANCE + world.field_73012_v.nextInt(MAX_DROP) + 1;
            int z = pos.func_177952_p() - MAX_DISTANCE + world.field_73012_v.nextInt(MAX_DROP) + 1;
            int y2 = -1;
            for (int dy = -MAX_DROP; dy < MAX_DROP; ++dy) {
                if (!world.func_180495_p(new BlockPos(x, y0 - dy, z)).func_185904_a().func_76220_a()) continue;
                y2 = y0 - dy;
                break;
            }
            if (y2 == -1) continue;
            EntityWitchProjectile.raiseUndead(world, new BlockPos(x, y2, z), playerThrower);
        }
    }

    private static void raiseUndead(World world, BlockPos pos, EntityPlayer thrower) {
        if (!world.field_72995_K) {
            Block blockID = world.func_180495_p(pos).func_177230_c();
            if (blockID != Blocks.field_150346_d && blockID != Blocks.field_150348_b && blockID != Blocks.field_150349_c && blockID != Blocks.field_150424_aL && blockID != Blocks.field_150391_bh && blockID != Blocks.field_150425_aM && blockID != Blocks.field_150347_e && blockID != Blocks.field_150351_n && blockID != Blocks.field_150354_m) {
                pos = pos.func_177984_a();
            }
            EntityWitchProjectile.spawnParticles(world, EnumParticleTypes.SMOKE_NORMAL, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
            world.func_175698_g(pos);
            world.func_175698_g(pos.func_177984_a());
            EntityLiving undeadEntity = EntityWitchProjectile.createUndeadCreature(world);
            undeadEntity.func_70012_b(0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 1.0f, 0.0f);
            undeadEntity.func_180482_a(world.func_175649_E(undeadEntity.func_180425_c()), null);
            undeadEntity.func_110163_bv();
            if (thrower != null) {
                PotionEnslaved.setEnslaverForMob(undeadEntity, thrower);
            }
            world.func_72838_d((Entity)undeadEntity);
        }
    }

    private static EntityLiving createUndeadCreature(World world) {
        double value = world.field_73012_v.nextDouble();
        if (value < 0.6) {
            return new EntityZombie(world);
        }
        if (value < 0.97) {
            return new EntitySkeleton(world);
        }
        return new EntityPigZombie(world);
    }

    public static void growBranch(BlockPos pos, World world, EnumFacing sideHit, int extent, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb;
        List list1;
        BlockPos p;
        int i;
        Block logBlock;
        IBlockState state = world.func_180495_p(pos);
        Block blockID = state.func_177230_c();
        int var = world.field_73012_v.nextInt(4);
        WitcheryWoodType type2 = null;
        WitcheryWoodType[] types = new WitcheryWoodType[]{WitcheryWoodTypes.ROWAN, WitcheryWoodTypes.ALDER, WitcheryWoodTypes.HAWTHORN};
        if (blockID == Blocks.field_150364_r || blockID == Blocks.field_150344_f || blockID == Blocks.field_150345_g || blockID == Blocks.field_150362_t) {
            logBlock = Blocks.field_150364_r;
        } else if (blockID instanceof WitcheryBlockLog || blockID instanceof WitcheryBlockPlanks || blockID instanceof WitcheryBlockSapling || blockID instanceof WitcheryBlockLeaves) {
            type2 = types[world.field_73012_v.nextInt(types.length)];
            logBlock = type2.getLog();
        } else {
            Block block;
            if (world.field_73012_v.nextBoolean()) {
                block = Blocks.field_150364_r;
            } else {
                type2 = types[world.field_73012_v.nextInt(types.length)];
                block = type2.getLog();
            }
            logBlock = block;
        }
        BlockLeaves leavesBlock = Blocks.field_150364_r == logBlock ? Blocks.field_150362_t : type2.getLeaves();
        IBlockState logState = logBlock.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)sideHit.func_176740_k()));
        boolean isInitialBlockSolid = state.func_185904_a().func_76220_a();
        int n = i = sideHit != EnumFacing.UP || isInitialBlockSolid ? 1 : 0;
        while (i < extent && (p = pos.func_177982_a(i * sideHit.func_176730_m().func_177958_n(), i * sideHit.func_176730_m().func_177956_o(), i * sideHit.func_176730_m().func_177952_p())).func_177956_o() < 255 && EntityWitchProjectile.setBlockIfNotSolid(world, p, logBlock == Blocks.field_150364_r ? logState.func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.values()[var]) : logState)) {
            int lz;
            int lx = sideHit.func_176740_k() != EnumFacing.Axis.X && world.field_73012_v.nextInt(4) == 0 ? world.field_73012_v.nextInt(3) - 1 : 0;
            int ly = sideHit.func_176740_k() != EnumFacing.Axis.Y && lx == 0 && world.field_73012_v.nextInt(4) == 0 ? world.field_73012_v.nextInt(3) - 1 : 0;
            int n2 = lz = sideHit.func_176740_k() != EnumFacing.Axis.Z && lx == 0 && ly == 0 && world.field_73012_v.nextInt(4) == 0 ? world.field_73012_v.nextInt(3) - 1 : 0;
            if (lx != 0 || ly != 0 || lz != 0) {
                EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177982_a(lx, ly, lz), leavesBlock == Blocks.field_150362_t ? leavesBlock.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.values()[var]) : leavesBlock.func_176223_P());
            }
            ++i;
        }
        if (sideHit == EnumFacing.UP && !(list1 = world.func_72872_a(EntityLivingBase.class, axisalignedbb = boundingBox.func_72321_a(0.0, 2.0, 0.0))).isEmpty()) {
            Iterator iterator2 = list1.iterator();
            BlockPos p2 = pos.func_177982_a(i * sideHit.func_176730_m().func_177958_n(), i * sideHit.func_176730_m().func_177956_o() + pos.func_177956_o() > 255 ? 255 : i * sideHit.func_176730_m().func_177956_o(), i * sideHit.func_176730_m().func_177952_p());
            while (iterator2.hasNext()) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)iterator2.next();
                BlockPos p3 = p2.func_177984_a();
                if (world.func_180495_p(p3).func_185904_a().func_76220_a() || world.func_180495_p(p3.func_177984_a()).func_185904_a().func_76220_a()) continue;
                entitylivingbase.func_70107_b((double)p3.func_177958_n() + 0.5, (double)p3.func_177956_o(), (double)p3.func_177952_p() + 0.5);
            }
        }
    }

    public static void explodeWasting(World world, BlockPos pos, Entity livingEntity, AxisAlignedBB boundingBox, boolean enhanced) {
        double r = enhanced ? 5.0 : 4.0;
        AxisAlignedBB axisalignedbb = boundingBox.func_72321_a(r, 2.0, r);
        List list1 = world.func_72872_a(EntityLivingBase.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list1) {
                double d0 = entitylivingbase.func_174818_b(pos);
                if (!(d0 < r * r)) continue;
                double d2 = 1.0 - Math.sqrt(d0) / r;
                if (entitylivingbase == livingEntity) {
                    d2 = 1.0;
                }
                int j = (int)(d2 * 400.0 + 0.5);
                if (entitylivingbase instanceof EntityPlayer) {
                    int minLevel;
                    EntityPlayer victim = (EntityPlayer)entitylivingbase;
                    int n = minLevel = enhanced ? 6 : 10;
                    if (victim.func_71024_bL().func_75116_a() > minLevel) {
                        victim.func_71024_bL().func_75122_a(-minLevel, 0.0f);
                    }
                    victim.func_70690_d(new PotionEffect(MobEffects.field_76438_s, j * 2, enhanced ? 2 : 1));
                    victim.func_70690_d(new PotionEffect(MobEffects.field_76436_u, Math.max(j / 3, 40), 0));
                    continue;
                }
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, j * 2, enhanced ? 1 : 0));
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76436_u, Math.max(j / 3, 40), 0));
            }
        }
        int blockRadius = (int)r - 1;
        int blockRadiusSq = blockRadius * blockRadius;
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-blockRadius, -blockRadius, -blockRadius), (BlockPos)pos.func_177982_a(blockRadius, blockRadius, blockRadius))) {
            Block blockID;
            IBlockState state;
            Material material;
            if (!(pos.func_177951_i((Vec3i)p) <= (double)blockRadiusSq) || (material = (state = world.func_180495_p(p)).func_185904_a()) != Material.field_151584_j && (material != Material.field_151585_k && material != Material.field_151582_l || !material.func_76222_j()) || (blockID = state.func_177230_c()) instanceof BlockCircle || blockID instanceof BlockCircleGlyph) continue;
            blockID.func_176226_b(world, p, state, 0);
            world.func_175698_g(p);
        }
    }

    private static void spawnParticles(World world, EnumParticleTypes effect, double posX, double posY, double posZ) {
        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(posX, posY, posZ, 1.0f, 1.0f, effect), world, posX, posY, posZ, 8.0);
    }

    public static void explodeWeb(World world, BlockPos pos, EnumFacing side, boolean enhanced) {
        BlockPos p = side == null ? pos : pos.func_177972_a(side);
        EntityWitchProjectile.setBlockIfNotSolid(world, p, Blocks.field_150321_G);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177974_f(), Blocks.field_150321_G);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177976_e(), Blocks.field_150321_G);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177968_d(), Blocks.field_150321_G);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177978_c(), Blocks.field_150321_G);
        if (enhanced) {
            EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177982_a(1, 0, 1), Blocks.field_150321_G);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177982_a(-1, 0, -1), Blocks.field_150321_G);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177982_a(-1, 0, 1), Blocks.field_150321_G);
            EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177982_a(1, 0, -1), Blocks.field_150321_G);
        }
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177984_a(), Blocks.field_150321_G);
        EntityWitchProjectile.setBlockIfNotSolid(world, p.func_177977_b(), Blocks.field_150321_G);
    }

    public static boolean plantCactus(World world, BlockPos pos, int CACTUS_HEIGHT) {
        Material material;
        if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            pos = pos.func_177977_b();
        }
        if ((material = world.func_180495_p(pos).func_185904_a()) != Material.field_151571_B && material != Material.field_151596_z && material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e && material != Material.field_151595_p && material != Material.field_151597_y && material != Material.field_151583_m && material != Material.field_151570_A) {
            return false;
        }
        IBlockState blockID = world.func_180495_p(pos);
        if (!WitcheryUtils.canBreak(blockID)) {
            return false;
        }
        if (material != Material.field_151570_A) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        } else {
            while (world.func_180495_p(pos).func_177230_c() == Blocks.field_150434_aF) {
                pos = pos.func_177984_a();
            }
            pos = pos.func_177977_b();
        }
        for (int i = 1; i <= CACTUS_HEIGHT && pos.func_177956_o() + i < 256 && EntityWitchProjectile.setBlockIfNotSolid(world, pos.func_177984_a(), (Block)Blocks.field_150434_aF); ++i) {
        }
        return true;
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos, Block block) {
        return EntityWitchProjectile.setBlockIfNotSolid(world, pos, block.func_176223_P());
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos, IBlockState state) {
        IBlockState original = world.func_180495_p(pos);
        if (!original.func_185904_a().func_76220_a() || state.func_177230_c() == Blocks.field_150321_G && original.func_177230_c() == Blocks.field_150433_aE) {
            world.func_180501_a(pos, state, 3);
            EntityWitchProjectile.spawnParticles(world, EnumParticleTypes.EXPLOSION_NORMAL, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
            return true;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setStack(ItemStack item) {
        this.field_70180_af.func_187227_b(ITEM, (Object)item);
    }

    protected float func_70185_h() {
        return this.getStack().func_77973_b() instanceof ItemKettleBrew ? 0.05f : super.func_70185_h();
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K) {
            boolean enhanced = false;
            EntityLivingBase thrower = this.func_85052_h();
            if (thrower instanceof EntityPlayer) {
                enhanced = Familiars.hasFamiliarPower((EntityPlayer)thrower, WitcheryFamiliars.BREW_MASTERY);
            }
            boolean hasEffect = false;
            Item item = this.getStack().func_77973_b();
            if (item instanceof ItemKettleBrew) {
                hasEffect = ((ItemKettleBrew)item).impact(this.field_70170_p, this, thrower, mop, enhanced);
            } else if (WitcheryIngredientItems.WEB == item) {
                this.impactWebSmall(mop);
            } else if (WitcheryIngredientItems.ROCK == item) {
                this.impactRock(mop);
            }
            if (hasEffect) {
                this.field_70170_p.func_175718_b(2002, this.func_180425_c(), 2);
            }
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    private void impactRock(RayTraceResult mop) {
        if (mop.field_72308_g != null) {
            float DAMAGE = 6.0f;
            mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), DAMAGE);
        }
        EntityWitchProjectile.spawnParticles(this.field_70170_p, EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void impactWebSmall(RayTraceResult mop) {
        switch (mop.field_72313_a) {
            case ENTITY: {
                this.field_70170_p.func_175656_a(mop.field_72308_g.func_180425_c(), Blocks.field_150321_G.func_176223_P());
                break;
            }
            case BLOCK: {
                BlockPos pos = mop.func_178782_a();
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE) {
                    pos = pos.func_177977_b();
                    mop.field_178784_b = EnumFacing.UP;
                }
                EntityWitchProjectile.setBlockIfNotSolid(this.field_70170_p, pos.func_177972_a(mop.field_178784_b), Blocks.field_150321_G);
                break;
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Item")) {
            this.setStack(new ItemStack(compound.func_74775_l("Item")));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ItemStack item = this.getStack();
        if (!item.func_190926_b()) {
            compound.func_74782_a("Item", (NBTBase)item.func_77955_b(new NBTTagCompound()));
        }
    }
}

