/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.BlockUtil;

public class EntityAIDigBlocks
extends EntityAIBase {
    public static final GameProfile NORMAL_MINER_PROFILE = new GameProfile(UUID.fromString("AB06ACB0-0CDB-11E4-9191-0800200C9A66"), "[Minecraft]");
    public static final GameProfile KOBOLDITE_MINER_PROFILE = new GameProfile(UUID.fromString("24818AE0-0CDE-11E4-9191-0800200C9A66"), "[Minecraft]");
    protected final EntityGoblin entity;
    protected final double range;
    protected final double kobolditeChance;
    RayTraceResult mop = null;
    int failedChecks = 0;
    private int waitTimer = 60;

    public EntityAIDigBlocks(EntityGoblin entity, double range, double kobolditeChance) {
        this.entity = entity;
        this.range = range;
        this.kobolditeChance = kobolditeChance;
        this.func_75248_a(7);
    }

    private static RayTraceResult raytraceBlocks(World world, EntityLiving player, double reachDistance, boolean down) {
        float rotationYaw;
        Vec3d playerPosition = player.func_174824_e(1.0f);
        player.field_70177_z = rotationYaw = (float)world.field_73012_v.nextInt(360);
        float rotationPitch = down ? 90.0f : 0.0f;
        float f1 = MathHelper.func_76134_b((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-rotationPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-rotationPitch * ((float)Math.PI / 180)));
        Vec3d playerLook = new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        return world.func_147447_a(playerPosition, playerViewOffset, true, false, false);
    }

    private static boolean isHoldingKobolditePick(EntityLivingBase entity) {
        return entity.func_184614_ca().func_77973_b() == WitcheryGeneralItems.KOBOLDITE_PICKAXE;
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, EntityLivingBase harvester) {
        boolean kobolditePick = EntityAIDigBlocks.isHoldingKobolditePick(harvester);
        FakePlayer minerPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)(kobolditePick ? KOBOLDITE_MINER_PROFILE : NORMAL_MINER_PROFILE));
        return EntityAIDigBlocks.tryHarvestBlock(world, pos, harvester, (EntityPlayer)minerPlayer);
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, EntityLivingBase harvester, EntityPlayer minerPlayer) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, minerPlayer);
        event.setCanceled(false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        ItemStack stack = harvester.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, minerPlayer)) {
            return false;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        boolean canHarvest = false;
        if (state.func_185887_b(world, pos) >= 0.0f) {
            String tool;
            if (state.func_185904_a().func_76229_l()) {
                canHarvest = true;
            }
            if ((tool = block.getHarvestTool(state)) != null) {
                int toolLevel;
                int n = toolLevel = !stack.func_190926_b() ? stack.func_77973_b().getHarvestLevel(stack, tool, minerPlayer, state) : 0;
                if (toolLevel < 0) {
                    canHarvest = true;
                }
                if (toolLevel >= block.getHarvestLevel(state)) {
                    canHarvest = true;
                }
            }
        }
        if (canHarvest && (canHarvest = EntityAIDigBlocks.removeBlock(world, pos, minerPlayer))) {
            block.func_180657_a(world, minerPlayer, pos, state, world.func_175625_s(pos), stack);
        }
        return canHarvest;
    }

    private static boolean removeBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        block.func_176208_a(world, pos, state, player);
        boolean flag = block.removedByPlayer(state, world, pos, player, true);
        if (flag) {
            block.func_176206_d(world, pos, state);
        }
        return flag;
    }

    public static void onHarvestDrops(EntityPlayer harvester, BlockEvent.HarvestDropsEvent event) {
        if (harvester != null && !harvester.field_70170_p.field_72995_K && !event.isCanceled() && (EntityAIDigBlocks.isEqual(harvester.func_146103_bH(), KOBOLDITE_MINER_PROFILE) || EntityAIDigBlocks.isEqual(harvester.func_146103_bH(), NORMAL_MINER_PROFILE))) {
            boolean hasKobolditePick = EntityAIDigBlocks.isEqual(harvester.func_146103_bH(), KOBOLDITE_MINER_PROFILE);
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            double kobolditeChance = hasKobolditePick ? 0.02 : 0.01;
            for (ItemStack drop : event.getDrops()) {
                String oreName;
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)drop);
                boolean addOriginal = true;
                if (oreIDs.length > 0 && (oreName = OreDictionary.getOreName((int)oreIDs[0])) != null && oreName.startsWith("ore")) {
                    ItemStack smeltedDrop = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                    if (hasKobolditePick && harvester.field_70170_p.field_73012_v.nextDouble() < 0.5) {
                        addOriginal = false;
                        newDrops.add(smeltedDrop.func_77946_l());
                        newDrops.add(smeltedDrop.func_77946_l());
                        if (harvester.field_70170_p.field_73012_v.nextDouble() < 0.25) {
                            newDrops.add(smeltedDrop.func_77946_l());
                        }
                    }
                    double d = kobolditeChance = hasKobolditePick ? 0.08 : 0.05;
                }
                if (!addOriginal) continue;
                newDrops.add(drop);
            }
            event.getDrops().clear();
            for (ItemStack newDrop : newDrops) {
                event.getDrops().add(newDrop);
            }
            if (harvester.field_70170_p.field_73012_v.nextDouble() < kobolditeChance) {
                event.getDrops().add(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST));
            }
        }
    }

    private static boolean isEqual(GameProfile a, GameProfile b) {
        return a != null && b != null && a.getId() != null && b.getId() != null && a.getId().equals(b.getId());
    }

    public boolean func_75250_a() {
        if (this.entity == null || this.entity.isWorshipping() || this.entity.func_184614_ca().func_190926_b() || !(this.entity.func_184614_ca().func_77973_b() instanceof ItemPickaxe) || !this.entity.func_110167_bD() || this.entity.field_70170_p.field_73012_v.nextInt(2) != 0) {
            return false;
        }
        RayTraceResult mop = EntityAIDigBlocks.raytraceBlocks(this.entity.field_70170_p, (EntityLiving)this.entity, this.failedChecks == 15 ? 1.0 : 4.0, this.failedChecks == 15);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            ++this.failedChecks;
            return false;
        }
        IBlockState block = BlockUtil.getBlock(this.entity.field_70170_p, mop);
        if (this.isMineable(block, this.entity.field_70170_p, mop.func_178782_a())) {
            this.failedChecks = 0;
            this.mop = mop;
            return true;
        }
        this.mop = null;
        ++this.failedChecks;
        return false;
    }

    private boolean isMineable(IBlockState block, World world, BlockPos pos) {
        return (block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151595_p || block.func_185904_a() == Material.field_151577_b || block.func_185904_a() == Material.field_151597_y || block.func_185904_a() == Material.field_151578_c) && block.func_185887_b(world, pos) >= 0.0f;
    }

    public void func_75249_e() {
        double SPEED = 0.6;
        this.entity.func_70661_as().func_75492_a((double)this.mop.func_178782_a().func_177958_n(), (double)this.mop.func_178782_a().func_177956_o(), (double)this.mop.func_178782_a().func_177952_p(), SPEED);
    }

    public boolean func_75253_b() {
        return this.entity != null && !this.entity.isWorshipping() && !this.entity.func_184614_ca().func_190926_b() && this.entity.func_184614_ca().func_77973_b() instanceof ItemPickaxe && this.entity.func_110167_bD() && this.mop != null;
    }

    public void func_75251_c() {
        if (this.entity.isWorking()) {
            this.entity.setWorking(false);
        }
    }

    public void func_75246_d() {
        IBlockState block;
        RayTraceResult mop;
        double DROP_RANGE = 2.5;
        double DROP_RANGE_SQ = 6.25;
        double dist = this.entity.func_174818_b(this.mop.func_178782_a());
        boolean retry = true;
        if (dist <= DROP_RANGE_SQ) {
            if (!this.entity.isWorking()) {
                this.entity.setWorking(true);
            }
            if (--this.waitTimer == 0) {
                if (!EntityAIDigBlocks.tryHarvestBlock(this.entity.field_70170_p, this.mop.func_178782_a(), (EntityLivingBase)this.entity)) {
                    retry = false;
                }
                this.mop = null;
                this.waitTimer = this.getNextHarvestDelay();
            }
        } else if (this.entity.func_70661_as().func_75500_f()) {
            this.mop = null;
            this.waitTimer = this.getNextHarvestDelay();
            if (this.entity.isWorking()) {
                this.entity.setWorking(false);
            }
        } else if (!this.entity.isWorking()) {
            this.entity.setWorking(true);
        }
        if (this.mop == null && retry && this.entity.field_70170_p.field_73012_v.nextInt(20) != 0 && (mop = EntityAIDigBlocks.raytraceBlocks(this.entity.field_70170_p, (EntityLiving)this.entity, 4.0, false)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && this.isMineable(block = BlockUtil.getBlock(this.entity.field_70170_p, mop), this.entity.field_70170_p, mop.func_178782_a())) {
            this.mop = mop;
            this.waitTimer = this.getNextHarvestDelay();
        }
    }

    private int getNextHarvestDelay() {
        return EntityAIDigBlocks.isHoldingKobolditePick((EntityLivingBase)this.entity) ? 4 : 60;
    }
}

