/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.ArrayList;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.entity.EntityGoblin;

public class EntityAIDropOffBlocks
extends EntityAIBase {
    protected final EntityGoblin entity;
    protected final double range;
    private TileEntity targetTile = null;

    public EntityAIDropOffBlocks(EntityGoblin entity, double range) {
        this.entity = entity;
        this.range = range;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        if (this.entity != null && !this.entity.isWorshipping() && this.entity.func_184614_ca().func_190926_b() || !this.entity.func_110167_bD() || this.entity.func_184614_ca().func_77973_b() instanceof ItemTool) {
            return false;
        }
        if (this.targetTile != null && !this.targetTile.func_145837_r() && this.entity.func_70661_as().func_179680_a(this.targetTile.func_174877_v()) != null) {
            return true;
        }
        this.targetTile = null;
        if (this.entity.field_70170_p.field_73012_v.nextInt(60) != 0) {
            return false;
        }
        this.setTargetTile();
        return this.targetTile != null;
    }

    public void func_75249_e() {
    }

    private void setTargetTile() {
        this.targetTile = null;
        ArrayList chests = new ArrayList();
        double bestDist = Double.MAX_VALUE;
        double RANGE_SQ = this.range * this.range;
        for (int i = 0; i < this.entity.field_70170_p.field_147482_g.size(); ++i) {
            try {
                double distSq;
                TileEntity tile = (TileEntity)this.entity.field_70170_p.field_147482_g.get(i);
                if (!(tile instanceof IInventory) || tile.func_145837_r() || ((IInventory)tile).func_70302_i_() < 27 || !((distSq = this.entity.func_70092_e(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p())) <= RANGE_SQ) || this.entity.func_70661_as().func_75488_a((double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p()) == null || !(distSq < bestDist)) continue;
                bestDist = distSq;
                this.targetTile = tile;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean func_75253_b() {
        return this.entity != null && !this.entity.isWorshipping() && !this.entity.func_184614_ca().func_190926_b() && this.entity.func_110167_bD() && this.targetTile != null;
    }

    public void func_75246_d() {
        if (this.entity.func_70661_as().func_75500_f()) {
            this.setTargetTile();
            if (this.targetTile != null) {
                this.entity.func_70661_as().func_75492_a((double)this.targetTile.func_174877_v().func_177958_n(), (double)this.targetTile.func_174877_v().func_177956_o(), (double)this.targetTile.func_174877_v().func_177952_p(), 0.6);
            }
        }
        if (!this.entity.field_70170_p.field_72995_K && this.targetTile != null && this.entity.func_174818_b(this.targetTile.func_174877_v()) <= 6.25) {
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.entity.field_70170_p));
            IInventory inventory = (IInventory)this.targetTile;
            inventory.func_174889_b((EntityPlayer)fakePlayer);
            this.addItemStackToInventory(this.entity.func_184614_ca(), inventory);
            inventory.func_174886_c((EntityPlayer)fakePlayer);
        }
    }

    public void addItemStackToInventory(ItemStack stack, IInventory inventory) {
        if (!stack.func_190926_b()) {
            try {
                if (!stack.func_77951_h()) {
                    int i;
                    do {
                        i = stack.func_190916_E();
                        stack.func_190920_e(this.storePartialItemStack(stack, inventory));
                    } while (stack.func_190916_E() > 0 && stack.func_190916_E() < i);
                    return;
                }
                int i = this.getFirstEmptyStack(inventory);
                if (i >= 0) {
                    inventory.func_70299_a(i, stack.func_77946_l());
                    stack.func_190920_e(0);
                    stack.func_190915_d(5);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)stack.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)stack.func_77952_i());
                crashreportcategory.func_189529_a("Item name", () -> ((ItemStack)stack).func_82833_r());
                throw new ReportedException(crashreport);
            }
        }
    }

    public int getFirstEmptyStack(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack stack, IInventory inventory) {
        int k;
        Item item = stack.func_77973_b();
        int i = stack.func_190916_E();
        if (stack.func_77976_d() == 1) {
            int j = this.getFirstEmptyStack(inventory);
            if (j < 0) {
                return i;
            }
            if (inventory.func_70301_a(j).func_190926_b()) {
                inventory.func_70299_a(j, stack.func_77946_l());
            }
            return 0;
        }
        int j = this.storeItemStack(stack, inventory);
        if (j < 0) {
            j = this.getFirstEmptyStack(inventory);
        }
        if (j < 0) {
            return i;
        }
        if (inventory.func_70301_a(j).func_190926_b()) {
            inventory.func_70299_a(j, new ItemStack(item, 0, stack.func_77952_i()));
            if (stack.func_77942_o()) {
                inventory.func_70301_a(j).func_77982_d(stack.func_77978_p().func_74737_b());
            }
        }
        if ((k = i) > inventory.func_70301_a(j).func_77976_d() - inventory.func_70301_a(j).func_190916_E()) {
            k = inventory.func_70301_a(j).func_77976_d() - inventory.func_70301_a(j).func_190916_E();
        }
        if (k > 64 - inventory.func_70301_a(j).func_190916_E()) {
            k = 64 - inventory.func_70301_a(j).func_190916_E();
        }
        if (k == 0) {
            return i;
        }
        ItemStack stackInSlot = inventory.func_70301_a(j);
        stackInSlot.func_190917_f(k);
        inventory.func_70301_a(j).func_190915_d(5);
        return i -= k;
    }

    private int storeItemStack(ItemStack stack, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b() || inventory.func_70301_a(i).func_77973_b() != stack.func_77973_b() || !inventory.func_70301_a(i).func_77985_e() || inventory.func_70301_a(i).func_190916_E() >= inventory.func_70301_a(i).func_77976_d() || inventory.func_70301_a(i).func_190916_E() >= 64 || inventory.func_70301_a(i).func_77981_g() && inventory.func_70301_a(i).func_77952_i() != stack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)inventory.func_70301_a(i), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }
}

