/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class EntityAIFlyerArrowAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    private int delayCounter;
    private int failedPathFindingPenalty;

    public EntityAIFlyerArrowAttack(IRangedAttackMob par1IRangedAttackMob, double par2, int par4, float par5) {
        this(par1IRangedAttackMob, par2, par4, par4, par5);
    }

    public EntityAIFlyerArrowAttack(IRangedAttackMob par1IRangedAttackMob, double par2, int par4, int par5, float par6) {
        if (!(par1IRangedAttackMob instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = par1IRangedAttackMob;
        this.entityHost = (EntityLiving)par1IRangedAttackMob;
        this.entityMoveSpeed = par2;
        this.attackIntervalMin = par4;
        this.maxRangedAttackTime = par5;
        this.attackRadius = par6;
        this.maxAttackDistance = par6 * par6;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
        this.delayCounter = 0;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (d0 > (double)this.maxAttackDistance && --this.delayCounter <= 0) {
            float n;
            this.delayCounter = this.failedPathFindingPenalty + 4 + this.entityHost.func_70681_au().nextInt(7);
            double d2 = this.attackTarget.field_70165_t - this.entityHost.field_70165_t;
            double d3 = this.attackTarget.field_70163_u - this.entityHost.field_70163_u;
            double d4 = this.attackTarget.field_70161_v - this.entityHost.field_70161_v;
            double d5 = d2 * d2 + d3 * d3 + d4 * d4;
            if (this.isCourseTraversable(this.attackTarget.field_70165_t, this.attackTarget.field_70163_u, this.attackTarget.field_70161_v, d5 = (double)MathHelper.func_76133_a((double)d5))) {
                EntityLiving entityHost = this.entityHost;
                entityHost.field_70159_w += d2 / d5 * 0.15;
                EntityLiving entityHost2 = this.entityHost;
                entityHost2.field_70181_x += d3 / d5 * 0.15;
                EntityLiving entityHost3 = this.entityHost;
                entityHost3.field_70179_y += d4 / d5 * 0.15;
                this.failedPathFindingPenalty = 0;
            } else {
                this.failedPathFindingPenalty += 10;
            }
            this.entityHost.field_70177_z = n = -((float)Math.atan2(this.entityHost.field_70159_w, this.entityHost.field_70179_y)) * 180.0f / (float)Math.PI;
            this.entityHost.field_70761_aq = n;
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (d0 > (double)this.maxAttackDistance || !flag) {
                return;
            }
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float f = f2;
            if (f < 0.1f) {
                f2 = 0.1f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, f2);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.attackTarget.field_70165_t) / par7;
        double d5 = (par3 - this.attackTarget.field_70163_u) / par7;
        double d6 = (par5 - this.attackTarget.field_70161_v) / par7;
        AxisAlignedBB axisalignedbb = this.attackTarget.func_174813_aQ();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.attackTarget.field_70170_p.func_184144_a((Entity)this.attackTarget, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

