/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.block.BlockVoidBramble;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.Waypoint;

public class EntityAIFlyerFlyToWaypoint
extends EntityAIBase {
    private static final double HIT_RADIUS = 1.0;
    private static final double HIT_RADIUS_SQ = 1.0;
    private final EntityFlyingTameable flyer;
    private final CarryRequirement carryRequirement;
    int courseTimer = 0;

    public EntityAIFlyerFlyToWaypoint(EntityFlyingTameable flyer, CarryRequirement carryRestrictions) {
        this.flyer = flyer;
        this.carryRequirement = carryRestrictions;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        return !this.flyer.waypoint.func_190926_b() && (!this.flyer.func_184614_ca().func_190926_b() || this.carryRequirement != CarryRequirement.HELD_ITEM);
    }

    public boolean func_75253_b() {
        boolean heldItem = !this.flyer.func_184614_ca().func_190926_b();
        boolean awayFromHome = this.flyer.func_70092_e(this.flyer.homeX, this.flyer.field_70163_u, this.flyer.homeZ) > 1.0 || Math.abs(this.flyer.field_70163_u - this.flyer.homeY) > 1.0;
        return heldItem && this.carryRequirement == CarryRequirement.HELD_ITEM || this.flyer.waypoint != null || awayFromHome;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
        this.flyer.waypoint = ItemStack.field_190927_a;
        this.flyer.func_70904_g(true);
        if (!this.flyer.func_184188_bt().isEmpty()) {
            ((Entity)this.flyer.func_184188_bt().get(0)).func_184210_p();
        }
        this.courseTimer = 0;
    }

    public void func_75246_d() {
        if (!this.flyer.func_70906_o()) {
            Waypoint waypoint = this.flyer.getWaypoint();
            if (this.carryRequirement == CarryRequirement.ENTITY_LIVING) {
                List entities;
                if (this.flyer.func_70092_e(waypoint.x, waypoint.y, waypoint.z) <= 1.0 && (entities = this.flyer.field_70170_p.func_72872_a(EntityLivingBase.class, this.flyer.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0))).size() > 1) {
                    if (!this.flyer.field_70170_p.field_72995_K) {
                        for (EntityLivingBase entity : entities) {
                            if (entity == this.flyer) continue;
                            entity.func_184220_m((Entity)this.flyer);
                        }
                    }
                    this.flyer.waypoint = ItemStack.field_190927_a;
                    waypoint = this.flyer.getWaypoint();
                }
            } else if (!this.flyer.func_184614_ca().func_190926_b() && this.flyer.func_70092_e(waypoint.x, waypoint.y, waypoint.z) <= 1.0) {
                if (!this.flyer.field_70170_p.field_72995_K) {
                    ItemStack stack = this.flyer.func_184614_ca();
                    this.flyer.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    if (TeleportationUtil.isBrew(stack)) {
                        this.flyer.field_70170_p.func_184133_a(null, this.flyer.func_180425_c(), SoundEvents.field_187737_v, this.flyer.func_184176_by(), 0.5f, 0.4f / (this.flyer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        EntityWitchProjectile projectile = new EntityWitchProjectile(this.flyer.field_70170_p, (EntityLivingBase)this.flyer, stack);
                        projectile.func_184538_a((Entity)this.flyer, this.flyer.field_70125_A, this.flyer.field_70177_z, -20.0f, 0.5f, 1.0f);
                        projectile.field_70159_w = 0.0;
                        projectile.field_70179_y = 0.0;
                        this.flyer.field_70170_p.func_72838_d((Entity)projectile);
                    } else if (stack.func_77973_b() == WitcheryGeneralItems.SPLASH_BREW_BOTTLE || stack.func_77973_b() == WitcheryGeneralItems.LINGERING_BREW_BOTTLE) {
                        this.flyer.field_70170_p.func_184133_a(null, this.flyer.func_180425_c(), SoundEvents.field_187737_v, this.flyer.func_184176_by(), 0.5f, 0.4f / (this.flyer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        EntityBrew projectile = new EntityBrew(this.flyer.field_70170_p, (EntityLivingBase)this.flyer, stack, false);
                        projectile.func_184538_a((Entity)this.flyer, this.flyer.field_70125_A, this.flyer.field_70177_z, -20.0f, 0.75f, 1.0f);
                        projectile.field_70159_w = 0.0;
                        projectile.field_70179_y = 0.0;
                        this.flyer.field_70170_p.func_72838_d((Entity)projectile);
                    } else if (stack.func_77973_b() == Items.field_185155_bH || stack.func_77973_b() == Items.field_185156_bI) {
                        this.flyer.field_70170_p.func_184133_a(null, this.flyer.func_180425_c(), SoundEvents.field_187737_v, this.flyer.func_184176_by(), 0.5f, 0.4f / (this.flyer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        EntityPotion projectile = new EntityPotion(this.flyer.field_70170_p, (EntityLivingBase)this.flyer, stack);
                        projectile.func_184538_a((Entity)this.flyer, this.flyer.field_70125_A, this.flyer.field_70177_z, -20.0f, 0.5f, 1.0f);
                        projectile.field_70159_w = 0.0;
                        projectile.field_70179_y = 0.0;
                        this.flyer.field_70170_p.func_72838_d((Entity)projectile);
                    } else {
                        EntityItem item = new EntityItem(this.flyer.field_70170_p, this.flyer.field_70165_t, this.flyer.field_70163_u, this.flyer.field_70161_v, stack);
                        if (stack.func_77973_b() == Item.func_150898_a((Block)WitcheryBlocks.MINDRAKE)) {
                            item.lifespan = 60;
                        }
                        this.flyer.field_70170_p.func_72838_d((Entity)item);
                    }
                }
                this.flyer.waypoint = ItemStack.field_190927_a;
                waypoint = this.flyer.getWaypoint();
            }
            double dX = waypoint.x - this.flyer.field_70165_t;
            double dY = waypoint.y - this.flyer.field_70163_u;
            double dZ = waypoint.z - this.flyer.field_70161_v;
            double trajectory = dX * dX + dY * dY + dZ * dZ;
            if ((trajectory = (double)MathHelper.func_76133_a((double)trajectory)) >= 128.0 && this.carryRequirement == CarryRequirement.HELD_ITEM) {
                BlockVoidBramble.teleportRandomly(this.flyer.field_70170_p, new BlockPos(waypoint.x, waypoint.y, waypoint.z), (Entity)this.flyer, 16);
            }
            this.flyer.func_70605_aq().func_75642_a(waypoint.x, Math.min(waypoint.y + 32.0, 255.0), waypoint.z, trajectory * 0.1);
        }
    }

    public static enum CarryRequirement {
        NONE,
        HELD_ITEM,
        ENTITY_LIVING;

    }
}

