/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.util.TeleportationUtil;

public class EntityAIFlyerFollowOwner<T extends Entity>
extends EntityAIBase {
    private final T entity;
    private Familiar<?> familiar;
    private Entity owner;
    final float maxDist;
    final float minDist;
    private int timeToRecalcPath;

    public EntityAIFlyerFollowOwner(T ownable, float minimumDistance, float maximumDistance) {
        this.entity = ownable;
        this.minDist = minimumDistance;
        this.maxDist = maximumDistance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Entity owner = null;
        if (Familiars.canBeFamiliar(this.entity)) {
            Familiar<T> familiar = Familiars.getFamiliarInstance(this.entity);
            owner = familiar.func_70902_q();
            this.familiar = familiar;
        } else if (this.entity instanceof IEntityOwnable) {
            owner = ((IEntityOwnable)this.entity).func_70902_q();
        }
        if (owner == null) {
            return false;
        }
        if (this.isSitting()) {
            return false;
        }
        if (((Entity)this.entity).field_71093_bK != owner.field_71093_bK || this.entity.func_70068_e(owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    private boolean isSitting() {
        if (this.familiar != null) {
            return this.familiar.isFamiliarSitting();
        }
        return this.entity instanceof EntityTameable && ((EntityTameable)this.entity).func_70906_o();
    }

    public boolean func_75253_b() {
        return this.entity.func_70068_e(this.owner) > (double)(this.maxDist * this.maxDist) && !this.isSitting();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
    }

    public void func_75251_c() {
        this.owner = null;
    }

    public void func_75246_d() {
        if (!this.isSitting() && --this.timeToRecalcPath <= 0) {
            float n;
            this.timeToRecalcPath = 10;
            if (((Entity)this.entity).field_71093_bK != this.owner.field_71093_bK || this.entity.func_70068_e(this.owner) >= 256.0) {
                int x = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int z = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int y = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b) - 2;
                for (int dx = 0; dx <= 4; ++dx) {
                    for (int dz = 0; dz <= 4; ++dz) {
                        for (int dy = 0; dy <= 4; ++dy) {
                            int newX = x + dz;
                            int newY = y + dy;
                            int newZ = z + dz;
                            BlockPos pos = new BlockPos(newX, newY, newZ);
                            if (!this.owner.field_70170_p.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)this.owner.field_70170_p, pos.func_177977_b(), EnumFacing.UP) || this.owner.field_70170_p.func_180495_p(pos).func_185915_l() || this.owner.field_70170_p.func_180495_p(pos.func_177984_a()).func_185915_l()) continue;
                            TeleportationUtil.teleportToLocation(pos, this.owner.field_71093_bK, this.entity, true);
                            return;
                        }
                    }
                }
            } else {
                double x = this.owner.field_70165_t - ((Entity)this.entity).field_70165_t;
                double y = this.owner.field_70163_u - ((Entity)this.entity).field_70163_u;
                double z = this.owner.field_70161_v - ((Entity)this.entity).field_70161_v;
                double distance = Math.sqrt(x * x + y * y + z * z);
                if (this.isCourseTraversable(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, distance)) {
                    ((Entity)this.entity).field_70159_w += x / distance * 0.1;
                    ((Entity)this.entity).field_70181_x = ((Entity)this.entity).field_70163_u < this.owner.field_70163_u + 2.0 ? (((Entity)this.entity).field_70181_x += y / distance * 0.1 + 0.1) : (((Entity)this.entity).field_70181_x += y / distance * 0.1);
                } else {
                    double newX2 = ((Entity)this.entity).field_70165_t + (((Entity)this.entity).field_70170_p.field_73012_v.nextDouble() * 8.0 - 4.0) * 6.0;
                    double newY2 = ((Entity)this.entity).field_70163_u + (((Entity)this.entity).field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0) * 6.0;
                    double newZ2 = ((Entity)this.entity).field_70161_v + (((Entity)this.entity).field_70170_p.field_73012_v.nextDouble() * 8.0 - 4.0) * 6.0;
                    x = newX2 - ((Entity)this.entity).field_70165_t;
                    y = newY2 - ((Entity)this.entity).field_70163_u;
                    z = newZ2 - ((Entity)this.entity).field_70161_v;
                    distance = x * x + y * y + z * z;
                    distance = MathHelper.func_76133_a((double)distance);
                    ((Entity)this.entity).field_70159_w += x / distance * 0.1;
                    ((Entity)this.entity).field_70181_x += y / distance * 0.1 + 0.1;
                }
                ((Entity)this.entity).field_70179_y += z / distance * 0.1;
            }
            ((Entity)this.entity).field_70177_z = n = -((float)Math.atan2(((Entity)this.entity).field_70159_w, ((Entity)this.entity).field_70179_y)) * 180.0f / (float)Math.PI;
            this.entity.func_181013_g(n);
        }
    }

    private boolean isCourseTraversable(double x, double y, double z, double distance) {
        double xOffset = (x - ((Entity)this.entity).field_70165_t) / distance;
        double yOffset = (y - ((Entity)this.entity).field_70163_u) / distance;
        double zOffset = (z - ((Entity)this.entity).field_70161_v) / distance;
        AxisAlignedBB axisalignedbb = this.entity.func_174813_aQ();
        int i = 1;
        while ((double)i < distance) {
            axisalignedbb.func_72317_d(xOffset, yOffset, zOffset);
            if (!((Entity)this.entity).field_70170_p.func_184144_a(this.entity, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

