/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerLand
extends EntityAIBase {
    public final boolean findTrees;
    final World world;
    final EntityLiving living;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    int[] target;

    public EntityAIFlyerLand(EntityLiving par1EntityCreature, boolean findTrees) {
        this.living = par1EntityCreature;
        this.world = this.living.field_70170_p;
        this.findTrees = findTrees;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return this.isLanded() && this.liquidBelow((int)this.living.field_70163_u - 1) && this.liquidBelow((int)this.living.field_70163_u) && this.world.field_73012_v.nextInt(20) == 0;
    }

    private boolean liquidBelow(int y) {
        return !this.world.func_180495_p(new BlockPos(this.living.field_70165_t, (double)y, this.living.field_70161_v)).func_185904_a().func_76224_d();
    }

    public boolean func_75253_b() {
        return this.isLanded() && this.liquidBelow((int)this.living.field_70163_u - 1) && this.liquidBelow((int)this.living.field_70163_u);
    }

    public void func_75249_e() {
        this.courseChangeCooldown = 100;
        int x0 = MathHelper.func_76128_c((double)this.living.field_70165_t);
        int y0 = MathHelper.func_76128_c((double)this.living.field_70163_u);
        int z0 = MathHelper.func_76128_c((double)this.living.field_70161_v);
        int[] nArray = this.target = this.findTrees ? this.findTreeTop(x0, y0, z0) : null;
        if (this.target == null) {
            this.target = this.findGround(x0, y0, z0);
        }
        if (this.target != null) {
            // empty if block
        }
    }

    public void func_75251_c() {
        this.target = null;
        super.func_75251_c();
    }

    private int[] findTreeTop(int x0, int y0, int z0) {
        int RADIUS = 16;
        int Y_RADIUS = 3;
        for (int y = Math.max(y0 - Y_RADIUS, 1); y <= y0 + Y_RADIUS; ++y) {
            for (int x = x0 - RADIUS; x <= x0 + RADIUS; ++x) {
                for (int z = z0 - RADIUS; z <= z0 + RADIUS; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.world.func_180495_p(pos);
                    Block blockID = state.func_177230_c();
                    if (state.func_185904_a() != Material.field_151584_j) continue;
                    for (int y2 = y; y2 < y0 + 10; ++y2) {
                        if (!this.world.func_175623_d(pos)) continue;
                        double d0 = (double)x - this.living.field_70165_t;
                        double d2 = (double)y2 - this.living.field_70163_u;
                        double d3 = (double)z - this.living.field_70161_v;
                        double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                        if (!this.isCourseTraversable(x, y2, z, d4 = (double)MathHelper.func_76133_a((double)d4))) continue;
                        return new int[]{x, y2 + 2, z};
                    }
                }
            }
        }
        return null;
    }

    private int[] findGround(int x0, int y0, int z0) {
        for (int y = y0; y > 1; --y) {
            Material material = this.world.func_180495_p(new BlockPos(x0, y, z0)).func_185904_a();
            if (material == Material.field_151579_a) continue;
            if (!material.func_76224_d()) {
                return new int[]{x0, y + 1, z0};
            }
            for (int i = 0; i < 10; ++i) {
                int j = MathHelper.func_76128_c((double)(this.living.field_70165_t + (double)this.world.field_73012_v.nextInt(20) - 10.0));
                int k = MathHelper.func_76128_c((double)(this.living.func_174813_aQ().field_72338_b + (double)this.world.field_73012_v.nextInt(6) - 3.0));
                int l = MathHelper.func_76128_c((double)(this.living.field_70161_v + (double)this.world.field_73012_v.nextInt(20) - 10.0));
                BlockPos pos = new BlockPos(j, k, l);
                IBlockState state = this.world.func_180495_p(pos);
                Block blockID = state.func_177230_c();
                double d0 = (double)j - this.living.field_70165_t;
                double d2 = (double)k - this.living.field_70163_u;
                double d3 = (double)l - this.living.field_70161_v;
                double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                d4 = MathHelper.func_76133_a((double)d4);
                if (state.func_185904_a() != Material.field_151584_j && !state.func_185904_a().func_76220_a() || !this.world.func_175623_d(pos.func_177984_a()) || !this.isCourseTraversable(j, k, l, d4)) continue;
                return new int[]{j, k + 1, l};
            }
        }
        return null;
    }

    public void func_75246_d() {
        float n2;
        if (this.isLanded()) {
            float n;
            if (this.target != null && this.living.func_70092_e((double)this.target[0], this.living.field_70163_u, (double)this.target[2]) > 1.0 && this.courseChangeCooldown-- > 0) {
                double d0 = (double)this.target[0] - this.living.field_70165_t;
                double d2 = (double)this.target[1] - this.living.field_70163_u;
                double d3 = (double)this.target[2] - this.living.field_70161_v;
                double d4 = d0 * d0 + d2 * d2 + d3 * d3;
                if (this.isCourseTraversable(this.target[0], this.target[1], this.target[2], d4 = (double)MathHelper.func_76133_a((double)d4))) {
                    EntityLiving living2 = this.living;
                    living2.field_70159_w += d0 / d4 * 0.05;
                    EntityLiving living22 = this.living;
                    living22.field_70181_x += d2 / d4 * 0.05;
                    EntityLiving living3 = this.living;
                    living3.field_70179_y += d3 / d4 * 0.05;
                }
            } else if (this.liquidBelow((int)(this.living.field_70163_u - 1.0))) {
                this.living.field_70181_x = -0.1;
            }
            this.living.field_70177_z = n = -((float)Math.atan2(this.living.field_70159_w, this.living.field_70179_y)) * 180.0f / (float)Math.PI;
            this.living.field_70761_aq = n;
        }
        this.living.field_70177_z = n2 = -((float)Math.atan2(this.living.field_70159_w, this.living.field_70179_y)) * 180.0f / (float)Math.PI;
        this.living.field_70761_aq = n2;
    }

    private boolean isLanded() {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.living.field_70165_t), (int)(this.living.field_70163_u - 0.01), MathHelper.func_76128_c((double)this.living.field_70161_v));
        IBlockState state = this.world.func_180495_p(pos);
        Material material = state.func_185904_a();
        return material != Material.field_151584_j && !material.func_76220_a();
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.living.field_70165_t) / par7;
        double d5 = (par3 - this.living.field_70163_u) / par7;
        double d6 = (par5 - this.living.field_70161_v) / par7;
        AxisAlignedBB axisalignedbb = this.living.func_174813_aQ();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.world.func_184144_a((Entity)this.living, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

