/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFlyerMate
extends EntityAIBase {
    private final World world;
    private final double moveSpeed;
    private final EntityAnimal entity;
    private int spawnBabyDelay;
    private int updateDelay = 0;
    private EntityAnimal targetMate;

    public EntityAIFlyerMate(EntityAnimal entity, double speed) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.moveSpeed = speed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
        this.updateDelay = 0;
    }

    public void func_75246_d() {
        float n;
        int updateDelay;
        this.updateDelay = updateDelay = this.updateDelay - 1;
        if (updateDelay <= 0) {
            double d0 = this.targetMate.field_70165_t - this.entity.field_70165_t;
            double d2 = this.targetMate.field_70163_u - this.entity.field_70163_u;
            double d3 = this.targetMate.field_70161_v - this.entity.field_70161_v;
            double d4 = d0 * d0 + d2 * d2 + d3 * d3;
            if (this.isCourseTraversable(this.targetMate.field_70165_t, this.targetMate.field_70163_u, this.targetMate.field_70161_v, d4 = (double)MathHelper.func_76133_a((double)d4))) {
                this.entity.field_70159_w += d0 / d4 * this.moveSpeed * 0.3125;
                this.entity.field_70181_x += d2 / d4 * this.moveSpeed * 0.3125;
                this.entity.field_70179_y += d3 / d4 * this.moveSpeed * 0.3125;
            }
            this.updateDelay = 10;
        }
        this.entity.field_70177_z = n = -((float)Math.atan2(this.entity.field_70159_w, this.entity.field_70179_y)) * 180.0f / (float)Math.PI;
        this.entity.field_70761_aq = n;
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.entity.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.entity.field_70165_t) / par7;
        double d5 = (par3 - this.entity.field_70163_u) / par7;
        double d6 = (par5 - this.entity.field_70161_v) / par7;
        AxisAlignedBB axisalignedbb = this.entity.func_174813_aQ();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.entity.field_70170_p.func_184144_a((Entity)this.entity, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private EntityAnimal getNearbyMate() {
        float f = 8.0f;
        List list2 = this.world.func_72872_a(this.entity.getClass(), this.entity.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f));
        double d0 = Double.MAX_VALUE;
        EntityAnimal entityanimal = null;
        for (EntityAnimal animal : list2) {
            if (!this.entity.func_70878_b(animal) || !(this.entity.func_70068_e((Entity)animal) < d0)) continue;
            entityanimal = animal;
            d0 = this.entity.func_70068_e((Entity)animal);
        }
        return entityanimal;
    }

    private void spawnBaby() {
        EntityAgeable entityageable = this.entity.func_90011_a((EntityAgeable)this.targetMate);
        if (entityageable != null) {
            this.entity.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.entity.func_70875_t();
            this.targetMate.func_70875_t();
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityageable);
            Random random = this.entity.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                this.world.func_175688_a(EnumParticleTypes.HEART, this.entity.field_70165_t + (double)(random.nextFloat() * this.entity.field_70130_N * 2.0f) - (double)this.entity.field_70130_N, this.entity.field_70163_u + 0.5 + (double)(random.nextFloat() * this.entity.field_70131_O), this.entity.field_70161_v + (double)(random.nextFloat() * this.entity.field_70130_N * 2.0f) - (double)this.entity.field_70130_N, d0, d2, d3, new int[0]);
            }
            this.world.func_72838_d((Entity)new EntityXPOrb(this.world, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, random.nextInt(7) + 1));
        }
    }
}

