/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class EntityAIFlyingTempt
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final Ingredient breedingFood;
    private final boolean scaredByPlayerMovement;
    private double targetX;
    private double targetY;
    private double targetZ;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;

    public EntityAIFlyingTempt(EntityCreature entity, Ingredient ingredient, boolean scared) {
        this.temptedEntity = entity;
        this.breedingFood = ingredient;
        this.scaredByPlayerMovement = scared;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        boolean isTame;
        boolean bl = isTame = this.temptedEntity instanceof EntityTameable && ((EntityTameable)this.temptedEntity).func_70909_n();
        if (isTame) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_72890_a((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        ItemStack itemstack = this.temptingPlayer.func_184614_ca();
        return !itemstack.func_190926_b() && this.isBreedingFood(itemstack);
    }

    private boolean isBreedingFood(ItemStack stack) {
        return this.breedingFood.test((Object)stack);
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.field_70165_t;
                this.targetY = this.temptingPlayer.field_70163_u;
                this.targetZ = this.temptingPlayer.field_70161_v;
            }
        }
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.delayTemptCounter = 100;
    }

    public void func_75246_d() {
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) >= 3.0) {
            float n;
            double d0 = this.targetX - this.temptedEntity.field_70165_t;
            double d2 = this.targetY - this.temptedEntity.field_70163_u;
            double d3 = this.targetZ - this.temptedEntity.field_70161_v;
            double d4 = d0 * d0 + d2 * d2 + d3 * d3;
            if (this.isCourseTraversable(this.targetX, this.targetY, this.targetZ, d4 = (double)MathHelper.func_76133_a((double)d4))) {
                EntityCreature temptedEntity = this.temptedEntity;
                temptedEntity.field_70159_w += d0 / d4 * 0.05;
                EntityCreature temptedEntity2 = this.temptedEntity;
                temptedEntity2.field_70181_x = this.temptedEntity.field_70163_u < this.targetY + 1.0 ? (temptedEntity2.field_70181_x += d2 / d4 * 0.05 + 0.025) : (temptedEntity2.field_70181_x += d2 / d4 * 0.05);
                EntityCreature temptedEntity4 = this.temptedEntity;
                temptedEntity4.field_70179_y += d3 / d4 * 0.05;
            }
            this.temptedEntity.field_70177_z = n = -((float)Math.atan2(this.temptedEntity.field_70159_w, this.temptedEntity.field_70179_y)) * 180.0f / (float)Math.PI;
            this.temptedEntity.field_70761_aq = n;
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.temptedEntity.field_70165_t) / par7;
        double d5 = (par3 - this.temptedEntity.field_70163_u) / par7;
        double d6 = (par5 - this.temptedEntity.field_70161_v) / par7;
        AxisAlignedBB axisalignedbb = this.temptedEntity.func_174813_aQ();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.temptedEntity.field_70170_p.func_184144_a((Entity)this.temptedEntity, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

