/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.familiar;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0017J\b\u0010@\u001a\u00020=H\u0017J(\u0010\u0006\u001a\u00020=2\u0006\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0014H\u0017J\b\u0010E\u001a\u00020=H\u0017J\u0010\u0010E\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0017J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0017J\u0014\u0010J\u001a\u0004\u0018\u00010K2\b\u0010L\u001a\u0004\u0018\u00010KH\u0017J\u0010\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020\u000fH\u0017J\u0010\u0010O\u001a\u00020\u001d2\u0006\u0010P\u001a\u00020?H\u0017J\u0010\u0010&\u001a\u00020=2\u0006\u0010Q\u001a\u00020\u0014H\u0017J\u0010\u0010R\u001a\u00020=2\u0006\u0010\u0004\u001a\u00020\u0014H\u0017J\u0012\u0010S\u001a\u00020=2\b\u0010N\u001a\u0004\u0018\u00010TH\u0017J\u0010\u0010U\u001a\u00020=2\u0006\u0010\u0004\u001a\u00020\u001dH\u0017J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020.H\u0002J\b\u0010Y\u001a\u00020=H\u0017R*\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058V@VX\u0097\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\b\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00028\u00008VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\b\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u001e\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R*\u0010#\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u001d8V@VX\u0097\u000e\u00a2\u0006\u0012\u0012\u0004\b$\u0010\b\u001a\u0004\b#\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010\b\u001a\u0004\b(\u0010%R\u001a\u0010*\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\b\u001a\u0004\b*\u0010%R\"\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010\b\u001a\u0004\b0\u00101R.\u00103\u001a\u0004\u0018\u00018\u00002\b\u00102\u001a\u0004\u0018\u00018\u00008V@VX\u0097\u000e\u00a2\u0006\u0012\u0012\u0004\b4\u0010\b\u001a\u0004\b5\u0010\u001b\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u000f8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b9\u0010\b\u001a\u0004\b:\u0010;\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006Z"}, d2={"Lnet/msrandom/witchery/entity/familiar/Familiar;", "T", "Lnet/minecraft/entity/Entity;", "Lnet/minecraft/entity/IEntityOwnable;", "value", "Lnet/minecraft/item/EnumDyeColor;", "color", "color$annotations", "()V", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "setColor", "(Lnet/minecraft/item/EnumDyeColor;)V", "colorParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "colorParameter$annotations", "getColorParameter", "()Lnet/minecraft/network/datasync/DataParameter;", "defaultHealth", "", "defaultHealth$annotations", "getDefaultHealth", "()F", "entity", "entity$annotations", "getEntity", "()Lnet/minecraft/entity/Entity;", "familiarProperty", "", "getFamiliarProperty", "familiarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "getFamiliarType", "()Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "isFamiliar", "isFamiliar$annotations", "()Z", "setFamiliar", "(Z)V", "isFamiliarSitting", "isFamiliarSitting$annotations", "isValid", "isValid$annotations", "names", "", "", "names$annotations", "getNames", "()[Ljava/lang/String;", "<anonymous parameter 0>", "originalEntity", "originalEntity$annotations", "getOriginalEntity", "setOriginalEntity", "(Lnet/minecraft/entity/Entity;)V", "particleEffectId", "particleEffectId$annotations", "getParticleEffectId", "()B", "bindTo", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "clearFamiliar", "red", "green", "blue", "multiplier", "dismiss", "getFamiliarAttribute", "Lnet/minecraft/entity/ai/attributes/IAttributeInstance;", "attribute", "Lnet/minecraft/entity/ai/attributes/IAttribute;", "getFamiliarOwner", "Lnet/minecraft/entity/EntityLivingBase;", "default", "handleDismissParticles", "id", "isBoundTo", "boundEntity", "maxHealth", "setFamiliarHealth", "setFamiliarOwnerId", "Ljava/util/UUID;", "setFamiliarTamed", "throwImplementationException", "", "name", "validate", "WitcheryResurrected"})
public interface Familiar<T extends Entity>
extends IEntityOwnable {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isFamiliar() {
        if (!this.isValid()) return false;
        Object object = this.getEntity().func_184212_Q().func_187225_a(this.getFamiliarProperty());
        Intrinsics.checkExpressionValueIsNotNull(object, "entity.dataManager[familiarProperty]");
        if ((Boolean)object == false) return false;
        return true;
    }

    default public void setFamiliar(boolean value) {
        this.getEntity().func_184212_Q().func_187227_b(this.getFamiliarProperty(), (Object)value);
    }

    @NotNull
    default public EnumDyeColor getColor() {
        int n;
        DataParameter<Byte> dataParameter = this.getColorParameter();
        if (dataParameter != null) {
            DataParameter<Byte> dataParameter2 = dataParameter;
            boolean bl = false;
            boolean bl2 = false;
            DataParameter<Byte> it = dataParameter2;
            boolean bl3 = false;
            n = ((Number)this.getEntity().func_184212_Q().func_187225_a(it)).byteValue();
        } else {
            n = 0;
        }
        EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)n);
        Intrinsics.checkExpressionValueIsNotNull(enumDyeColor, "EnumDyeColor.byMetadata(\u2026nager[it].toInt() } ?: 0)");
        return enumDyeColor;
    }

    default public void setColor(@NotNull EnumDyeColor value) {
        block0: {
            Intrinsics.checkParameterIsNotNull(value, "value");
            DataParameter<Byte> dataParameter = this.getColorParameter();
            if (dataParameter == null) break block0;
            DataParameter<Byte> dataParameter2 = dataParameter;
            boolean bl = false;
            boolean bl2 = false;
            DataParameter<Byte> it = dataParameter2;
            boolean bl3 = false;
            this.getEntity().func_184212_Q().func_187227_b(it, (Object)((byte)value.func_176765_a()));
        }
    }

    @JvmDefault
    default public void setFamiliar(float maxHealth) {
        this.setFamiliar(true);
        IAttribute iAttribute = SharedMonsterAttributes.field_111267_a;
        Intrinsics.checkExpressionValueIsNotNull(iAttribute, "SharedMonsterAttributes.MAX_HEALTH");
        this.getFamiliarAttribute(iAttribute).func_111128_a((double)maxHealth);
        this.setFamiliarHealth(maxHealth);
    }

    @JvmDefault
    default public void clearFamiliar() {
        this.setFamiliar(false);
        IAttribute iAttribute = SharedMonsterAttributes.field_111267_a;
        Intrinsics.checkExpressionValueIsNotNull(iAttribute, "SharedMonsterAttributes.MAX_HEALTH");
        this.getFamiliarAttribute(iAttribute).func_111128_a(10.0);
        this.setFamiliarHealth(this.getDefaultHealth());
    }

    default public float getDefaultHealth() {
        return 10.0f;
    }

    @Nullable
    public FamiliarType<T, ?> getFamiliarType();

    @NotNull
    public DataParameter<Boolean> getFamiliarProperty();

    @Nullable
    default public DataParameter<Byte> getColorParameter() {
        return null;
    }

    @Nullable
    default public String[] getNames() {
        return null;
    }

    @JvmDefault
    @Nullable
    default public EntityLivingBase getFamiliarOwner(@Nullable EntityLivingBase entityLivingBase) {
        if (this.isFamiliar() && !((Entity)this.getEntity()).field_70170_p.field_72995_K) {
            EntityPlayerMP entityPlayerMP;
            UUID uUID = this.func_184753_b();
            if (uUID != null) {
                UUID uUID2 = uUID;
                boolean bl = false;
                boolean bl2 = false;
                UUID id = uUID2;
                boolean bl3 = false;
                World world = ((Entity)this.getEntity()).field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull(world, "entity.world");
                Object object = world.func_73046_m();
                if (object != null && (object = object.func_184103_al()) != null && (object = object.func_181057_v()) != null) {
                    Object v5;
                    block6: {
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            EntityPlayerMP it = (EntityPlayerMP)element$iv;
                            boolean bl4 = false;
                            EntityPlayerMP entityPlayerMP2 = it;
                            Intrinsics.checkExpressionValueIsNotNull(entityPlayerMP2, "it");
                            GameProfile gameProfile = entityPlayerMP2.func_146103_bH();
                            Intrinsics.checkExpressionValueIsNotNull(gameProfile, "it.gameProfile");
                            if (!Intrinsics.areEqual(gameProfile.getId(), id)) continue;
                            v5 = element$iv;
                            break block6;
                        }
                        v5 = null;
                    }
                    entityPlayerMP = v5;
                } else {
                    entityPlayerMP = null;
                }
            } else {
                entityPlayerMP = null;
            }
            return (EntityLivingBase)entityPlayerMP;
        }
        return entityLivingBase;
    }

    @NotNull
    default public T getEntity() {
        Familiar familiar = this;
        if (familiar == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)((Entity)familiar);
    }

    @Nullable
    default public T getOriginalEntity() {
        return this.getEntity();
    }

    default public void setOriginalEntity(@Nullable T $noName_0) {
    }

    default public boolean isValid() {
        return Intrinsics.areEqual(this.getEntity(), this.getOriginalEntity());
    }

    @JvmDefault
    default public void validate() {
        if (!this.isValid()) {
            T t = this.getOriginalEntity();
            if (t != null) {
                T t2 = t;
                boolean bl = false;
                boolean bl2 = false;
                T it = t2;
                boolean bl3 = false;
                it.func_70106_y();
                FamiliarType<T, ?> familiarType = this.getFamiliarType();
                if (familiarType != null) {
                    familiarType.update(it, this);
                }
            }
            ((Entity)this.getEntity()).field_70170_p.func_72838_d(this.getEntity());
            this.setOriginalEntity(null);
        }
    }

    @JvmDefault
    default public void bindTo(@NotNull EntityPlayer player) {
        Object name2;
        boolean bl;
        Object object;
        block9: {
            Object object2;
            block8: {
                Intrinsics.checkParameterIsNotNull(player, "player");
                this.validate();
                Familiar<?> familiar = Familiars.getBoundFamiliar(player);
                if (familiar != null) {
                    familiar.clearFamiliar();
                }
                if ((object2 = this.getNames()) == null) break block8;
                object = object2;
                bl = false;
                boolean bl2 = false;
                String[] it = object;
                boolean bl3 = false;
                object2 = it[player.func_70681_au().nextInt(it.length)];
                if (object2 != null) break block9;
            }
            object2 = name2 = "Familiar";
        }
        if (!this.getEntity().func_145818_k_()) {
            object = (CharSequence)name2;
            bl = false;
            if (object.length() > 0) {
                this.getEntity().func_96094_a((String)name2);
            }
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        FamiliarType<T, ?> type2 = this.getFamiliarType();
        Class<? extends Entity> key = FamiliarType.REGISTRY.getKey(type2);
        if (type2 == null || key == null) {
            playerEx.familiar = null;
        } else {
            NBTTagCompound tag = this.getEntity().func_189511_e(new NBTTagCompound());
            tag.func_74778_a("id", String.valueOf(EntityList.func_191301_a(this.getEntity())));
            NBTTagCompound nBTTagCompound = tag;
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "tag");
            playerEx.familiar = new FamiliarInstance(type2, key, nBTTagCompound, this.getColor(), true);
        }
        playerEx.markChanged();
        this.setFamiliar(50.0f);
    }

    @JvmDefault
    default public void dismiss(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        this.dismiss();
        if (this.isBoundTo(player)) {
            player.field_70170_p.func_72960_a(this.getEntity(), this.getParticleEffectId());
            WitcheryUtils.getExtension(player).markChanged();
        }
    }

    @JvmDefault
    default public void dismiss() {
        block2: {
            Entity entity = this.func_70902_q();
            if (entity == null) break block2;
            Entity entity2 = entity;
            boolean bl = false;
            boolean bl2 = false;
            Entity it = entity2;
            boolean bl3 = false;
            if (it instanceof EntityPlayer && this.isBoundTo((EntityPlayer)it)) {
                this.getEntity().func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / ((Entity)this.getEntity()).field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                this.getEntity().func_70106_y();
                PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)it);
                FamiliarInstance instance = playerEx.familiar;
                if (instance != null) {
                    instance.setSummoned(false);
                    instance.setColor(this.getColor());
                    instance.getData().func_74778_a("id", String.valueOf(EntityList.func_191301_a(this.getEntity())));
                    this.getEntity().func_189511_e(instance.getData());
                }
            }
        }
    }

    @JvmDefault
    default public boolean isBoundTo(@NotNull EntityPlayer boundEntity) {
        Intrinsics.checkParameterIsNotNull(boundEntity, "boundEntity");
        return Intrinsics.areEqual(Familiars.getFamiliarId(boundEntity), this.getEntity().func_110124_au());
    }

    @JvmDefault
    @SideOnly(value=Side.CLIENT)
    default public void color(float red, float green, float blue, float multiplier) {
        int c = this.getColor().func_193350_e();
        float r = (float)(c >>> 16 & 0xFF) / 255.0f;
        float g = (float)(c >>> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)(r * multiplier + red), (float)(g * multiplier + green), (float)(b * multiplier + blue));
    }

    @JvmDefault
    @SideOnly(value=Side.CLIENT)
    default public boolean handleDismissParticles(byte id) {
        if (id == this.getParticleEffectId()) {
            int n = 20;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                ((Entity)this.getEntity()).field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, ((Entity)this.getEntity()).field_70165_t + ((Entity)this.getEntity()).field_70170_p.field_73012_v.nextDouble() * (double)2 - 1.0, ((Entity)this.getEntity()).field_70163_u + ((Entity)this.getEntity()).field_70170_p.field_73012_v.nextDouble(), ((Entity)this.getEntity()).field_70161_v + (double)(((Entity)this.getEntity()).field_70170_p.field_73012_v.nextFloat() * (float)2) - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return false;
    }

    default public byte getParticleEffectId() {
        return 64;
    }

    default public boolean isFamiliarSitting() {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "isFamiliarSitting");
            throw null;
        }
        return ((EntityTameable)it).func_70906_o();
    }

    @JvmDefault
    default public void setFamiliarHealth(float value) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityLivingBase)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarHealth");
            throw null;
        }
        ((EntityLivingBase)it).func_70606_j(value);
    }

    @JvmDefault
    @NotNull
    default public IAttributeInstance getFamiliarAttribute(@NotNull IAttribute attribute) {
        Intrinsics.checkParameterIsNotNull(attribute, "attribute");
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityLivingBase)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "getFamiliarAttribute");
            throw null;
        }
        IAttributeInstance iAttributeInstance = ((EntityLivingBase)it).func_110148_a(attribute);
        Intrinsics.checkExpressionValueIsNotNull(iAttributeInstance, "it.getEntityAttribute(attribute)");
        return iAttributeInstance;
    }

    @JvmDefault
    default public void setFamiliarTamed(boolean value) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarTamed");
            throw null;
        }
        ((EntityTameable)it).func_70903_f(value);
    }

    @JvmDefault
    default public void setFamiliarOwnerId(@Nullable UUID id) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarOwnerId");
            throw null;
        }
        ((EntityTameable)it).func_184754_b(id);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @JvmDefault
        public static /* synthetic */ void isFamiliar$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void color$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void defaultHealth$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void colorParameter$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void names$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void entity$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void originalEntity$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void isValid$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void particleEffectId$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void isFamiliarSitting$annotations() {
        }

        private static <T extends Entity> Void throwImplementationException(Familiar<T> $this, String name2) {
            throw (Throwable)new IllegalStateException(name2 + " is not implemented in " + Reflection.getOrCreateKotlinClass($this.getClass()).getSimpleName());
        }
    }
}

