/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.familiar;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.resources.FamiliarPowerManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u001e\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u0016\u0010%\u001a\u00020\u000e*\u0004\u0018\u00010\u00072\b\u0010&\u001a\u0004\u0018\u00010'\u001a(\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*\"2\u0010\u0000\u001a&\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001j\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001b\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0002*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"%\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0003\"\b\b\u0000\u0010\u0015*\u00020\u000f*\u0002H\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"FAMILIAR_ENTITIES", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lnet/msrandom/witchery/entity/familiar/Familiar;", "Lkotlin/collections/HashMap;", "activeFamiliarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "Lnet/minecraft/entity/player/EntityPlayer;", "getActiveFamiliarType", "(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "boundFamiliar", "getBoundFamiliar", "(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/msrandom/witchery/entity/familiar/Familiar;", "canBeFamiliar", "", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)Z", "familiarId", "getFamiliarId", "(Lnet/minecraft/entity/player/EntityPlayer;)Ljava/util/UUID;", "familiarInstance", "T", "getFamiliarInstance", "(Lnet/minecraft/entity/Entity;)Lnet/msrandom/witchery/entity/familiar/Familiar;", "familiarName", "", "getFamiliarName", "(Lnet/minecraft/entity/player/EntityPlayer;)Ljava/lang/String;", "getBoundFamiliarById", "player", "uuidFamiliar", "handleLivingDeath", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "handlePlayerHurt", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "hasFamiliarPower", "power", "Lnet/minecraft/util/ResourceLocation;", "summonFamiliar", "x", "", "y", "z", "WitcheryResurrected"})
@JvmName(name="Familiars")
public final class Familiars {
    private static final HashMap<UUID, Familiar<?>> FAMILIAR_ENTITIES;

    @JvmName(name="canBeFamiliar")
    public static final boolean canBeFamiliar(@NotNull Entity $this$canBeFamiliar) {
        Intrinsics.checkParameterIsNotNull($this$canBeFamiliar, "$this$canBeFamiliar");
        return $this$canBeFamiliar instanceof Familiar && ((Familiar)$this$canBeFamiliar).getFamiliarType() != null || FamiliarType.REGISTRY.contains($this$canBeFamiliar.getClass());
    }

    @Contract(pure=false)
    @NotNull
    public static final <T extends Entity> Familiar<T> getFamiliarInstance(@NotNull T $this$familiarInstance) {
        Familiar familiar;
        FamiliarType<Object, Object> familiarType;
        Intrinsics.checkParameterIsNotNull($this$familiarInstance, "$this$familiarInstance");
        if ($this$familiarInstance instanceof Familiar) {
            familiarType = ((Familiar)$this$familiarInstance).getFamiliarType();
        } else {
            FamiliarType<Entity, Familiar<?>> familiarType2 = FamiliarType.REGISTRY.get($this$familiarInstance.getClass());
            if (!(familiarType2 instanceof FamiliarType)) {
                familiarType2 = null;
            }
            familiarType = familiarType2;
        }
        FamiliarType type2 = familiarType;
        Map map2 = FAMILIAR_ENTITIES;
        UUID uUID = $this$familiarInstance.func_110124_au();
        boolean bl = false;
        Map map3 = map2;
        boolean bl2 = false;
        if (map3.containsKey(uUID)) {
            Familiar familiar2 = FAMILIAR_ENTITIES.get($this$familiarInstance.func_110124_au());
            if (familiar2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.entity.familiar.Familiar<T>");
            }
            Familiar familiar3 = familiar2;
            FamiliarType familiarType3 = type2;
            if (familiarType3 == null) {
                Intrinsics.throwNpe();
            }
            familiarType3.update($this$familiarInstance, familiar3);
            familiar = familiar3;
        } else if (Familiars.canBeFamiliar($this$familiarInstance)) {
            Familiar<Object> familiar4;
            if ($this$familiarInstance instanceof Familiar) {
                familiar4 = (Familiar)$this$familiarInstance;
            } else {
                FamiliarType familiarType4 = type2;
                if (familiarType4 == null) {
                    Intrinsics.throwNpe();
                }
                familiar4 = familiarType4.create($this$familiarInstance);
            }
            Familiar result2 = familiar4;
            Map map4 = FAMILIAR_ENTITIES;
            UUID uUID2 = $this$familiarInstance.func_110124_au();
            Intrinsics.checkExpressionValueIsNotNull(uUID2, "uniqueID");
            map4.put(uUID2, result2);
            familiar = result2;
            if (familiar == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.entity.familiar.Familiar<T>");
            }
        } else {
            throw (Throwable)new IllegalArgumentException(EntityList.func_191301_a($this$familiarInstance) + " can not be a familiar, please use the canBeFamiliar method to check before using this one");
        }
        return familiar;
    }

    @Nullable
    public static final Familiar<?> getBoundFamiliarById(@NotNull EntityPlayer player, @Nullable UUID uuidFamiliar) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        if (uuidFamiliar != null) {
            MinecraftServer minecraftServer = player.func_184102_h();
            if (minecraftServer != null) {
                MinecraftServer minecraftServer2 = minecraftServer;
                boolean bl = false;
                boolean bl2 = false;
                MinecraftServer server = minecraftServer2;
                boolean bl3 = false;
                Intrinsics.checkExpressionValueIsNotNull(server.field_71305_c, "server.worlds");
                WorldServer[] $this$forEach$iv = server.field_71305_c;
                boolean $i$f$forEach = false;
                WorldServer[] worldServerArray = $this$forEach$iv;
                int n = worldServerArray.length;
                for (int i = 0; i < n; ++i) {
                    WorldServer element$iv;
                    WorldServer world = element$iv = worldServerArray[i];
                    boolean bl4 = false;
                    Object object = world.func_175733_a(uuidFamiliar);
                    if (object == null) continue;
                    Entity entity = object;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Entity receiver = entity;
                    boolean bl7 = false;
                    object = Familiars.canBeFamiliar(receiver) ? entity : null;
                    if (object == null || (object = Familiars.getFamiliarInstance(object)) == null) continue;
                    entity = object;
                    bl5 = false;
                    bl6 = false;
                    Entity it = entity;
                    boolean bl8 = false;
                    return it;
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Familiar<?> getBoundFamiliar(@NotNull EntityPlayer $this$boundFamiliar) {
        Intrinsics.checkParameterIsNotNull($this$boundFamiliar, "$this$boundFamiliar");
        return Familiars.getBoundFamiliarById($this$boundFamiliar, Familiars.getFamiliarId($this$boundFamiliar));
    }

    @Nullable
    public static final UUID getFamiliarId(@NotNull EntityPlayer $this$familiarId) {
        Intrinsics.checkParameterIsNotNull($this$familiarId, "$this$familiarId");
        FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$familiarId).familiar;
        return familiarInstance != null && (familiarInstance = familiarInstance.getData()) != null ? familiarInstance.func_186857_a("UUID") : null;
    }

    public static final boolean hasFamiliarPower(@Nullable EntityPlayer $this$hasFamiliarPower, @Nullable ResourceLocation power) {
        Set<ResourceLocation> set2;
        if ($this$hasFamiliarPower == null) {
            return false;
        }
        if (power == null) {
            return true;
        }
        FamiliarType<?, ?> familiarType = Familiars.getActiveFamiliarType($this$hasFamiliarPower);
        if (familiarType != null) {
            FamiliarType<?, ?> familiarType2 = familiarType;
            HashMap<FamiliarType<?, ?>, Set<ResourceLocation>> hashMap = FamiliarPowerManager.INSTANCE.getPowers();
            boolean bl = false;
            boolean bl2 = false;
            FamiliarType<?, ?> p1 = familiarType2;
            boolean bl3 = false;
            set2 = hashMap.get(p1);
        } else {
            set2 = null;
        }
        Set<ResourceLocation> powers = set2;
        return powers != null && powers.contains(power);
    }

    @Nullable
    public static final FamiliarType<?, ?> getActiveFamiliarType(@NotNull EntityPlayer $this$activeFamiliarType) {
        FamiliarType<?, ?> familiarType;
        Intrinsics.checkParameterIsNotNull($this$activeFamiliarType, "$this$activeFamiliarType");
        if (!$this$activeFamiliarType.field_70170_p.field_72995_K) {
            FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$activeFamiliarType).familiar;
            if (familiarInstance != null) {
                FamiliarInstance familiarInstance2 = familiarInstance;
                boolean bl = false;
                boolean bl2 = false;
                FamiliarInstance it = familiarInstance2;
                boolean bl3 = false;
                familiarType = it.isSummoned() ? it.getFamiliarType() : null;
            } else {
                familiarType = null;
            }
        } else {
            familiarType = null;
        }
        return familiarType;
    }

    public static final void handlePlayerHurt(@NotNull LivingHurtEvent event, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Intrinsics.checkParameterIsNotNull(player, "player");
        World world = event.getEntityLiving().field_70170_p;
        if (!world.field_72995_K && !event.isCanceled()) {
            float totalDamage = event.getAmount();
            float redirectedDamage = totalDamage * 0.01f;
            FamiliarInstance instance = WitcheryUtils.getExtension((EntityPlayer)player).familiar;
            if (instance != null) {
                Familiar<?> familiar = Familiars.getBoundFamiliarById(player, Familiars.getFamiliarId(player));
                if (familiar != null) {
                    Object entity = familiar.getEntity();
                    if (entity.func_70068_e((Entity)player) <= (double)576.0f) {
                        redirectedDamage = totalDamage * 0.1f;
                    }
                    if (redirectedDamage >= 1.0f) {
                        entity.func_70097_a(event.getSource(), redirectedDamage);
                    }
                }
                event.setAmount(event.getAmount() - redirectedDamage);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void handleLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        World world = event.getEntityLiving().field_70170_p;
        if (world.field_72995_K) return;
        if (event.isCanceled()) return;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Familiar<?> familiar;
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            if (entityLivingBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            Familiar<?> familiar2 = familiar = Familiars.getBoundFamiliar(player);
            if (familiar2 == null) return;
            Familiar<?> familiar3 = familiar2;
            boolean bl = false;
            boolean bl2 = false;
            Familiar<?> it = familiar3;
            boolean bl3 = false;
            if (((Entity)it.getEntity()).field_70128_L) return;
            Entity owner = it.func_70902_q();
            it.dismiss();
            World world2 = world;
            Intrinsics.checkExpressionValueIsNotNull(world2, "world");
            WitcheryUtils.addNewParticles$default(world2, EnumParticleTypes.SPELL_INSTANT, ((Entity)it.getEntity()).field_70165_t, ((Entity)it.getEntity()).field_70163_u, ((Entity)it.getEntity()).field_70161_v, 0.0, 20, 0.0, 0.0, 192, null);
            if (!(owner instanceof EntityPlayer)) return;
            WitcheryUtils.getExtension((EntityPlayer)owner).markChanged();
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        Familiar<Entity> familiar = Familiars.getFamiliarInstance((Entity)entity);
        boolean bl = false;
        boolean bl4 = false;
        Familiar<Entity> it = familiar;
        boolean bl5 = false;
        if (!it.isFamiliar()) return;
        Entity owner = it.func_70902_q();
        if (owner instanceof EntityPlayer) {
            Entity entity2 = it.getEntity();
            Intrinsics.checkExpressionValueIsNotNull(entity2, "it.entity");
            if (Intrinsics.areEqual(((EntityLivingBase)entity2).func_110124_au(), Familiars.getFamiliarId((EntityPlayer)owner))) {
                owner.func_70097_a(DamageSource.field_76376_m, ((EntityPlayer)owner).func_110138_aP() * 2.0f);
                it.dismiss();
                World world3 = world;
                Intrinsics.checkExpressionValueIsNotNull(world3, "world");
                WitcheryUtils.addNewParticles$default(world3, EnumParticleTypes.SPELL_INSTANT, ((EntityLivingBase)it.getEntity()).field_70165_t, ((EntityLivingBase)it.getEntity()).field_70163_u, ((EntityLivingBase)it.getEntity()).field_70161_v, 0.0, 20, 0.0, 0.0, 192, null);
                WitcheryUtils.getExtension((EntityPlayer)owner).markChanged();
                event.setCanceled(true);
                return;
            }
        }
        EntityLivingBase entityLivingBase = entity;
        Intrinsics.checkExpressionValueIsNotNull(entityLivingBase, "entity");
        entityLivingBase.func_70606_j(1.0f);
        event.setCanceled(true);
    }

    @Nullable
    public static final String getFamiliarName(@NotNull EntityPlayer $this$familiarName) {
        Intrinsics.checkParameterIsNotNull($this$familiarName, "$this$familiarName");
        FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$familiarName).familiar;
        return familiarInstance != null && (familiarInstance = familiarInstance.getData()) != null ? familiarInstance.func_74779_i("CustomName") : null;
    }

    @Nullable
    public static final Familiar<?> summonFamiliar(@NotNull EntityPlayer $this$summonFamiliar, double x, double y, double z) {
        FamiliarInstance instance;
        Intrinsics.checkParameterIsNotNull($this$summonFamiliar, "$this$summonFamiliar");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension($this$summonFamiliar);
        FamiliarInstance familiarInstance = instance = playerEx.familiar;
        if (familiarInstance != null) {
            if (!familiarInstance.isSummoned()) {
                FamiliarType<?, ?> type2 = instance.getFamiliarType();
                Entity entity = EntityList.func_75615_a((NBTTagCompound)instance.getData(), (World)$this$summonFamiliar.field_70170_p);
                if (entity != null) {
                    entity.func_70012_b(x, y, z, 0.0f, 0.0f);
                    Object familiar = type2.create(entity);
                    familiar.setColor(instance.getColor());
                    familiar.setFamiliarTamed(true);
                    familiar.setFamiliarOwnerId($this$summonFamiliar.func_110124_au());
                    familiar.setFamiliar(50.0f);
                    $this$summonFamiliar.field_70170_p.func_72838_d(familiar.getEntity());
                    $this$summonFamiliar.field_70170_p.func_72960_a(familiar.getEntity(), (byte)7);
                    instance.setSummoned(true);
                    familiar.getEntity().func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / $this$summonFamiliar.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    return familiar;
                }
            }
        }
        return null;
    }

    static {
        boolean bl = false;
        FAMILIAR_ENTITIES = new HashMap();
    }
}

