/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.item;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.util.CreatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt;", "Lnet/minecraft/entity/projectile/EntityArrow;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "shooter", "Lnet/minecraft/entity/EntityLivingBase;", "rapid", "", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;Z)V", "isHoly", "()Z", "setHoly", "(Z)V", "isPoweredDraining", "setPoweredDraining", "stack", "Lnet/minecraft/item/ItemStack;", "getArrowStack", "onHit", "", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "readEntityFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "setBolt", "item", "Lnet/minecraft/item/Item;", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityCrossbowBolt
extends EntityArrow {
    private boolean isPoweredDraining;
    private boolean isHoly;
    private ItemStack stack;
    private boolean rapid;
    public static final Companion Companion = new Companion(null);

    public final boolean isPoweredDraining() {
        return this.isPoweredDraining;
    }

    public final void setPoweredDraining(boolean bl) {
        this.isPoweredDraining = bl;
    }

    public final boolean isHoly() {
        return this.isHoly;
    }

    public final void setHoly(boolean bl) {
        this.isHoly = bl;
    }

    public final void setBolt(@NotNull Item item) {
        Intrinsics.checkParameterIsNotNull(item, "item");
        this.stack = new ItemStack(item);
    }

    public void func_70014_b(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.func_70014_b(tag);
        tag.func_74757_a("Rapid", this.rapid);
    }

    public void func_70037_a(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.func_70037_a(tag);
        this.rapid = tag.func_74767_n("Rapid");
    }

    protected void func_184549_a(@NotNull RayTraceResult hit) {
        Entity entity;
        Intrinsics.checkParameterIsNotNull(hit, "hit");
        if (!this.field_70170_p.field_72995_K && hit.field_72313_a == RayTraceResult.Type.ENTITY && (entity = hit.field_72308_g) instanceof EntityLivingBase) {
            if (!this.rapid) {
                Vec3d direction = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                Vec3d entityLook = new Vec3d(((EntityLivingBase)entity).func_70040_Z().field_72450_a, 0.0, ((EntityLivingBase)entity).func_70040_Z().field_72448_b);
                double dot = entityLook.func_72430_b(new Vec3d(direction.field_72450_a, 0.0, direction.field_72448_b));
                if (dot > 0.0) {
                    EntityCrossbowBolt entityCrossbowBolt = this;
                    entityCrossbowBolt.func_70239_b(entityCrossbowBolt.func_70242_d() * (1.0 + dot));
                }
            }
            if (this.isPoweredDraining) {
                Iterator iterator2 = ((EntityLivingBase)entity).func_70651_bq().iterator();
                while (iterator2.hasNext()) {
                    PotionEffect effect;
                    PotionEffect potionEffect = effect = (PotionEffect)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(potionEffect, "effect");
                    if (!(Intrinsics.areEqual(potionEffect.func_188419_a(), MobEffects.field_76436_u) ^ true) || !(Intrinsics.areEqual(effect.func_188419_a(), MobEffects.field_82731_v) ^ true) || !(Intrinsics.areEqual(effect.func_188419_a(), MobEffects.field_76431_k) ^ true)) continue;
                    iterator2.remove();
                }
                Infusion.reducePowerLevels((EntityLivingBase)entity, 0.5f);
            }
            if (this.isHoly && (CreatureUtil.isUndead(entity) || CreatureUtil.isDemonic(entity))) {
                EntityCrossbowBolt entityCrossbowBolt = this;
                entityCrossbowBolt.func_70239_b(entityCrossbowBolt.func_70242_d() * 3.5);
            }
        }
        super.func_184549_a(hit);
    }

    @NotNull
    public ItemStack func_184550_j() {
        return this.stack;
    }

    public EntityCrossbowBolt(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        super(world);
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        this.stack = itemStack;
    }

    public EntityCrossbowBolt(@NotNull World world, @NotNull EntityLivingBase shooter, boolean rapid) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(shooter, "shooter");
        super(world, shooter);
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        this.stack = itemStack;
        this.rapid = rapid;
    }

    @JvmStatic
    @Nullable
    public static final EntityCrossbowBolt getSourceBolt(@NotNull DamageSource source) {
        return Companion.getSourceBolt(source);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt$Companion;", "", "()V", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getSourceBolt", "Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt;", "source", "Lnet/minecraft/util/DamageSource;", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final EntityCrossbowBolt getSourceBolt(@NotNull DamageSource source) {
            Intrinsics.checkParameterIsNotNull(source, "source");
            Entity entity = source.func_76364_f();
            if (!(entity instanceof EntityCrossbowBolt)) {
                entity = null;
            }
            return (EntityCrossbowBolt)entity;
        }

        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().size(0.5f, 0.5f).track(10, 64).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

