/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.villager;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.GlobalPos;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.msrandom.witchery.entity.villager.EntityAIVillagerBehavior;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.world.gen.structure.PointOfInterests;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/entity/villager/EntityAIVillagerSetHome;", "Lnet/msrandom/witchery/entity/villager/EntityAIVillagerBehavior;", "villager", "Lnet/minecraft/entity/passive/EntityVillager;", "(Lnet/minecraft/entity/passive/EntityVillager;)V", "batchCache", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lnet/msrandom/witchery/entity/villager/EntityAIVillagerSetHome$JitteredLinearRetry;", "nextScheduledStart", "", "shouldExecute", "", "startExecuting", "", "JitteredLinearRetry", "WitcheryResurrected"})
public final class EntityAIVillagerSetHome
extends EntityAIVillagerBehavior {
    private long nextScheduledStart;
    private final Long2ObjectOpenHashMap<JitteredLinearRetry> batchCache;

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            long time = this.getWorld().func_82737_E();
            if (this.getVillagerEx().getHome() == null) {
                this.setReady();
                if (this.nextScheduledStart == 0L) {
                    this.nextScheduledStart = time + (long)this.getWorld().field_73012_v.nextInt(20);
                    return false;
                }
                return time >= this.nextScheduledStart;
            }
        }
        return false;
    }

    public void func_75249_e() {
        long time = this.getWorld().func_82737_E();
        this.nextScheduledStart = time + 20L + (long)this.getWorld().field_73012_v.nextInt(20);
        this.batchCache.long2ObjectEntrySet().removeIf((Predicate)new Predicate<Long2ObjectMap.Entry<JitteredLinearRetry>>(time){
            final /* synthetic */ long $time;

            public final boolean test(Long2ObjectMap.Entry<JitteredLinearRetry> $dstr$_u24__u24$value) {
                Map.Entry entry2 = (Map.Entry)$dstr$_u24__u24$value;
                boolean bl = false;
                JitteredLinearRetry value = (JitteredLinearRetry)entry2.getValue();
                return !value.isStillValid(this.$time);
            }
            {
                this.$time = l;
            }
        });
        Predicate predicate2 = new Predicate<BlockPos>(this, time){
            final /* synthetic */ EntityAIVillagerSetHome this$0;
            final /* synthetic */ long $time;

            public final boolean test(@NotNull BlockPos it) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(it, "it");
                JitteredLinearRetry jitteredLinearRetry = (JitteredLinearRetry)EntityAIVillagerSetHome.access$getBatchCache$p(this.this$0).get(it.func_177986_g());
                if (jitteredLinearRetry == null) {
                    bl = true;
                } else if (!jitteredLinearRetry.shouldRetry(this.$time)) {
                    bl = false;
                } else {
                    jitteredLinearRetry.markAttempt(this.$time);
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = entityAIVillagerSetHome;
                this.$time = l;
            }
        };
        World world = this.getWorld();
        BlockPos blockPos = this.getVillager().func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "villager.position");
        Set<BlockPos> set2 = SequencesKt.toSet(SequencesKt.take(PointOfInterests.INSTANCE.getSortedBeds(world, blockPos, predicate2, 48), 5));
        Path path = null;
        BlockPos position = null;
        for (BlockPos pos : set2) {
            path = this.getVillager().func_70661_as().func_179680_a(pos);
            if (path == null) continue;
            position = pos;
            break;
        }
        if (path != null && position != null) {
            if (PointOfInterests.INSTANCE.take(this.getWorld(), position)) {
                WorldProvider worldProvider = this.getWorld().field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
                WitcheryDataExtensions.VILLAGER.get((EntityVillager)((Entity)this.getVillager())).setHome(GlobalPos.Companion.of(worldProvider.getDimension(), position));
                this.getWorld().func_72960_a((Entity)this.getVillager(), (byte)14);
                this.batchCache.clear();
            }
        } else {
            for (BlockPos pos : set2) {
                this.batchCache.computeIfAbsent((Object)pos.func_177986_g(), (Function)new Function<Long, JitteredLinearRetry>(this, time){
                    final /* synthetic */ EntityAIVillagerSetHome this$0;
                    final /* synthetic */ long $time;

                    @NotNull
                    public final JitteredLinearRetry apply(Long it) {
                        Random random = this.this$0.getWorld().field_73012_v;
                        Intrinsics.checkExpressionValueIsNotNull(random, "world.rand");
                        return new JitteredLinearRetry(random, this.$time);
                    }
                    {
                        this.this$0 = entityAIVillagerSetHome;
                        this.$time = l;
                    }
                });
            }
        }
    }

    public EntityAIVillagerSetHome(@NotNull EntityVillager villager) {
        Intrinsics.checkParameterIsNotNull(villager, "villager");
        super(villager, false, 0, 0, 12, null);
        this.batchCache = new Long2ObjectOpenHashMap();
    }

    public static final /* synthetic */ Long2ObjectOpenHashMap access$getBatchCache$p(EntityAIVillagerSetHome $this) {
        return $this.batchCache;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/msrandom/witchery/entity/villager/EntityAIVillagerSetHome$JitteredLinearRetry;", "", "random", "Ljava/util/Random;", "time", "", "(Ljava/util/Random;J)V", "currentDelay", "", "nextScheduledAttemptTimestamp", "previousAttemptTimestamp", "isStillValid", "", "markAttempt", "", "shouldRetry", "WitcheryResurrected"})
    private static final class JitteredLinearRetry {
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;
        private final Random random;

        public final void markAttempt(long time) {
            this.previousAttemptTimestamp = time;
            int delay = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = RangesKt.coerceAtMost(delay, 400);
            this.nextScheduledAttemptTimestamp = time + (long)this.currentDelay;
        }

        public final boolean isStillValid(long time) {
            return time - this.previousAttemptTimestamp < 400L;
        }

        public final boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptTimestamp;
        }

        public JitteredLinearRetry(@NotNull Random random, long time) {
            Intrinsics.checkParameterIsNotNull(random, "random");
            this.random = random;
            this.markAttempt(time);
        }
    }
}

