/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.extensions;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.advancement.WitcheryExtensionTrigger;
import net.msrandom.witchery.common.CovenWitchData;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.extensions.WitcheryExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.infusion.effect.ImpPlayerEffect;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryBookItems;
import net.msrandom.witchery.network.PacketExtendedPlayerSync;
import net.msrandom.witchery.network.PacketPartialExtendedPlayerSync;
import net.msrandom.witchery.network.PacketPlayerStyle;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.prediction.PredictionData;
import net.msrandom.witchery.resources.CovenQuestManager;
import net.msrandom.witchery.resources.PredictionManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.transformation.CreatureTrait;
import net.msrandom.witchery.transformation.CreatureTraitType;
import net.msrandom.witchery.util.DimensionalLocation;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerExtendedData
extends WitcheryExtendedData<EntityPlayer> {
    public static final int MAX_HUMAN_BLOOD = 500;
    private static final long COOLDOWN_ESCAPE_1_TICKS = 6000L;
    private static final long COOLDOWN_ESCAPE_2_TICKS = 72000L;
    public final Map<CreatureTraitType<?>, CreatureTrait> transformations = new HashMap();
    private final ConcurrentMap<Potion, PotionEffect> incurablePotionEffectCache = new ConcurrentHashMap<Potion, PotionEffect>();
    public final Object2IntMap<ImpPlayerEffect> playerEffects = new Object2IntOpenHashMap();
    public int cachedWorship = -1;
    private boolean getPlayerData;
    private boolean resetSleep;
    private int cachedSky;
    private long mirrorWorldEscapeCooldown1 = Long.MIN_VALUE;
    private long mirrorWorldEscapeCooldown2 = Long.MIN_VALUE;
    private int bottlingSkill;
    private int throwingSkill;
    @Nullable
    private CreatureForm currentForm;
    @Nullable
    public FamiliarInstance familiar;
    @NotNull
    public InfusionPower infusionPower = new InfusionPower(Infusion.DEFUSED, 0, 0);
    @Nullable
    public CreaturePowerData creaturePower;
    public final Set<CovenWitchData> coven = new LinkedHashSet<CovenWitchData>();
    public final List<PredictionData> predictions = new ArrayList<PredictionData>();
    public final Set<PotionEffect> permanentEffects = new HashSet<PotionEffect>();
    private DimensionalLocation recallPosition;
    private boolean visitedNether;
    private boolean isFortuneTeller;
    private int humanBlood;
    private GameProfile otherPlayer;
    private NBTTagList cachedInventory;
    private boolean inventoryCanBeRestored;
    private BlockPos mirrorWorldEntryPoint;
    private SpiritWorldData spiritData;
    private TormentWorldData tormentData;
    public int grotesqueTicks;
    private final AtomicBoolean changed = new AtomicBoolean();
    private NBTTagCompound oldData;

    @Override
    public void write(NBTTagCompound tag) {
        ResourceLocation form;
        tag.func_74768_a("BottlingSkill", this.bottlingSkill);
        tag.func_74768_a("ThrowingSkill", this.throwingSkill);
        if (this.currentForm != null && (form = (ResourceLocation)CreatureForm.REGISTRY.getKey(this.currentForm)) != null) {
            tag.func_74778_a("Form", form.toString());
        }
        if (this.familiar != null) {
            NBTTagCompound familiarTag = new NBTTagCompound();
            familiarTag.func_74778_a("Type", EntityList.func_191306_a(this.familiar.getEntityType()).toString());
            familiarTag.func_74782_a("Data", (NBTBase)this.familiar.getData());
            familiarTag.func_74774_a("Color", (byte)this.familiar.getColor().func_176765_a());
            familiarTag.func_74757_a("Summoned", this.familiar.isSummoned());
            tag.func_74782_a("Familiar", (NBTBase)familiarTag);
        }
        if (this.infusionPower.getInfusionType() != Infusion.DEFUSED) {
            NBTTagCompound infusionTag = new NBTTagCompound();
            infusionTag.func_74778_a("ID", ((ResourceLocation)Infusion.REGISTRY.getKey(this.infusionPower.getInfusionType())).toString());
            infusionTag.func_74768_a("CurrentPower", this.infusionPower.getCurrentPower());
            infusionTag.func_74768_a("MaxPower", this.infusionPower.getMaxPower());
            tag.func_74782_a("Infusion", (NBTBase)infusionTag);
        }
        if (this.creaturePower != null) {
            NBTTagCompound creaturePowerTag = new NBTTagCompound();
            creaturePowerTag.func_74778_a("ID", EntityList.func_191306_a(this.creaturePower.getEntityType()).toString());
            creaturePowerTag.func_74768_a("Charges", this.creaturePower.getCharges());
            tag.func_74782_a("CreatureAbility", (NBTBase)creaturePowerTag);
        }
        tag.func_74757_a("VisitedNether", this.hasVisitedNether());
        tag.func_74757_a("FortuneTeller", this.isFortuneTeller());
        NBTTagList covenWitches = new NBTTagList();
        NBTTagList predictionData = new NBTTagList();
        NBTTagList permanentEffectData = new NBTTagList();
        for (CovenWitchData covenWitchData : this.coven) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Name", covenWitchData.getName());
            nBTTagCompound.func_74768_a("Variant", covenWitchData.getVariant());
            nBTTagCompound.func_186854_a("ID", covenWitchData.getId());
            ResourceLocation quest = CovenQuestManager.INSTANCE.getRegistry().getKey(covenWitchData.getQuest());
            if (quest != null) {
                nBTTagCompound.func_74778_a("Quest", quest.toString());
            }
            covenWitches.func_74742_a((NBTBase)nBTTagCompound);
        }
        for (PredictionData predictionData2 : this.predictions) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            ResourceLocation id = PredictionManager.INSTANCE.getRegistry().getKey(predictionData2.getPrediction());
            if (id == null) continue;
            nBTTagCompound.func_74778_a("ID", id.toString());
            nBTTagCompound.func_74768_a("Time", predictionData2.getTicks());
            predictionData.func_74742_a((NBTBase)nBTTagCompound);
        }
        for (PotionEffect potionEffect : this.permanentEffects) {
            permanentEffectData.func_74742_a((NBTBase)potionEffect.func_82719_a(new NBTTagCompound()));
        }
        tag.func_74782_a("Coven", (NBTBase)covenWitches);
        tag.func_74782_a("Predictions", (NBTBase)predictionData);
        tag.func_74782_a("PermanentEffects", (NBTBase)permanentEffectData);
        if (this.recallPosition != null) {
            NBTTagCompound recall = new NBTTagCompound();
            recall.func_74768_a("Dimension", this.recallPosition.dimension.func_186068_a());
            recall.func_74780_a("X", this.recallPosition.posX);
            recall.func_74780_a("Y", this.recallPosition.posY);
            recall.func_74780_a("Z", this.recallPosition.posZ);
            tag.func_74782_a("Recall", (NBTBase)recall);
        }
        NBTTagCompound transformationsTag = new NBTTagCompound();
        for (Map.Entry<CreatureTraitType<?>, CreatureTrait> entry2 : this.transformations.entrySet()) {
            if (entry2.getValue().getLevel() <= 0) continue;
            NBTTagCompound transformationTag = new NBTTagCompound();
            entry2.getValue().serialize(transformationTag);
            transformationsTag.func_74782_a(((ResourceLocation)CreatureTraitType.REGISTRY.getKey(entry2.getKey())).toString(), (NBTBase)transformationTag);
        }
        tag.func_74782_a("CreatureTraits", (NBTBase)transformationsTag);
        tag.func_74768_a("HumanBlood", this.humanBlood);
        if (this.cachedInventory != null) {
            tag.func_74782_a("CachedInventory", (NBTBase)this.cachedInventory.func_74737_b());
            tag.func_74757_a("CanRestoreInventory", this.inventoryCanBeRestored);
        }
        if (this.mirrorWorldEntryPoint != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("posX", this.mirrorWorldEntryPoint.func_177958_n());
            nBTTagCompound.func_74768_a("posY", this.mirrorWorldEntryPoint.func_177956_o());
            nBTTagCompound.func_74768_a("posZ", this.mirrorWorldEntryPoint.func_177952_p());
            tag.func_74782_a("MirrorWorldEntryPoint", (NBTBase)nBTTagCompound);
        }
        if (this.otherPlayer != null) {
            tag.func_74782_a("OtherPlayer", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.otherPlayer));
        }
        tag.func_74772_a("MirrorEscape1", this.mirrorWorldEscapeCooldown1);
        tag.func_74772_a("MirrorEscape2", this.mirrorWorldEscapeCooldown2);
        this.getSpiritData().write(tag);
        this.getTormentData().write(tag);
        this.oldData = tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        Object predictionTag;
        int i;
        this.bottlingSkill = tag.func_74762_e("BottlingSkill");
        if (tag.func_74764_b("Form")) {
            this.currentForm = (CreatureForm)CreatureForm.REGISTRY.get(new ResourceLocation(tag.func_74779_i("Form")));
        }
        if (tag.func_74764_b("Familiar")) {
            NBTTagCompound familiarTag = tag.func_74775_l("Familiar");
            Class type2 = EntityList.getClass((ResourceLocation)new ResourceLocation(familiarTag.func_74779_i("Type")));
            this.familiar = new FamiliarInstance(FamiliarType.REGISTRY.get(type2), type2, familiarTag.func_74775_l("Data"), EnumDyeColor.func_176764_b((int)familiarTag.func_74771_c("Color")), familiarTag.func_74767_n("Summoned"));
        }
        if (tag.func_74764_b("Infusion")) {
            NBTTagCompound infusionTag = tag.func_74775_l("Infusion");
            this.infusionPower = new InfusionPower((Infusion)Infusion.REGISTRY.get(new ResourceLocation(infusionTag.func_74779_i("ID"))), infusionTag.func_74762_e("CurrentPower"), infusionTag.func_74762_e("MaxPower"));
        }
        if (tag.func_74764_b("CreatureAbility")) {
            NBTTagCompound creaturePowerTag = tag.func_74775_l("CreatureAbility");
            this.creaturePower = new CreaturePowerData(EntityList.getClass((ResourceLocation)new ResourceLocation(creaturePowerTag.func_74779_i("ID"))), creaturePowerTag.func_74762_e("Charges"));
        }
        this.setVisitedNether(tag.func_74767_n("VisitedNether"));
        this.setFortuneTeller(tag.func_74767_n("FortuneTeller"));
        NBTTagList covenWitches = tag.func_150295_c("Coven", 10);
        NBTTagList predictionsData = tag.func_150295_c("Predictions", 10);
        NBTTagList permanentEffectData = tag.func_150295_c("PermanentEffects", 10);
        this.coven.clear();
        this.predictions.clear();
        this.permanentEffects.clear();
        for (i = 0; i < covenWitches.func_74745_c(); ++i) {
            NBTTagCompound witchData = covenWitches.func_150305_b(i);
            this.coven.add(new CovenWitchData(witchData.func_74779_i("Name"), witchData.func_74762_e("Variant"), witchData.func_186857_a("ID"), witchData.func_74764_b("Quest") ? CovenQuestManager.INSTANCE.getRegistry().get(new ResourceLocation(witchData.func_74779_i("Quest"))) : null));
        }
        for (i = 0; i < predictionsData.func_74745_c(); ++i) {
            predictionTag = predictionsData.func_150305_b(i);
            Prediction prediction = PredictionManager.INSTANCE.getRegistry().get(new ResourceLocation(predictionTag.func_74779_i("ID")));
            if (prediction == null) continue;
            PredictionData predictionData = new PredictionData(prediction);
            predictionData.setTicks(predictionTag.func_74762_e("Time"));
            this.predictions.add(predictionData);
        }
        for (i = 0; i < permanentEffectData.func_74745_c(); ++i) {
            this.permanentEffects.add(PotionEffect.func_82722_b((NBTTagCompound)permanentEffectData.func_150305_b(i)));
        }
        if (tag.func_74764_b("Recall")) {
            NBTTagCompound recall = tag.func_74775_l("Recall");
            this.recallPosition = new DimensionalLocation(DimensionManager.getProviderType((int)recall.func_74762_e("Dimension")), recall.func_74769_h("X"), recall.func_74769_h("Y"), recall.func_74769_h("Z"));
        }
        NBTTagCompound transformationsTag = tag.func_74764_b("Transformations") ? tag.func_74775_l("Transformations") : tag.func_74775_l("CreatureTraits");
        predictionTag = transformationsTag.func_150296_c().iterator();
        while (predictionTag.hasNext()) {
            CreatureTraitType<CreatureTrait> type3;
            String key;
            switch (key = (String)predictionTag.next()) {
                case "witchery:vampire": {
                    type3 = WitcheryCreatureTraits.VAMPIRE;
                    break;
                }
                case "witchery:werewolf": {
                    type3 = WitcheryCreatureTraits.WEREWOLF;
                    break;
                }
                default: {
                    type3 = (CreatureTraitType)CreatureTraitType.REGISTRY.get(new ResourceLocation(key));
                }
            }
            CreatureTrait creatureTrait = type3.getCreate().invoke(this);
            creatureTrait.deserialize(transformationsTag.func_74775_l(key));
            this.transformations.put(type3, creatureTrait);
        }
        this.humanBlood = MathHelper.func_76125_a((int)tag.func_74762_e("HumanBlood"), (int)0, (int)500);
        if (tag.func_74764_b("CachedInventory")) {
            this.cachedInventory = tag.func_150295_c("CachedInventory", 10);
            this.inventoryCanBeRestored = tag.func_74767_n("CanRestoreInventory");
        }
        if (tag.func_74764_b("MirrorWorldEntryPoint")) {
            NBTTagCompound nbt = tag.func_74775_l("DimCoords");
            BlockPos coord = null;
            if (nbt.func_74764_b("posX") && nbt.func_74764_b("posY") && nbt.func_74764_b("posZ")) {
                coord = new BlockPos(nbt.func_74762_e("posX"), nbt.func_74762_e("posY"), nbt.func_74762_e("posZ"));
            }
            this.mirrorWorldEntryPoint = coord;
        }
        if (tag.func_74764_b("OtherPlayer")) {
            this.otherPlayer = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("OtherPlayer"));
        }
        this.mirrorWorldEscapeCooldown1 = tag.func_74763_f("MirrorEscape1");
        this.mirrorWorldEscapeCooldown2 = tag.func_74763_f("MirrorEscape2");
        this.getSpiritData().read(tag);
        this.getTormentData().read(tag);
    }

    public NBTTagCompound getOldData() {
        return this.oldData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        for (CreatureTrait creatureTrait : this.transformations.values()) {
            creatureTrait.tick();
        }
        if (this.changed.get()) {
            AtomicBoolean atomicBoolean = this.changed;
            synchronized (atomicBoolean) {
                if (!((EntityPlayer)this.entity).field_70170_p.field_72995_K) {
                    WitcheryNetworkChannel.sendTo(new PacketExtendedPlayerSync(this), (EntityPlayerMP)this.entity);
                    WitcheryExtensionTrigger.INSTANCE.trigger((EntityPlayerMP)this.entity);
                }
                this.changed.set(false);
                this.oldData = new NBTTagCompound();
                this.write(this.oldData);
            }
        }
    }

    public UUID getOtherPlayerId() {
        return this.otherPlayer == null ? null : EntityPlayer.func_146094_a((GameProfile)this.otherPlayer);
    }

    public String getOtherPlayerName(World world) {
        GameProfile profile;
        if (this.otherPlayer == null) {
            return null;
        }
        if (this.otherPlayer.getName() != null) {
            return this.otherPlayer.getName();
        }
        UUID id = this.getOtherPlayerId();
        EntityPlayer otherPlayer = WitcheryUtils.getPlayer(world, id);
        Object name2 = otherPlayer == null ? (world.func_73046_m() != null ? ((profile = world.func_73046_m().func_152358_ax().func_152652_a(id)) == null ? null : profile.getName()) : null) : otherPlayer.func_70005_c_();
        return name2;
    }

    public void setOtherPlayer(GameProfile profile) {
        this.otherPlayer = profile;
        this.markChanged();
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getOtherPlayerSkin() {
        ResourceLocation location = DefaultPlayerSkin.func_177335_a();
        if (this.otherPlayer != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map2 = minecraft.func_152342_ad().func_152788_a(this.otherPlayer);
            location = map2.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map2.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)this.getOtherPlayerId());
        }
        return location;
    }

    public void cachePlayerInventory() {
        this.inventoryCanBeRestored = true;
    }

    public void backupPlayerInventory() {
        NBTTagList nbtInventory = new NBTTagList();
        ((EntityPlayer)this.entity).field_71071_by.func_70442_a(nbtInventory);
        this.cachedInventory = nbtInventory;
    }

    public void restorePlayerInventoryFrom(PlayerExtendedData original) {
        if (original.cachedInventory != null && original.inventoryCanBeRestored) {
            ((EntityPlayer)this.entity).field_71071_by.func_70443_b(original.cachedInventory);
        }
    }

    public DimensionalLocation getRecallPosition() {
        return this.recallPosition;
    }

    public void setRecallPosition(DimensionalLocation recallPosition) {
        this.recallPosition = recallPosition;
    }

    public int getBottlingSkill() {
        return this.bottlingSkill;
    }

    public void increaseBottlingSkill() {
        this.bottlingSkill = Math.min(this.bottlingSkill + 1, 100);
        if (this.bottlingSkill % 30 == 0) {
            ((EntityPlayer)this.entity).func_145747_a((ITextComponent)new TextComponentTranslation("brew.witchery.brewing_skill_increase", new Object[0]));
        }
    }

    public int getThrowingSkill() {
        return this.bottlingSkill;
    }

    public int increaseThrowingSkill() {
        return this.getThrowingSkill();
    }

    public int getHumanBlood() {
        return this.humanBlood;
    }

    public void setHumanBlood(int blood) {
        if (this.humanBlood != blood) {
            this.humanBlood = MathHelper.func_76125_a((int)blood, (int)0, (int)500);
            if (!((EntityPlayer)this.entity).field_70170_p.field_72995_K) {
                WitcheryNetworkChannel.sendToAll(new PacketPartialExtendedPlayerSync(this, (EntityPlayer)this.entity));
            }
        }
    }

    public int takeHumanBlood(int quantity, EntityLivingBase attacker) {
        if (!((EntityPlayer)this.entity).func_70608_bn()) {
            quantity = (int)Math.ceil(0.66f * (float)quantity);
        }
        int remainder = Math.max(this.humanBlood - quantity, 0);
        int taken = this.humanBlood - remainder;
        this.setHumanBlood(remainder);
        if (this.humanBlood < (int)Math.ceil(250.0)) {
            ((EntityPlayer)this.entity).func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)attacker), 1.0f);
        } else if (!((EntityPlayer)this.entity).func_70608_bn()) {
            ((EntityPlayer)this.entity).func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)attacker), 0.1f);
        }
        return taken;
    }

    public void giveHumanBlood(int quantity) {
        if (this.humanBlood < 500) {
            this.setHumanBlood(this.humanBlood + quantity);
        }
    }

    public <T extends CreatureTrait> T getTransformation(CreatureTraitType<T> type2) {
        return (T)this.transformations.computeIfAbsent(type2, k -> (CreatureTrait)k.getCreate().invoke(this));
    }

    public boolean isTransformation(CreatureTraitType<?> type2) {
        return this.transformations.containsKey(type2) && ((CreatureTrait)this.getTransformation(type2)).getLevel() > 0;
    }

    public void updateWorship() {
        if (this.cachedWorship >= 0) {
            ((EntityPlayer)this.entity).func_70690_d(new PotionEffect(WitcheryPotionEffects.WORSHIP, 1200, this.cachedWorship, true, true));
            this.cachedWorship = -1;
        }
        this.processSync();
    }

    public void cacheIncurablePotionEffect(Collection<PotionEffect> activePotionEffects) {
        for (PotionEffect activeEffect : activePotionEffects) {
            WitcheryPotion potion;
            Potion potionID = activeEffect.func_188419_a();
            if (!(potionID instanceof WitcheryPotion) || activeEffect.func_76459_b() <= 5 || (potion = (WitcheryPotion)potionID).isCurable()) continue;
            this.incurablePotionEffectCache.put(activeEffect.func_188419_a(), activeEffect);
        }
    }

    public void clearCachedIncurablePotionEffect(Potion potion) {
        this.incurablePotionEffectCache.remove(potion);
    }

    public void restoreIncurablePotionEffects() {
        if (this.incurablePotionEffectCache.size() > 0) {
            Collection activeEffectList = ((EntityPlayer)this.entity).func_70651_bq();
            for (PotionEffect activeEffect : activeEffectList) {
                this.incurablePotionEffectCache.remove(activeEffect.func_188419_a());
            }
            for (PotionEffect restoredEffect : this.incurablePotionEffectCache.values()) {
                ((EntityPlayer)this.entity).func_70690_d(new PotionEffect(restoredEffect));
            }
            this.incurablePotionEffectCache.clear();
        }
    }

    public void addWorship(int level) {
        this.cachedWorship = level;
    }

    public void markChanged() {
        this.changed.set(true);
    }

    @Nullable
    public CreatureForm getCurrentForm() {
        return this.currentForm;
    }

    public CreatureForm getEffectiveForm() {
        return this.getCurrentForm() == null ? WitcheryAlternateForms.PLAYER : this.getCurrentForm();
    }

    public void setCurrentForm(CreatureForm type2) {
        if (this.currentForm != type2) {
            CreatureForm old = this.currentForm;
            this.currentForm = type2;
            if (!((EntityPlayer)this.entity).field_70170_p.field_72995_K) {
                WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle((EntityPlayer)this.entity));
                ShapeShift.INSTANCE.initCurrentShift((EntityPlayer)this.entity);
            }
            CreatureForm.PLAYER_TRANSFORM_EVENT.accept(this, new CreatureForm.PlayerTransformEventArgs(type2, old));
        }
    }

    public void scheduleSync() {
        this.getPlayerData = true;
    }

    public void processSync() {
        if (this.getPlayerData) {
            this.getPlayerData = false;
            for (EntityPlayer otherPlayer : ((EntityPlayer)this.entity).field_70170_p.field_73010_i) {
                if (otherPlayer == this.entity) continue;
                WitcheryNetworkChannel.sendTo(new PacketPlayerStyle(otherPlayer), (EntityPlayerMP)this.entity);
            }
        }
    }

    public void checkSleep(boolean start) {
        if (start) {
            if (this.isTransformation(WitcheryCreatureTraits.VAMPIRE) && ((EntityPlayer)this.entity).func_71026_bH() && ((EntityPlayer)this.entity).field_70170_p.func_72935_r()) {
                this.resetSleep = true;
                this.cachedSky = ((EntityPlayer)this.entity).field_70170_p.func_175657_ab();
                ((EntityPlayer)this.entity).field_70170_p.func_175692_b(4);
            }
        } else if (this.resetSleep) {
            this.resetSleep = false;
            ((EntityPlayer)this.entity).field_70170_p.func_175692_b(this.cachedSky);
        }
    }

    public boolean hasVampireBook() {
        for (ItemStack stack : ((EntityPlayer)this.entity).field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != WitcheryBookItems.IMMORTALS_OBSERVATIONS_BOOK) continue;
            return stack.func_77942_o() && stack.func_77978_p().func_74762_e("Level") < 9;
        }
        return false;
    }

    public BlockPos getMirrorWorldEntryPoint() {
        return this.mirrorWorldEntryPoint;
    }

    public void setMirrorWorldEntryPoint(BlockPos pos) {
        this.mirrorWorldEntryPoint = pos;
    }

    public boolean isMirrorWorldEntryPoint(BlockPos pos) {
        return this.mirrorWorldEntryPoint == null || this.mirrorWorldEntryPoint.equals((Object)pos);
    }

    public boolean hasMirrorEscapeCooldown(int slot) {
        if (slot == 1) {
            return ((EntityPlayer)this.entity).field_70170_p.func_82737_E() < this.mirrorWorldEscapeCooldown1 + 6000L;
        }
        return slot != 2 || ((EntityPlayer)this.entity).field_70170_p.func_82737_E() < this.mirrorWorldEscapeCooldown2 + 72000L;
    }

    public void escapedMirrorWorld(int slot) {
        if (slot == 1) {
            this.mirrorWorldEscapeCooldown1 = ((EntityPlayer)this.entity).field_70170_p.func_82737_E();
        } else if (slot == 2) {
            this.mirrorWorldEscapeCooldown2 = ((EntityPlayer)this.entity).field_70170_p.func_82737_E();
        }
    }

    public long getCooldownSecs(int i) {
        if (i == 1) {
            return (this.mirrorWorldEscapeCooldown1 + 6000L - ((EntityPlayer)this.entity).field_70170_p.func_82737_E()) / 20L;
        }
        if (i == 2) {
            return (this.mirrorWorldEscapeCooldown2 + 72000L - ((EntityPlayer)this.entity).field_70170_p.func_82737_E()) / 20L;
        }
        return 0L;
    }

    public boolean isFortuneTeller() {
        return this.isFortuneTeller;
    }

    public void setFortuneTeller(boolean fortuneTeller) {
        this.isFortuneTeller = fortuneTeller;
    }

    public void setVisitedNether(boolean visitedNether) {
        this.visitedNether = visitedNether;
    }

    public boolean hasVisitedNether() {
        return this.visitedNether;
    }

    public SpiritWorldData getSpiritData() {
        if (this.spiritData == null) {
            this.spiritData = new SpiritWorldData((EntityPlayer)this.entity);
        }
        return this.spiritData;
    }

    public TormentWorldData getTormentData() {
        if (this.tormentData == null) {
            this.tormentData = new TormentWorldData();
        }
        return this.tormentData;
    }

    public void setTormentData(TormentWorldData tormentData) {
        this.tormentData = tormentData;
    }
}

