/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.extensions;

import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.GlobalPos;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.extensions.WitcheryExtendedData;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketExtendedVillagerSync;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.ResizingUtils;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class VillagerExtendedData
extends WitcheryExtendedData<EntityVillager> {
    private GlobalPos home;
    private GlobalPos jobSite;
    private GlobalPos potentialJobSite;
    private Long lastWoken;
    private Long lastFailedTargetWalk;
    private BlockPos walkTarget;
    private int blood = 500;
    private boolean sleeping;
    private int sleepingTicks;

    @Override
    public void write(NBTTagCompound tag) {
        if (this.home != null) {
            tag.func_74782_a("Home", (NBTBase)this.home.save());
        }
        if (this.jobSite != null) {
            tag.func_74782_a("JobSite", (NBTBase)this.jobSite.save());
        }
        if (this.potentialJobSite != null) {
            tag.func_74782_a("PotentialJobSite", (NBTBase)this.potentialJobSite.save());
        }
        if (this.lastWoken != null) {
            tag.func_74772_a("LastWoken", this.lastWoken.longValue());
        }
        if (this.lastFailedTargetWalk != null) {
            tag.func_74772_a("LastFailedTargetWalk", this.lastFailedTargetWalk.longValue());
        }
        if (this.walkTarget != null) {
            tag.func_74782_a("WalkTarget", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.walkTarget));
        }
        tag.func_74768_a("Blood", this.blood);
    }

    @Override
    public void read(NBTTagCompound tag) {
        if (tag.func_74764_b("Home")) {
            this.home = GlobalPos.Companion.load(tag.func_74775_l("Home"));
        }
        if (tag.func_74764_b("JobSite")) {
            this.jobSite = GlobalPos.Companion.load(tag.func_74775_l("JobSite"));
        }
        if (tag.func_74764_b("PotentialJobSite")) {
            this.potentialJobSite = GlobalPos.Companion.load(tag.func_74775_l("PotentialJobSite"));
        }
        if (tag.func_74764_b("LastWoken")) {
            this.lastWoken = tag.func_74763_f("LastWoken");
        }
        if (tag.func_74764_b("LastFailedTargetWalk")) {
            this.lastFailedTargetWalk = tag.func_74763_f("LastFailedTargetWalk");
        }
        if (tag.func_74764_b("WalkTarget")) {
            this.walkTarget = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("WalkTarget"));
        }
        this.blood = MathHelper.func_76125_a((int)tag.func_74762_e("Blood"), (int)0, (int)500);
    }

    public int takeBlood(int quantity, EntityLivingBase player) {
        boolean isKnockedOut;
        PotionEffect potionEffect = ((EntityVillager)this.entity).func_70660_b(WitcheryPotionEffects.PARALYSED);
        boolean bl = isKnockedOut = this.isSleeping() || potionEffect != null && potionEffect.func_76458_c() >= 4;
        if (!isKnockedOut) {
            quantity = (int)Math.ceil(0.66f * (float)quantity);
        }
        int remainder = Math.max(this.blood - quantity, 0);
        int taken = this.blood - remainder;
        this.setBlood(remainder);
        if (player instanceof EntityPlayer) {
            if (this.blood < (int)Math.ceil(250.0)) {
                ((EntityVillager)this.entity).func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)player), 1.3f);
            } else if (!isKnockedOut) {
                ((EntityVillager)this.entity).func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)player), 0.1f);
            }
        }
        return taken;
    }

    public void giveBlood(int quantity) {
        if (this.blood < 500) {
            this.setBlood(this.blood + quantity);
        }
    }

    public int getBlood() {
        return this.blood;
    }

    public void setBlood(int blood) {
        if (this.blood != blood) {
            this.blood = Math.max(Math.min(blood, 500), 0);
            this.sync();
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public void setSleeping(boolean sleeping) {
        if (this.sleeping != sleeping) {
            this.sleeping = sleeping;
            if (this.sleeping) {
                ResizingUtils.setSize(this.entity, 0.2f, 0.2f);
                if (this.home != null) {
                    ((EntityVillager)this.entity).func_70107_b((double)this.home.getPos().func_177958_n() + 0.5, (double)this.home.getPos().func_177956_o() + 0.5625, (double)this.home.getPos().func_177952_p() + 0.5);
                }
                this.setBedOccupied(true);
            } else {
                ResizingUtils.setSize(this.entity, 0.6f, 1.95f);
                if (this.sleepingTicks > 1200) {
                    this.giveBlood(this.sleepingTicks / 24);
                }
                this.setBedOccupied(false);
                this.lastWoken = ((EntityVillager)this.entity).field_70170_p.func_82737_E();
            }
            this.sleepingTicks = 0;
            this.sync();
        }
    }

    private void setBedOccupied(boolean value) {
        IBlockState state;
        GlobalPos home = this.getHome();
        if (home != null && WitcheryUtils.isOf(state = ((EntityVillager)this.entity).field_70170_p.func_180495_p(home.getPos()), Blocks.field_150324_C)) {
            BlockPos pos = home.getPos().func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
            ((EntityVillager)this.entity).field_70170_p.func_180501_a(home.getPos(), state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(value)), 4);
            ((EntityVillager)this.entity).field_70170_p.func_180501_a(pos, ((EntityVillager)this.entity).field_70170_p.func_180495_p(pos).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(value)), 4);
        }
    }

    public void incrementSleepingTicks() {
        ++this.sleepingTicks;
    }

    public void sync() {
        if (!((EntityVillager)this.entity).field_70170_p.field_72995_K && ((EntityVillager)this.entity).func_110143_aJ() > 0.0f && !((EntityVillager)this.entity).field_70128_L) {
            WitcheryNetworkChannel.sendToAll(new PacketExtendedVillagerSync(this));
        }
    }

    public void setHome(GlobalPos home) {
        this.home = home;
    }

    @Nullable
    public GlobalPos getHome() {
        return this.home;
    }

    @Nullable
    public Long getLastWoken() {
        return this.lastWoken;
    }

    public Long getLastFailedTargetWalk() {
        return this.lastFailedTargetWalk;
    }

    public void setLastFailedTargetWalk(Long lastFailedTargetWalk) {
        this.lastFailedTargetWalk = lastFailedTargetWalk;
    }

    public BlockPos getWalkTarget() {
        return this.walkTarget;
    }

    public void setWalkTarget(BlockPos walkTarget) {
        this.walkTarget = walkTarget;
    }
}

