/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.infusion.creature.CreaturePower;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.resources.CreaturePowerManager;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/infusion/InfernalInfusion;", "Lnet/msrandom/witchery/infusion/Infusion;", "()V", "isValidForSpells", "", "onFalling", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "event", "Lnet/minecraftforge/event/entity/living/LivingFallEvent;", "onHurt", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "onLeftClickEntity", "otherEntity", "Lnet/minecraft/entity/Entity;", "onPlayerStoppedUsing", "itemstack", "Lnet/minecraft/item/ItemStack;", "countdown", "", "trySacrificeCreature", "creature", "Lnet/minecraft/entity/EntityLiving;", "Companion", "WitcheryResurrected"})
public final class InfernalInfusion
extends Infusion {
    private static final int MAX_CHARGES = 20;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isValidForSpells() {
        return true;
    }

    @Override
    public void onLeftClickEntity(@NotNull World world, @NotNull EntityPlayer player, @NotNull Entity otherEntity) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(otherEntity, "otherEntity");
        if (!world.field_72995_K && otherEntity instanceof EntityLivingBase) {
            if (player.func_70093_af()) {
                if (PotionEnslaved.canCreatureBeEnslaved((EntityLivingBase)otherEntity)) {
                    EntityLiving entityLiving = (EntityLiving)otherEntity;
                    if (PotionEnslaved.isMobEnslavedBy(entityLiving, player)) {
                        if (this.consumeCharges(world, player, 1)) {
                            this.trySacrificeCreature(world, player, entityLiving);
                        }
                    } else if (this.consumeCharges(world, player, 5)) {
                        PotionEnslaved.setEnslaverForMob(entityLiving, player);
                        EntityUtil.dropAttackTarget((EntityLiving)otherEntity);
                        entityLiving.field_70170_p.func_184133_a(null, entityLiving.func_180425_c(), SoundEvents.field_187945_hs, player.func_184176_by(), 0.5f, 0.4f / (entityLiving.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 0.0, 20, 1.0, 2.0);
                    }
                } else {
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    WitcheryUtils.playSoundAt(player, soundEvent, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                int r = 50;
                if (this.consumeCharges(world, player, 1)) {
                    int minionCount = 0;
                    AxisAlignedBB bounds = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - 15.0, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + 15.0, player.field_70161_v + (double)r);
                    for (EntityLiving nearbyLivingEntity : world.func_72872_a(EntityLiving.class, bounds)) {
                        if (!PotionEnslaved.isMobEnslavedBy(nearbyLivingEntity, player)) continue;
                        ++minionCount;
                        EntityLiving entityLiving = nearbyLivingEntity;
                        Intrinsics.checkExpressionValueIsNotNull(entityLiving, "nearbyLivingEntity");
                        entityLiving.func_70624_b((EntityLivingBase)otherEntity);
                        if (!(nearbyLivingEntity instanceof EntityCreature)) continue;
                        ((EntityCreature)nearbyLivingEntity).func_70604_c((EntityLivingBase)otherEntity);
                        if (!(nearbyLivingEntity instanceof EntityZombie) && !(nearbyLivingEntity instanceof EntityCreeper)) continue;
                        nearbyLivingEntity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)nearbyLivingEntity, ((EntityLivingBase)otherEntity).getClass(), false));
                    }
                    if (minionCount > 0) {
                        world.func_184133_a(null, ((EntityLivingBase)otherEntity).func_180425_c(), SoundEvents.field_189109_ed, SoundCategory.PLAYERS, 0.5f, 0.4f / (otherEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryUtils.addNewParticles(world, EnumParticleTypes.CRIT, otherEntity.field_70165_t, otherEntity.field_70163_u, otherEntity.field_70161_v, 0.0, 20, 0.5, 2.0);
                    }
                }
            }
        }
    }

    private final void trySacrificeCreature(World world, EntityPlayer player, EntityLiving creature2) {
        CreaturePower power = CreaturePowerManager.INSTANCE.getPower((Entity)creature2);
        if (power != null) {
            CreaturePowerData creaturePower;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            CreaturePowerData creaturePowerData = creaturePower = playerEx.creaturePower;
            playerEx.creaturePower = Intrinsics.areEqual(creaturePowerData != null ? creaturePowerData.getPower() : null, power) ? new CreaturePowerData(creaturePower.getEntityType(), RangesKt.coerceAtMost(creaturePower.getCharges() + power.getSacrificeCharges(), 20)) : new CreaturePowerData(creature2.getClass(), power.getSacrificeCharges());
            Infusion.syncPlayer(world, player);
            creature2.func_70097_a(DamageSource.func_76354_b((Entity)((Entity)player), null), creature2.func_110143_aJ() + 1.0f);
        } else {
            this.playFailSound(world, player);
        }
    }

    @Override
    public void onHurt(@NotNull EntityPlayer player, @NotNull LivingHurtEvent event) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Object object = WitcheryUtils.getExtension((EntityPlayer)player).creaturePower;
        if (object != null && (object = ((CreaturePowerData)object).getPower()) != null && (object = ((CreaturePower)object).getAbilities()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreatureAbility it = (CreatureAbility)element$iv;
                boolean bl = false;
                it.onDamage(player.field_70170_p, player, event);
            }
        }
    }

    @Override
    public void onFalling(@NotNull World world, @NotNull EntityPlayer player, @NotNull LivingFallEvent event) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Object object = WitcheryUtils.getExtension((EntityPlayer)player).creaturePower;
        if (object != null && (object = ((CreaturePowerData)object).getPower()) != null && (object = ((CreaturePower)object).getAbilities()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreatureAbility it = (CreatureAbility)element$iv;
                boolean bl = false;
                it.onFalling(world, player, event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPlayerStoppedUsing(@NotNull ItemStack itemstack, @NotNull World world, @NotNull EntityPlayer player, int countdown) {
        Intrinsics.checkParameterIsNotNull(itemstack, "itemstack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        if (!world.field_72995_K) {
            int elapsedTicks = this.getMaxItemUseDuration() - countdown;
            RayTraceResult hit = OtherwhereInfusion.doCustomRayTrace(world, player, true, 15.0);
            if (player.func_70093_af()) {
                if (hit != null) {
                    if (hit.field_72313_a == RayTraceResult.Type.ENTITY) {
                        this.playFailSound(world, player);
                    } else if (hit.field_72313_a == RayTraceResult.Type.BLOCK && hit.field_178784_b == EnumFacing.UP) {
                        int minionCount = 0;
                        int r = 50;
                        AxisAlignedBB bounds = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - (double)15, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + (double)15, player.field_70161_v + (double)r);
                        for (EntityLiving creature2 : world.func_72872_a(EntityLiving.class, bounds)) {
                            EntityLiving entityLiving = creature2;
                            if (!(entityLiving instanceof EntityCreature)) {
                                entityLiving = null;
                            }
                            EntityCreature creature22 = (EntityCreature)entityLiving;
                            if (!PotionEnslaved.isMobEnslavedBy(creature2, player)) continue;
                            ++minionCount;
                            EntityLiving entityLiving2 = creature2;
                            Intrinsics.checkExpressionValueIsNotNull(entityLiving2, "creature");
                            entityLiving2.func_70624_b((EntityLivingBase)null);
                            creature2.func_70604_c((EntityLivingBase)null);
                            if (!(creature2 instanceof EntitySpider)) {
                                PathNavigate pathNavigate = creature2.func_70661_as();
                                BlockPos blockPos = hit.func_178782_a();
                                Intrinsics.checkExpressionValueIsNotNull(blockPos, "hit.blockPos");
                                double d = blockPos.func_177958_n();
                                BlockPos blockPos2 = hit.func_178782_a();
                                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "hit.blockPos");
                                double d2 = (double)blockPos2.func_177956_o() + 1.0;
                                BlockPos blockPos3 = hit.func_178782_a();
                                Intrinsics.checkExpressionValueIsNotNull(blockPos3, "hit.blockPos");
                                if (pathNavigate.func_75492_a(d, d2, (double)blockPos3.func_177952_p(), 1.0)) continue;
                            }
                            if (creature22 == null) continue;
                            creature22.func_70661_as().func_179680_a(hit.func_178782_a());
                        }
                        if (minionCount > 0) {
                            BlockPos blockPos = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos, "hit.blockPos");
                            double d = blockPos.func_177958_n();
                            BlockPos blockPos4 = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "hit.blockPos");
                            double d3 = (double)blockPos4.func_177956_o() + 1.0;
                            BlockPos blockPos5 = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "hit.blockPos");
                            world.func_184148_a(null, d, d3, (double)blockPos5.func_177952_p(), SoundEvents.field_187638_cR, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            BlockPos blockPos6 = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos6, "hit.blockPos");
                            double d4 = blockPos6.func_177958_n();
                            BlockPos blockPos7 = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos7, "hit.blockPos");
                            double d5 = (double)blockPos7.func_177956_o() + 1.0;
                            BlockPos blockPos8 = hit.func_178782_a();
                            Intrinsics.checkExpressionValueIsNotNull(blockPos8, "hit.blockPos");
                            WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_INSTANT, d4, d5, blockPos8.func_177952_p(), 0.0, 20, 0.5, 2.0);
                        }
                    }
                } else {
                    this.playFailSound(world, player);
                }
            } else {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                CreaturePowerData creaturePower = playerEx.creaturePower;
                if (creaturePower != null) {
                    CreaturePower power = creaturePower.getPower();
                    if (power != null) {
                        Iterable $this$sumBy$iv = power.getAbilities();
                        boolean $i$f$sumBy = false;
                        int sum$iv = 0;
                        for (Object element$iv : $this$sumBy$iv) {
                            void it;
                            CreatureAbility creatureAbility = (CreatureAbility)element$iv;
                            int n = sum$iv;
                            boolean bl = false;
                            int n2 = it.activateCost(world, player, elapsedTicks, hit);
                            sum$iv = n + n2;
                        }
                        int cost = sum$iv + 1;
                        if (creaturePower.getCharges() - cost >= 0 && this.consumeCharges(world, player, 1)) {
                            for (CreatureAbility ability : power.getAbilities()) {
                                ability.onActivate(world, player, elapsedTicks, hit);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                playerEx.creaturePower = new CreaturePowerData(creaturePower.getEntityType(), creaturePower.getCharges() - cost);
                                Infusion.syncPlayer(world, player);
                            }
                        } else {
                            this.playFailSound(world, player);
                        }
                    } else {
                        this.playFailSound(world, player);
                    }
                } else {
                    this.playFailSound(world, player);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/infusion/InfernalInfusion$Companion;", "", "()V", "MAX_CHARGES", "", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

