/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.entity.EntityIllusion;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPlayerSync;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;
import net.msrandom.witchery.util.WitcheryUtils;

public class Infusion {
    public static final WitcheryIdentityRegistry<ResourceLocation, Infusion> REGISTRY = new WitcheryIdentityRegistry(4);
    public static final Infusion DEFUSED = new Infusion();
    public static final String INFUSION_NEXTSYNC = "WitcheryResyncLook";

    public static void dropEntityItemWithRandomChoice(EntityLivingBase entity, ItemStack par1ItemStack, boolean par2) {
        if (par1ItemStack.func_190926_b() || entity == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u - (double)0.3f + (double)entity.func_70047_e(), entity.field_70161_v, par1ItemStack);
        entityitem.func_174867_a(40);
        if (par2) {
            float f2 = entity.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f3 = entity.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f3) * f2;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f3) * f2;
            entityitem.field_70181_x = 0.2f;
        } else {
            float f = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f2 = entity.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w += Math.cos(f2) * (double)(f *= entity.field_70170_p.field_73012_v.nextFloat());
            entityitem.field_70181_x += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f2) * (double)f;
        }
        entity.field_70170_p.func_72838_d((Entity)entityitem);
    }

    @Deprecated
    public static <T extends EntityCreature> T spawnCreature(World world, Class<? extends T> creatureType, EntityLivingBase victim, int minRange, int maxRange, EnumParticleTypes effect, SoundEvent effectSound) {
        return Infusion.spawnCreature(world, creatureType, victim.func_180425_c(), victim, minRange, maxRange, effect, effectSound);
    }

    @Deprecated
    public static void spawnCreature(World world, Class<? extends EntityCreature> creatureType, BlockPos pos, EntityPlayer victim, int minRange, int maxRange) {
        Infusion.spawnCreature(world, creatureType, pos, (EntityLivingBase)victim, minRange, maxRange, null, null);
    }

    @Deprecated
    public static <T extends EntityCreature> T spawnCreature(World world, Class<? extends T> creatureType, BlockPos pos, EntityLivingBase victim, int minRange, int maxRange, EnumParticleTypes effect, @Nullable SoundEvent effectSound) {
        if (!world.field_72995_K) {
            int hy;
            int az;
            int activeRadius = maxRange - minRange;
            int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += minRange * 2;
            }
            if ((az = world.field_73012_v.nextInt(activeRadius * 2 + 1)) > activeRadius) {
                az += minRange * 2;
            }
            BlockPos p = pos.func_177982_a(ax - maxRange, 0, az - maxRange);
            while (!world.func_175623_d(p) && p.func_177956_o() < pos.func_177956_o() + 8) {
                p = p.func_177984_a();
            }
            while (world.func_175623_d(p) && p.func_177956_o() > 0) {
                p = p.func_177977_b();
            }
            for (hy = 0; world.func_175623_d(p.func_177981_b(hy + 1)) && hy < 6; ++hy) {
            }
            if (hy >= 2) {
                try {
                    Constructor<T> ctor = creatureType.getConstructor(World.class);
                    EntityCreature creature2 = (EntityCreature)ctor.newInstance(world);
                    if (victim instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)victim;
                        if (creature2 instanceof EntityIllusion) {
                            ((EntityIllusion)creature2).setVictimId(player.func_110124_au());
                        } else if (creature2 instanceof EntityNightmare) {
                            ((EntityNightmare)creature2).setVictimId(player.func_110124_au());
                            creature2.func_70624_b(victim);
                        }
                    }
                    double x = (double)p.func_177958_n() + 0.5;
                    double y = (double)p.func_177956_o() + 1.05;
                    double z = (double)p.func_177952_p() + 0.5;
                    creature2.func_70012_b(x, y, z, 0.0f, 0.0f);
                    world.func_72838_d((Entity)creature2);
                    if (effect != null) {
                        if (effectSound != null) {
                            world.func_184148_a(null, x, y, z, effectSound, creature2.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(x, y, z, 1.0f, creature2.field_70131_O, effect), world, x, y, z, 16.0);
                    }
                    return (T)creature2;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isOnCooldown(World world, ItemStack stack) {
        NBTTagCompound nbtTag;
        if (!world.field_72995_K && (nbtTag = stack.func_77978_p()) != null && nbtTag.func_74764_b("WitcheryCooldown")) {
            long currentTime = MinecraftServer.func_130071_aq();
            return currentTime < nbtTag.func_74763_f("WitcheryCooldown");
        }
        return false;
    }

    public static void setCooldown(World world, ItemStack stack, int milliseconds) {
        if (!world.field_72995_K) {
            NBTTagCompound nbtTag;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtTag = stack.func_77978_p()) != null) {
                long currentTime = MinecraftServer.func_130071_aq();
                nbtTag.func_74772_a("WitcheryCooldown", currentTime + (long)milliseconds);
            }
        }
    }

    @Deprecated
    public static void setCurrentEnergy(EntityPlayer player, int currentEnergy) {
        if (!player.field_70170_p.field_72995_K) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy, playerEx.infusionPower.getMaxPower());
            Infusion.syncPlayer(player.field_70170_p, player);
        }
    }

    public static void syncPlayer(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            WitcheryNetworkChannel.sendTo(new PacketPlayerSync(player), (EntityPlayerMP)player);
        }
    }

    @Deprecated
    public static int getCurrentEnergy(EntityPlayer player) {
        return WitcheryUtils.getExtension((EntityPlayer)player).infusionPower.getCurrentPower();
    }

    @Deprecated
    public static int getMaxEnergy(EntityPlayer player) {
        return WitcheryUtils.getExtension((EntityPlayer)player).infusionPower.getMaxPower();
    }

    public static void reducePowerLevels(EntityLivingBase entity, float reduction) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int maxEnergy = Infusion.getMaxEnergy(player);
            int currentEnergy = Infusion.getCurrentEnergy(player);
            if (maxEnergy > 0 && currentEnergy > 0) {
                Infusion.setCurrentEnergy(player, Math.min(currentEnergy - Math.min((int)((float)maxEnergy * reduction), 1), 0));
            }
        }
        IntegrationManager.reduceMagicPower(entity, reduction);
    }

    public static boolean acquireEnergy(World world, EntityPlayer player, int cost, boolean showMessages) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        if (playerEx.infusionPower.getInfusionType() == DEFUSED) {
            if (showMessages) {
                player.func_145747_a(new TextComponentTranslation("infusion.witchery.no_infusion", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
            return false;
        }
        if (player.field_71075_bZ.field_75098_d || playerEx.infusionPower.getCurrentPower() >= cost) {
            if (!player.field_71075_bZ.field_75098_d) {
                Infusion.setCurrentEnergy(player, playerEx.infusionPower.getCurrentPower() - cost);
            }
            return true;
        }
        if (showMessages) {
            player.func_145747_a(new TextComponentTranslation("infusion.witchery.insufficient_infusion_power", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
        return false;
    }

    public void onHurt(EntityPlayer player, LivingHurtEvent event) {
    }

    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
    }

    public boolean isValidForSpells() {
        return false;
    }

    protected boolean consumeCharges(World world, EntityPlayer player, int cost) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int charges = Infusion.getCurrentEnergy(player);
        if (charges - cost < 0) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            Infusion.clearInfusion(player);
            return false;
        }
        Infusion.setCurrentEnergy(player, charges - cost);
        return true;
    }

    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public int getMaxItemUseDuration() {
        return 400;
    }

    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public void playSound(World world, EntityPlayer player, SoundEvent sound) {
        WitcheryUtils.playSoundAt(player, sound, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    public void playFailSound(World world, EntityPlayer player) {
        this.playSound(world, player, SoundEvents.field_187688_dI);
    }

    public static void clearInfusion(EntityPlayer player) {
        DEFUSED.infuse(player, 0);
    }

    public void infuse(EntityPlayer player, int charges) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        playerEx.infusionPower = new InfusionPower(this, charges, charges);
        playerEx.creaturePower = null;
        if (!player.field_70170_p.field_72995_K) {
            Infusion.syncPlayer(player.field_70170_p, player);
        }
    }

    @Deprecated
    public static Infusion getInfusion(EntityPlayer $this$getInfusion) {
        return WitcheryUtils.getExtension((EntityPlayer)$this$getInfusion).infusionPower.getInfusionType();
    }

    public String getTranslationKey() {
        ResourceLocation key = (ResourceLocation)REGISTRY.getKey(this);
        return key == null ? "infusion.witchery.unknown" : "infusion." + key.func_110624_b() + "." + key.func_110623_a();
    }
}

