/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockBarrier;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.EntityUtil;

public class LightInfusion
extends Infusion {
    protected static final int BARRIER_TICKS_TO_LIVE_ = 200;
    private static final int BARRIER_RADIUS = 2;
    private static final int BARRIER_HEIGHT = 3;
    private static final boolean BARRIER_BLOCKS_PLAYERS = true;
    private static final int AGGRO_DROP_RADIUS = 20;

    public static void placeBarrierShield(World world, EntityPlayer player, RayTraceResult hitMOP) {
        double f1 = Math.cos(Math.toRadians(-player.field_70177_z) - Math.PI);
        double f2 = Math.sin(Math.toRadians(-player.field_70177_z) - Math.PI);
        Vec3d loc = new Vec3d(f2, 0.0, f1);
        Material material = world.func_180495_p(hitMOP.func_178782_a()).func_185904_a();
        int yPlus = 1;
        if (!material.func_76220_a()) {
            yPlus = 0;
        }
        LightInfusion.drawBarrierBlockColumn(world, player, hitMOP.func_178782_a().func_177958_n(), hitMOP.func_178782_a().func_177956_o() + yPlus, hitMOP.func_178782_a().func_177952_p());
        loc = loc.func_178785_b((float)Math.toRadians(90.0));
        int newX = MathHelper.func_76128_c((double)((double)hitMOP.func_178782_a().func_177958_n() + 0.5 + loc.field_72450_a * 1.0));
        int newZ = MathHelper.func_76128_c((double)((double)hitMOP.func_178782_a().func_177952_p() + 0.5 + loc.field_72449_c * 1.0));
        LightInfusion.drawBarrierBlockColumn(world, player, newX, hitMOP.func_178782_a().func_177956_o() + yPlus, newZ);
        loc = loc.func_178785_b((float)Math.toRadians(180.0));
        newX = MathHelper.func_76128_c((double)((double)hitMOP.func_178782_a().func_177958_n() + 0.5 + loc.field_72450_a * 1.0));
        newZ = MathHelper.func_76128_c((double)((double)hitMOP.func_178782_a().func_177952_p() + 0.5 + loc.field_72449_c * 1.0));
        LightInfusion.drawBarrierBlockColumn(world, player, newX, hitMOP.func_178782_a().func_177956_o() + yPlus, newZ);
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            BlockBarrier.setBlock(world, pos, 200, true, null);
            return true;
        }
        return false;
    }

    private static void drawBarrierBlockColumn(World world, EntityPlayer player, int posX, int posY, int posZ) {
        for (int offsetPosY = posY; offsetPosY < posY + 3; ++offsetPosY) {
            BlockPos pos = new BlockPos(posX, offsetPosY, posZ);
            IBlockState state = world.func_180495_p(pos);
            Material material = state.func_185904_a();
            Block blockID = state.func_177230_c();
            if (!material.func_76222_j() && blockID != WitcheryBlocks.BARRIER) continue;
            BlockBarrier.setBlock(world, pos, 200, true, player);
        }
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.field_72995_K) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            int posX = (int)otherEntity.field_70165_t;
            int UPSHIFT = 4;
            int posY = (int)otherEntity.field_70163_u + UPSHIFT;
            int posZ = (int)otherEntity.field_70161_v;
            BlockPos pos = new BlockPos(posX, posY, posZ);
            if (world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(new BlockPos(posX, posY + 2, posZ)) && world.func_175623_d(pos.func_177974_f()) && world.func_175623_d(pos.func_177974_f().func_177984_a()) && world.func_175623_d(new BlockPos(posX + 1, posY + 2, posZ)) && world.func_175623_d(pos.func_177968_d()) && world.func_175623_d(pos.func_177968_d().func_177984_a()) && world.func_175623_d(new BlockPos(posX, posY + 2, posZ + 1)) && world.func_175623_d(pos.func_177976_e()) && world.func_175623_d(pos.func_177976_e().func_177984_a()) && world.func_175623_d(new BlockPos(posX - 1, posY + 2, posZ)) && world.func_175623_d(pos.func_177978_c()) && world.func_175623_d(pos.func_177978_c().func_177984_a()) && world.func_175623_d(new BlockPos(posX, posY + 2, posZ - 1)) && this.consumeCharges(world, player, 5)) {
                this.drawFilledCircle(world, posX, posZ, posY - 1, 2, null);
                for (int y = posY; y < posY + 3; ++y) {
                    this.drawCircle(world, posX, posZ, y, null);
                }
                this.drawFilledCircle(world, posX, posZ, posY + 3, 2, null);
                otherLivingEntity.func_70634_a((double)posX, (double)posY, (double)posZ);
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        if (world.field_72995_K) {
            if (!player.func_184218_aH()) {
                int var7;
                int var6;
                int var5 = MathHelper.func_76128_c((double)player.field_70165_t);
                if (world.func_180495_p(new BlockPos(var5, var6 = MathHelper.func_76128_c((double)(player.field_70163_u - 2.0)), var7 = MathHelper.func_76128_c((double)player.field_70161_v))).func_177230_c() != Blocks.field_150432_aD) {
                    if (player.field_70122_E) {
                        if (!player.func_70090_H()) {
                            player.field_70159_w *= 1.6500000476837158;
                            player.field_70179_y *= 1.6500000476837158;
                        } else {
                            player.field_70159_w *= (double)1.1f;
                            player.field_70179_y *= (double)1.1f;
                        }
                    }
                } else {
                    player.field_70159_w *= (double)1.1f;
                    player.field_70179_y *= (double)1.1f;
                }
            }
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (elapsedTicks % 30 == 0 && elapsedTicks > 19) {
            this.bendLightAroundPlayer(world, player, this.consumeCharges(world, player, 1));
        }
    }

    protected void bendLightAroundPlayer(World world, EntityPlayer player, boolean active) {
        if (active) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 30, 0, true, true));
            int r = 20;
            AxisAlignedBB bounds = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + 2.0, player.field_70161_v + (double)r);
            for (EntityLiving entity : world.func_72872_a(EntityLiving.class, bounds)) {
                if (entity.func_70638_az() != player || !(entity.func_70011_f(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= (double)r)) continue;
                EntityUtil.dropAttackTarget(entity);
            }
        } else {
            player.func_184589_d(MobEffects.field_76441_p);
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        RayTraceResult hitMOP;
        if (world.field_72995_K) {
            return;
        }
        this.bendLightAroundPlayer(world, player, false);
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (elapsedTicks < 20 && player.func_70093_af() && (hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, 16.0)) != null) {
            switch (hitMOP.field_72313_a) {
                case ENTITY: {
                    if (!(hitMOP.field_72308_g instanceof EntityLivingBase)) break;
                    EntityLivingBase otherLivingEntity = (EntityLivingBase)hitMOP.field_72308_g;
                    if (!this.consumeCharges(world, player, 3)) break;
                    int posX = (int)otherLivingEntity.field_70165_t;
                    int posY = (int)otherLivingEntity.field_70163_u;
                    int posZ = (int)otherLivingEntity.field_70161_v;
                    this.drawFilledCircle(world, posX, posZ, posY - 1, 1, player);
                    for (int y = posY; y < posY + 3; ++y) {
                        this.drawCircle(world, posX, posZ, y, player);
                    }
                    this.drawFilledCircle(world, posX, posZ, posY + 3, 2, player);
                    break;
                }
                case BLOCK: {
                    int i;
                    if (hitMOP.field_178784_b == EnumFacing.UP && this.consumeCharges(world, player, 3)) {
                        LightInfusion.placeBarrierShield(world, player, hitMOP);
                        break;
                    }
                    if (hitMOP.field_178784_b == EnumFacing.UP || !this.consumeCharges(world, player, 3)) break;
                    int sproutExtent = 16;
                    boolean isInitialBlockSolid = world.func_180495_p(hitMOP.func_178782_a()).func_185904_a().func_76220_a();
                    int n = i = hitMOP.field_178784_b != EnumFacing.UP || isInitialBlockSolid ? 1 : 0;
                    while (i < sproutExtent && LightInfusion.setBlockIfNotSolid(world, hitMOP.func_178782_a().func_177967_a(hitMOP.field_178784_b, i))) {
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void drawCircle(World world, int x0, int z0, int y, EntityPlayer player) {
        int x = 2;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, x + x0, z + z0, y, player);
            this.drawPixel(world, z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, z + z0, y, player);
            this.drawPixel(world, -z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, -z + z0, y, player);
            this.drawPixel(world, -z + x0, -x + z0, y, player);
            this.drawPixel(world, x + x0, -z + z0, y, player);
            this.drawPixel(world, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawFilledCircle(World world, int x0, int z0, int y, int radius, EntityPlayer player) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, -x + x0, x + x0, z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, x + z0, y, player);
            this.drawLine(world, -x + x0, x + x0, -z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, int x1, int x2, int z, int y, EntityPlayer player) {
        for (int x3 = x1; x3 <= x2; ++x3) {
            this.drawPixel(world, x3, z, y, player);
        }
    }

    protected void drawPixel(World world, int x, int z, int y, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (!material.func_76220_a() || state.func_177230_c() == WitcheryBlocks.BARRIER || material == Material.field_151579_a) {
            BlockBarrier.setBlock(world, pos, 200, true, player);
        }
    }
}

