/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.util.DimensionalLocation;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class OtherwhereInfusion
extends Infusion {
    private static final int SAVE_RECALL_POINT_THRESHOLD = 60;

    public static void teleportEntity(EntityPlayer entityPlayer, RayTraceResult hitMOP) {
        EntityPlayerMP player;
        if (hitMOP != null && entityPlayer instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed(player = (EntityPlayerMP)entityPlayer)) {
            switch (hitMOP.field_72313_a) {
                case ENTITY: {
                    player.func_70634_a(hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                    break;
                }
                case BLOCK: {
                    double hitx = hitMOP.field_72307_f.field_72450_a;
                    double hity = hitMOP.field_72307_f.field_72448_b;
                    double hitz = hitMOP.field_72307_f.field_72449_c;
                    switch (hitMOP.field_178784_b) {
                        case DOWN: {
                            hity -= 2.0;
                        }
                        case EAST: {
                            hitz -= 0.5;
                            break;
                        }
                        case WEST: {
                            hitz += 0.5;
                            break;
                        }
                        case NORTH: {
                            hitx -= 0.5;
                            break;
                        }
                        case SOUTH: {
                            hitx += 0.5;
                        }
                    }
                    player.field_70143_R = 0.0f;
                    player.func_70634_a(hitx, hity, hitz);
                    break;
                }
            }
        }
    }

    public static RayTraceResult doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedBlock = OtherwhereInfusion.raytraceBlocks(world, player, collisionFlag, reachDistance);
        RayTraceResult pickedEntity = OtherwhereInfusion.raytraceEntities(world, player, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3d playerPosition = player.func_174824_e(1.0f);
        double dBlock = pickedBlock.field_72307_f.func_72438_d(playerPosition);
        double dEntity = pickedEntity.field_72307_f.func_72438_d(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static RayTraceResult raytraceEntities(World world, EntityPlayer player, double reachDistance) {
        Entity hit = null;
        Vec3d rotation = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d end = start.func_72441_c(rotation.field_72450_a * reachDistance, rotation.field_72448_b * reachDistance, rotation.field_72449_c * reachDistance);
        double closestEntity = reachDistance;
        for (Entity entity : world.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(1.1 * reachDistance))) {
            double hitDistance;
            RayTraceResult interception;
            if (!entity.func_70067_L() || (interception = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y()).func_72327_a(start, end)) == null || !((hitDistance = start.func_72438_d(interception.field_72307_f)) < closestEntity)) continue;
            hit = entity;
            closestEntity = hitDistance;
        }
        return hit == null ? null : new RayTraceResult(hit);
    }

    private static boolean isConnectionClosed(EntityPlayerMP player) {
        return player.field_71135_a.field_147371_a.func_150724_d();
    }

    public static RayTraceResult raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3d playerPosition = player.func_174824_e(1.0f);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        return world.func_147447_a(playerPosition, playerViewOffset, collisionFlag, !collisionFlag, false);
    }

    private static RayTraceResult raytraceUpBlocks(World world, EntityLivingBase player, double reachDistance) {
        Vec3d playerPosition = player.func_174824_e(1.0f);
        Vec3d playerUp = new Vec3d(0.0, 1.0, 0.0);
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerUp.field_72450_a * reachDistance, playerPosition.field_72448_b + playerUp.field_72448_b * reachDistance, playerPosition.field_72449_c + playerUp.field_72449_c * reachDistance);
        return world.func_147447_a(playerPosition, playerViewOffset, true, false, false);
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.field_72995_K) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            if (player.func_70093_af()) {
                DimensionalLocation recallLocation = this.recallLocation(player);
                if (recallLocation != null && recallLocation.dimension != WitcheryDimensions.SPIRIT_WORLD.getType() && recallLocation.dimension != WitcheryDimensions.TORMENT.getType() && recallLocation.dimension != WitcheryDimensions.MIRROR.getType() && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && !WitcheryDimensions.TORMENT.isCurrentDimension(world) && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                    if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player)) {
                        player.field_70143_R = 0.0f;
                        TeleportationUtil.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension.func_186068_a(), (Entity)player, true);
                        otherLivingEntity.field_70143_R = 0.0f;
                        if (PotionEnderInhibition.canTeleport((Entity)otherLivingEntity, 2)) {
                            TeleportationUtil.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension.func_186068_a(), (Entity)otherLivingEntity, true);
                        }
                    }
                } else {
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                }
            } else if (PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                double hikeModified2;
                double HIKE_HEIGHT = 8.0;
                RayTraceResult hitMOP = OtherwhereInfusion.raytraceUpBlocks(world, (EntityLivingBase)player, HIKE_HEIGHT);
                double hikeModified = hitMOP == null ? HIKE_HEIGHT : Math.min((double)hitMOP.func_178782_a().func_177956_o() - otherLivingEntity.field_70163_u - 2.0, HIKE_HEIGHT);
                RayTraceResult hitMOP2 = OtherwhereInfusion.raytraceUpBlocks(world, otherLivingEntity, HIKE_HEIGHT);
                double d = hikeModified2 = hitMOP2 == null ? HIKE_HEIGHT : Math.min((double)hitMOP2.func_178782_a().func_177956_o() - otherLivingEntity.field_70163_u - 2.0, HIKE_HEIGHT);
                if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player) && hikeModified > 0.0 && hikeModified2 > 0.0) {
                    TeleportationUtil.teleportToLocation(player.field_70165_t, player.field_70163_u + hikeModified, player.field_70161_v, player.field_71093_bK, (Entity)player, true);
                    if (PotionEnderInhibition.canTeleport((Entity)otherLivingEntity, 2)) {
                        TeleportationUtil.teleportToLocation(otherLivingEntity.field_70165_t, otherLivingEntity.field_70163_u + hikeModified2, otherLivingEntity.field_70161_v, otherLivingEntity.field_71093_bK, (Entity)otherLivingEntity, true);
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (player.func_70093_af() && elapsedTicks == 60) {
            if (!world.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation(this.getTranslationKey() + ".recall_prompt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, player.func_184176_by(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        } else if (!player.func_70093_af() && elapsedTicks > 0 && elapsedTicks % 20 == 0) {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            RayTraceResult hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, player.func_184176_by(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (!world.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation(this.getTranslationKey() + ".teleport_prompt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
                }
            } else {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, player.func_184176_by(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (world.field_72995_K) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (player.func_70093_af() && elapsedTicks >= 60) {
            this.storeLocation(player);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        } else if (player.func_70093_af()) {
            DimensionalLocation recallLocation = this.recallLocation(player);
            if (recallLocation != null && recallLocation.dimension != WitcheryDimensions.SPIRIT_WORLD.getType() && recallLocation.dimension != WitcheryDimensions.TORMENT.getType() && recallLocation.dimension != WitcheryDimensions.MIRROR.getType() && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && !WitcheryDimensions.TORMENT.isCurrentDimension(world) && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player)) {
                    player.field_70143_R = 0.0f;
                    TeleportationUtil.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension.func_186068_a(), (Entity)player, true);
                    Infusion.setCooldown(world, itemstack, 1500);
                }
            } else {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        } else {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            RayTraceResult hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 1)) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, player.func_184176_by(), 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(world, EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 0.5, 2.0);
                OtherwhereInfusion.teleportEntity(player, hitMOP);
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, player.func_184176_by(), 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(world, EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 0.5, 2.0);
                Infusion.setCooldown(world, itemstack, 1500);
            } else {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (hitMOP == null) {
                    player.func_145747_a(new TextComponentTranslation(this.getTranslationKey() + ".teleport_too_far", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
    }

    private void storeLocation(EntityPlayer player) {
        WitcheryUtils.getExtension(player).setRecallPosition(new DimensionalLocation((Entity)player));
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a(new TextComponentTranslation(this.getTranslationKey() + ".recall_set", new Object[]{WitcheryUtils.getFormattedName(player.field_70170_p.field_73011_w.func_186058_p()), MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    private DimensionalLocation recallLocation(EntityPlayer player) {
        return WitcheryUtils.getExtension(player).getRecallPosition();
    }
}

