/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.util.EarthItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class OverworldInfusion
extends Infusion {
    @Override
    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
        int blockZ;
        int blockY;
        int blockX;
        BlockPos pos;
        Block block;
        if (event.getDistance() > 3.0f && ((block = world.func_180495_p(pos = new BlockPos(blockX = MathHelper.func_76128_c((double)player.field_70165_t), blockY = MathHelper.func_76128_c((double)player.field_70163_u) - 1, blockZ = MathHelper.func_76128_c((double)player.field_70161_v))).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_150391_bh || block == Blocks.field_150351_n || block == Blocks.field_150354_m || block == Blocks.field_150433_aE)) {
            if (player.func_70093_af()) {
                if (this.consumeCharges(world, player, 10)) {
                    event.setDistance(0.0f);
                    int EXPLOSION_STRENGTH = 3;
                    world.func_72876_a((Entity)player, player.field_70165_t, (double)blockY + 0.5, player.field_70161_v, (float)EXPLOSION_STRENGTH, true);
                }
            } else if (this.consumeCharges(world, player, 5)) {
                event.setDistance(0.0f);
                world.func_175698_g(pos);
                ItemStack itemstack = new ItemStack(block, 1);
                EntityItem blockEntity = new EntityItem(world, (double)blockX, (double)blockY, (double)blockZ, itemstack);
                world.func_72838_d((Entity)blockEntity);
            }
        }
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.field_72995_K) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            boolean isWearingMetalArmour = false;
            for (int i = 0; i < 6; ++i) {
                ItemStack heldStack = otherLivingEntity.func_184582_a(EntityEquipmentSlot.values()[i]);
                if (!EarthItems.instance().isMatch(heldStack)) continue;
                isWearingMetalArmour = true;
                break;
            }
            if (isWearingMetalArmour) {
                if (player.func_70093_af()) {
                    if (this.consumeCharges(world, player, 4)) {
                        Vec3d look = player.func_70040_Z();
                        double motionX = look.field_72450_a * 0.8 * 3.0;
                        double motionY = 1.5;
                        double motionZ = look.field_72449_c * 0.8 * 3.0;
                        if (otherLivingEntity instanceof EntityPlayerMP) {
                            EntityPlayerMP targetPlayer = (EntityPlayerMP)otherLivingEntity;
                            WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                        } else {
                            otherLivingEntity.field_70159_w = motionX;
                            otherLivingEntity.field_70181_x = motionY;
                            otherLivingEntity.field_70179_y = motionZ;
                        }
                    }
                } else if (this.consumeCharges(world, player, 2)) {
                    Vec3d look = player.func_70040_Z();
                    double motionX = look.field_72450_a * 0.8 * 3.0;
                    double motionY = 0.30000000000000004;
                    double motionZ = look.field_72449_c * 0.8 * 3.0;
                    if (otherLivingEntity instanceof EntityPlayerMP) {
                        EntityPlayerMP targetPlayer = (EntityPlayerMP)otherLivingEntity;
                        WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                    } else {
                        otherLivingEntity.field_70159_w = motionX;
                        otherLivingEntity.field_70181_x = motionY;
                        otherLivingEntity.field_70179_y = motionZ;
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        if (!world.field_72995_K) {
            int elapsedTicks = this.getMaxItemUseDuration() - countdown;
            int seconds = elapsedTicks / 20;
            if (player.func_70093_af()) {
                if (seconds >= 2 && elapsedTicks % 4 == 0 && this.consumeCharges(world, player, 1)) {
                    int AreaOfEffect = 6;
                    List entities = world.func_175647_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - 6.0, player.field_70163_u - 6.0, player.field_70161_v - 6.0, player.field_70165_t + (double)AreaOfEffect, player.field_70163_u + (double)AreaOfEffect, player.field_70161_v + (double)AreaOfEffect), entity -> EarthItems.instance().isMatch(entity.func_92059_d()));
                    for (EntityItem entity2 : entities) {
                        double d0 = 8.0;
                        double motionX = 0.0;
                        double motionY = 0.0;
                        double motionZ = 0.0;
                        double d2 = (player.field_70165_t - entity2.field_70165_t) / d0;
                        double d3 = (player.field_70163_u + (double)player.func_70047_e() - entity2.field_70163_u) / d0;
                        double d4 = (player.field_70161_v - entity2.field_70161_v) / d0;
                        boolean oldClip = entity2.field_70145_X;
                        entity2.field_70145_X = true;
                        entity2.func_70091_d(MoverType.SELF, motionX += d2 / Math.max(Math.abs(d2), 0.0), motionY += d3 / Math.max(Math.abs(d2), 0.0), motionZ += d4 / Math.max(Math.abs(d2), 0.0));
                        entity2.field_70145_X = oldClip;
                    }
                    int AreaOfEffect2 = 6;
                    for (int x = (int)player.field_70165_t - AreaOfEffect2; x <= (int)player.field_70165_t + AreaOfEffect2; ++x) {
                        for (int y = (int)player.field_70163_u - 3; y <= (int)player.field_70163_u + 3; ++y) {
                            for (int z = (int)player.field_70161_v - AreaOfEffect2; z <= (int)player.field_70161_v + AreaOfEffect2; ++z) {
                                Item ingot;
                                BlockPos pos = new BlockPos(x, y, z);
                                Block id = world.func_180495_p(pos).func_177230_c();
                                if (id == Blocks.field_150350_a || Item.func_150898_a((Block)id) == Items.field_190931_a || (ingot = EarthItems.instance().oreToIngot(id)) == null || !this.consumeCharges(world, player, 2)) continue;
                                world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 3);
                                world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(ingot)));
                            }
                        }
                    }
                }
            } else if (seconds >= 2 && elapsedTicks % 20 == 0) {
                this.playSound(world, player, SoundEvents.field_187604_bf);
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        int seconds;
        if (world.field_72995_K) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        RayTraceResult hit = OtherwhereInfusion.doCustomRayTrace(world, player, true, 4.0);
        if (hit != null) {
            switch (hit.field_72313_a) {
                case ENTITY: {
                    if (player.func_70093_af() || !(hit.field_72308_g instanceof EntityLiving) || !this.consumeCharges(world, player, 2)) break;
                    EntityLiving entity = (EntityLiving)hit.field_72308_g;
                    ItemStack mainItem = entity.func_184614_ca();
                    ItemStack offItem = entity.func_184592_cb();
                    if (EarthItems.instance().isMatch(mainItem)) {
                        entity.func_70099_a(mainItem, 2.0f);
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                    if (EarthItems.instance().isMatch(offItem)) {
                        entity.func_70099_a(offItem, 2.0f);
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                    return;
                }
                case BLOCK: {
                    Item ingot;
                    Block blockID2;
                    int DEPTH = 3;
                    if (!player.func_70093_af() && hit.field_178784_b == EnumFacing.UP && world.func_180495_p(hit.func_178782_a().func_177979_c(10)).func_185904_a().func_76220_a() && this.consumeCharges(world, player, 2)) {
                        for (int h = 0; h < 6; ++h) {
                            BlockPos originY = hit.func_178782_a().func_177979_c(h + 3);
                            IBlockState state = world.func_180495_p(hit.func_178782_a());
                            if (!WitcheryUtils.canBreak(state)) continue;
                            world.func_175698_g(hit.func_178782_a());
                            if (WitcheryUtils.canBreak(world.func_180495_p(originY))) {
                                world.func_180501_a(originY, state, 3);
                            }
                            AxisAlignedBB bounds = new AxisAlignedBB((double)hit.func_178782_a().func_177958_n(), (double)hit.func_178782_a().func_177956_o(), (double)hit.func_178782_a().func_177952_p(), (double)(hit.func_178782_a().func_177958_n() + 1), (double)(hit.func_178782_a().func_177956_o() + 2), (double)(hit.func_178782_a().func_177952_p() + 1));
                            for (Entity entity2 : world.func_72872_a(Entity.class, bounds)) {
                                if (entity2 instanceof EntityLivingBase) {
                                    entity2.func_70634_a(entity2.field_70165_t, entity2.field_70163_u + (double)DEPTH, entity2.field_70161_v);
                                    continue;
                                }
                                entity2.func_70107_b(entity2.field_70165_t, entity2.field_70163_u + 3.0, entity2.field_70161_v);
                            }
                        }
                    } else if (!player.func_70093_af() && hit.field_178784_b != EnumFacing.DOWN && hit.field_178784_b != EnumFacing.UP) {
                        if (this.isThrowableRock(world, hit.func_178782_a(), hit.field_178784_b) && this.consumeCharges(world, player, 3)) {
                            world.func_175698_g(hit.func_178782_a());
                            world.func_184133_a(null, hit.func_178782_a(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)hit.func_178782_a().func_177958_n(), (double)hit.func_178782_a().func_177956_o(), (double)hit.func_178782_a().func_177952_p(), 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), world, hit.func_178782_a(), 8.0);
                            EntityWitchProjectile rockEntity = new EntityWitchProjectile(world, (EntityLivingBase)player, new ItemStack(WitcheryIngredientItems.ROCK));
                            rockEntity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                            rockEntity.func_70107_b((double)hit.func_178782_a().func_177958_n() + 0.5, (double)hit.func_178782_a().func_177956_o() + 0.5, (double)hit.func_178782_a().func_177952_p() + 0.5);
                            world.func_72838_d((Entity)rockEntity);
                        }
                    } else if (player.func_70093_af() && this.consumeCharges(world, player, 2) && (blockID2 = world.func_180495_p(hit.func_178782_a()).func_177230_c()) != Blocks.field_150350_a && Item.func_150898_a((Block)blockID2) != Items.field_190931_a && (ingot = EarthItems.instance().oreToIngot(blockID2)) != null) {
                        world.func_180501_a(hit.func_178782_a(), Blocks.field_150348_b.func_176223_P(), 3);
                        world.func_72838_d((Entity)new EntityItem(world, (double)hit.func_178782_a().func_177958_n(), (double)hit.func_178782_a().func_177956_o(), (double)hit.func_178782_a().func_177952_p(), new ItemStack(ingot, 2, 0)));
                    }
                    return;
                }
            }
        }
        if ((seconds = elapsedTicks / 20) >= 2 && !player.func_70093_af() && this.consumeCharges(world, player, 6 * seconds)) {
            Shockwave.SHOCKWAVES.add(new Shockwave(player, 2 * seconds));
        } else {
            this.playFailSound(world, player);
        }
    }

    private boolean isThrowableRock(World world, BlockPos pos, EnumFacing sideHit) {
        HashSet blocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150322_A, Blocks.field_150333_U, Blocks.field_150336_V, Blocks.field_150341_Y, Blocks.field_150349_c, Blocks.field_150446_ar, Blocks.field_150435_aG, Blocks.field_150425_aM, Blocks.field_150417_aV, Blocks.field_150389_bf, Blocks.field_150390_bg, Blocks.field_150391_bh, Blocks.field_150385_bj, Blocks.field_150387_bl, Blocks.field_150372_bz, Blocks.field_150405_ch, Blocks.field_150402_ci, Blocks.field_150424_aL});
        if (!blocks.contains(world.func_180495_p(pos).func_177230_c())) {
            return false;
        }
        return !world.func_180495_p(pos.func_177972_a(sideHit.func_176734_d())).func_185904_a().func_76220_a();
    }

    public static class Shockwave {
        public static final List<Shockwave> SHOCKWAVES = new ArrayList<Shockwave>();
        final BlockPos center;
        final EntityPlayer creator;
        final int maxRadius;
        final int MIN_RADIUS = 2;
        int stage = 0;

        public Shockwave(EntityPlayer creator, int maxRadius) {
            this.center = new BlockPos((int)creator.field_70165_t, (int)creator.field_70163_u - 1, (int)creator.field_70161_v);
            this.creator = creator;
            this.maxRadius = maxRadius + 2;
        }

        public boolean process(World world) {
            if (this.stage++ == 0) {
                this.drawCircle(world, this.center, this.stage + 2, 1);
            } else {
                this.drawCircle(world, this.center.func_177981_b(2), this.stage + 2, -1);
                this.drawCircle(world, this.center.func_177984_a(), this.stage + 2 - 1, -1);
            }
            if (this.stage < this.maxRadius) {
                this.drawCircle(world, this.center, this.stage + 2 + 1, 2);
            } else {
                this.drawCircle(world, this.center.func_177984_a(), this.stage + 2, -1);
            }
            int r = this.stage + 2;
            AxisAlignedBB bounds = new AxisAlignedBB(this.center.func_177982_a(-r, 1, -r), this.center.func_177982_a(r, 4, r));
            for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, bounds)) {
                double dist = entity.func_70011_f((double)this.center.func_177958_n(), (double)this.center.func_177956_o(), (double)this.center.func_177952_p());
                if (!(dist <= (double)(r + 1)) || !(dist >= (double)r)) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.creator), 8.0f);
                RiteEffectProtectionCircleRepulsive.push((Entity)entity, this.center);
            }
            return this.stage == this.maxRadius;
        }

        protected void drawCircle(World world, BlockPos pos, int radius, int height2) {
            int x = radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawPixel(world, pos.func_177982_a(x, 0, z), height2);
                this.drawPixel(world, pos.func_177982_a(z, 0, x), height2);
                this.drawPixel(world, pos.func_177982_a(-x, 0, z), height2);
                this.drawPixel(world, pos.func_177982_a(-z, 0, x), height2);
                this.drawPixel(world, pos.func_177982_a(-x, 0, -z), height2);
                this.drawPixel(world, pos.func_177982_a(-z, 0, -x), height2);
                this.drawPixel(world, pos.func_177982_a(x, 0, -z), height2);
                this.drawPixel(world, pos.func_177982_a(z, 0, -x), height2);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }

        protected void drawPixel(World world, BlockPos pos, int height2) {
            if (height2 > 0) {
                if (world.func_175623_d(pos.func_177979_c(1)) || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
                    return;
                }
                for (int i = 0; i < 2; ++i) {
                    BlockPos p = pos.func_177979_c(i);
                    IBlockState blockID = world.func_180495_p(p);
                    if (WitcheryUtils.canBreak(blockID)) {
                        world.func_175698_g(p);
                    }
                    if (!WitcheryUtils.canBreak(world.func_180495_p(p.func_177981_b(height2)))) continue;
                    world.func_180501_a(p.func_177981_b(height2), blockID, 3);
                }
            } else {
                if (world.func_175623_d(pos) || world.func_180495_p(pos.func_177981_b(height2 - 1)).func_185904_a().func_76220_a()) {
                    return;
                }
                for (int i = 1; i >= 0; --i) {
                    BlockPos p = pos.func_177979_c(i);
                    IBlockState blockID = world.func_180495_p(p);
                    if (WitcheryUtils.canBreak(blockID)) {
                        world.func_175698_g(p);
                    }
                    if (!WitcheryUtils.canBreak(world.func_180495_p(p.func_177981_b(height2)))) continue;
                    world.func_180501_a(p.func_177981_b(height2), blockID, 3);
                }
            }
        }
    }
}

