/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.util.WitcheryUtils;

public class DrownPreventionCreatureAbility
extends CreatureAbility {
    private final int cost;
    private final int duration;
    private final int amplifier;
    private final int air;

    public DrownPreventionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int cost, int duration, int amplifier, int air) {
        super(serializer);
        this.cost = cost;
        this.duration = duration;
        this.amplifier = amplifier;
        this.air = air;
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        if (!world.field_72995_K && event.getSource() == DamageSource.field_76369_e) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            int currentEnergy = playerEx.infusionPower.getCurrentPower();
            if (currentEnergy >= this.cost) {
                playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy - this.cost, playerEx.infusionPower.getMaxPower());
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, this.duration, this.amplifier));
                player.func_70050_g(this.air);
                event.setCanceled(true);
            }
        }
        super.onDamage(world, player, event);
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<DrownPreventionCreatureAbility> {
        @Override
        public DrownPreventionCreatureAbility read(JsonObject json) {
            JsonElement amplifier = json.get("amplifier");
            return new DrownPreventionCreatureAbility(this, json.get("cost").getAsInt(), json.get("duration").getAsInt(), amplifier == null ? 0 : amplifier.getAsInt(), json.get("air").getAsInt());
        }

        @Override
        public DrownPreventionCreatureAbility read(PacketBuffer buffer) {
            return new DrownPreventionCreatureAbility(this, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
        }

        @Override
        public void write(PacketBuffer buffer, DrownPreventionCreatureAbility ability) {
            buffer.func_150787_b(ability.cost);
            buffer.func_150787_b(ability.duration);
            buffer.func_150787_b(ability.amplifier);
            buffer.func_150787_b(ability.air);
        }
    }
}

