/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public class ExplosionCreatureAbility
extends CreatureAbility {
    private final int powerUp;
    private final float radius;

    public ExplosionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int powerUp, float radius) {
        super(serializer);
        this.powerUp = powerUp;
        this.radius = radius;
    }

    @Override
    public int activateCost(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        return elapsedTicks >= this.powerUp ? 1 : 0;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        if (!world.field_72995_K) {
            double posX = player.field_70165_t;
            double posY = player.field_70163_u;
            double posZ = player.field_70161_v;
            world.func_72876_a((Entity)player, posX, posY, posZ, this.radius * (float)(elapsedTicks >= this.powerUp ? 2 : 1), world.func_82736_K().func_82766_b("mobGriefing"));
        }
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<ExplosionCreatureAbility> {
        @Override
        public ExplosionCreatureAbility read(JsonObject json) {
            JsonElement powerUp = json.get("power_up");
            JsonElement radius = json.get("radius");
            return new ExplosionCreatureAbility(this, powerUp == null ? 60 : powerUp.getAsInt(), radius == null ? 3.0f : radius.getAsFloat());
        }

        @Override
        public ExplosionCreatureAbility read(PacketBuffer buffer) {
            return new ExplosionCreatureAbility(this, buffer.func_150792_a(), buffer.readFloat());
        }

        @Override
        public void write(PacketBuffer buffer, ExplosionCreatureAbility ability) {
            buffer.func_150787_b(ability.powerUp);
            buffer.writeFloat(ability.radius);
        }
    }
}

