/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.util.WitcheryUtils;

public class FireProtectionCreatureAbility
extends CreatureAbility {
    private final int cost;
    private final int duration;
    private final int amplifier;

    public FireProtectionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int cost, int duration, int amplifier) {
        super(serializer);
        this.cost = cost;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        if (event.getSource().func_76347_k() && event.isCancelable()) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            int currentEnergy = playerEx.infusionPower.getCurrentPower();
            if (currentEnergy >= this.cost && !player.func_70644_a(MobEffects.field_76426_n)) {
                playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy - this.cost, playerEx.infusionPower.getMaxPower());
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, this.duration, this.amplifier));
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<FireProtectionCreatureAbility> {
        @Override
        public FireProtectionCreatureAbility read(JsonObject json) {
            JsonElement cost = json.get("cost");
            JsonElement duration = json.get("duration");
            JsonElement amplifier = json.get("amplifier");
            return new FireProtectionCreatureAbility(this, cost == null ? 3 : cost.getAsInt(), duration == null ? 200 : duration.getAsInt(), amplifier == null ? 0 : amplifier.getAsInt());
        }

        @Override
        public FireProtectionCreatureAbility read(PacketBuffer buffer) {
            return new FireProtectionCreatureAbility(this, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
        }

        @Override
        public void write(PacketBuffer buffer, FireProtectionCreatureAbility ability) {
            buffer.func_150787_b(ability.cost);
            buffer.func_150787_b(ability.duration);
            buffer.func_150787_b(ability.amplifier);
        }
    }
}

