/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public abstract class FireballsCreatureAbility
extends CreatureAbility {
    private final int count;

    public FireballsCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int count) {
        super(serializer);
        this.count = count;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        world.func_175718_b(1008, player.func_180425_c(), 0);
        for (int i = 0; i < this.count; ++i) {
            double motionX = -Math.sin(Math.toRadians(player.field_70177_z)) * Math.cos(Math.toRadians(player.field_70125_A));
            double motionY = -Math.sin(Math.toRadians(player.field_70125_A));
            double motionZ = Math.cos(Math.toRadians(player.field_70177_z)) * Math.cos(Math.toRadians(player.field_70125_A));
            EntityFireball fireball = this.makeFireball(world, player, motionX, motionY, motionZ);
            fireball.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, fireball.field_70177_z, fireball.field_70125_A);
            fireball.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            double speed = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            fireball.field_70232_b = motionX / speed * 0.1;
            fireball.field_70233_c = motionY / speed * 0.1;
            fireball.field_70230_d = motionZ / speed * 0.1;
            Vec3d vec3 = player.func_70676_i(1.0f);
            fireball.field_70165_t = player.field_70165_t + vec3.field_72450_a;
            fireball.field_70163_u = player.field_70163_u + (double)(player.field_70131_O / 2.0f) + 0.5;
            fireball.field_70161_v = player.field_70161_v + vec3.field_72449_c;
            world.func_72838_d((Entity)fireball);
        }
    }

    protected abstract EntityFireball makeFireball(World var1, EntityPlayer var2, double var3, double var5, double var7);

    public static abstract class Serializer
    implements CreatureAbility.AbilitySerializer<FireballsCreatureAbility> {
        @Override
        public FireballsCreatureAbility read(JsonObject json) {
            JsonElement count = json.get("count");
            return new FireballsCreatureAbility(this, count == null ? 1 : count.getAsInt()){

                @Override
                protected EntityFireball makeFireball(World world, EntityPlayer player, double motionX, double motionY, double motionZ) {
                    return this.makeFireball(world, player, motionX, motionY, motionZ);
                }
            };
        }

        @Override
        public FireballsCreatureAbility read(PacketBuffer buffer) {
            return new FireballsCreatureAbility(this, buffer.func_150792_a()){

                @Override
                protected EntityFireball makeFireball(World world, EntityPlayer player, double motionX, double motionY, double motionZ) {
                    return this.makeFireball(world, player, motionX, motionY, motionZ);
                }
            };
        }

        @Override
        public void write(PacketBuffer buffer, FireballsCreatureAbility ability) {
            buffer.func_150787_b(ability.count);
        }

        protected abstract EntityFireball makeFireball(World var1, EntityPlayer var2, double var3, double var5, double var7);
    }
}

