/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.spirit;

import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityDeath;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.item.ItemDeathsClothes;
import net.msrandom.witchery.item.ItemDeathsHand;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.TeleportationUtil;

public class InfusedSpiritDeathEffect
extends InfusedSpiritEffect {
    @Override
    public void bindFetish(World world, BlockPos position, ItemStack stack, Object2IntMap<Class<? extends EntityCreature>> requirement, ListMultimap<Class<? extends EntityCreature>, EntityCreature> ghosts) {
        EntityPlayer deathPlayer = this.findDeathPlayer(world);
        if (deathPlayer != null) {
            TeleportationUtil.teleportToLocation(position, world.field_73011_w.getDimension(), (Entity)deathPlayer, true);
            deathPlayer.func_184185_a(SoundEvents.field_187855_gD, 0.5f, 0.4f / (deathPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(deathPlayer.field_70165_t, deathPlayer.field_70163_u, deathPlayer.field_70161_v, 0.5f, 1.5f, EnumParticleTypes.SPELL_INSTANT), (Entity)deathPlayer);
        } else {
            EntityDeath death = new EntityDeath(world);
            death.func_70012_b((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.1, (double)position.func_177952_p() + 0.5, 0.0f, 0.0f);
            death.func_110163_bv();
            world.func_72838_d((Entity)death);
            death.func_184185_a(SoundEvents.field_187855_gD, 0.5f, 0.4f / (death.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(death.field_70165_t, death.field_70163_u, death.field_70161_v, 0.5f, 1.5f, EnumParticleTypes.SPELL_INSTANT), (Entity)death);
        }
    }

    @Override
    public boolean bindToItem(ItemStack stack) {
        return false;
    }

    private EntityPlayer findDeathPlayer(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            if (!ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player) || !(player.func_184614_ca().func_77973_b() instanceof ItemDeathsHand) && !(player.func_184592_cb().func_77973_b() instanceof ItemDeathsHand)) continue;
            return player;
        }
        return null;
    }
}

