/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockFire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockBrazier;
import net.msrandom.witchery.block.BlockWickerBundle;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/infusion/symbol/IncendioSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/ProjectileSymbolEffect;", "()V", "onCollision", "", "world", "Lnet/minecraft/world/World;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "spell", "Lnet/msrandom/witchery/entity/EntitySpellEffect;", "WitcheryResurrected"})
public final class IncendioSymbolEffect
extends ProjectileSymbolEffect {
    @Override
    public void onCollision(@NotNull World world, @NotNull EntityLivingBase caster, @NotNull RayTraceResult hit, @NotNull EntitySpellEffect spell) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(caster, "caster");
        Intrinsics.checkParameterIsNotNull(hit, "hit");
        Intrinsics.checkParameterIsNotNull((Object)spell, "spell");
        double radius = (double)(spell.getEffectLevel() - 1) * 3.0;
        int level = spell.getEffectLevel();
        if (radius == 0.0) {
            if (hit.field_72313_a == RayTraceResult.Type.ENTITY) {
                hit.field_72308_g.func_70015_d(1);
                hit.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("onFire", (Entity)spell, (Entity)caster).func_76361_j(), 0.1f);
            } else if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState hitBlock;
                IBlockState iBlockState = hitBlock = BlockUtil.getBlock(world, hit);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "hitBlock");
                if (iBlockState.func_177230_c() instanceof BlockWickerBundle) {
                    if (BlockWickerBundle.tryIgniteMan(world, hit.func_178782_a(), caster.field_70177_z)) {
                        return;
                    }
                } else if (hitBlock.func_177230_c() == WitcheryBlocks.BRAZIER) {
                    BlockBrazier.tryIgnite(world, hit.func_178782_a());
                    return;
                }
                BlockPos pos = hit.func_178782_a().func_177972_a(hit.field_178784_b);
                if (!world.func_180495_p(hit.func_178782_a()).isSideSolid((IBlockAccess)world, hit.func_178782_a(), EnumFacing.UP) && hit.field_178784_b == EnumFacing.UP) {
                    pos = pos.func_177977_b();
                }
                BlockFire blockFire = Blocks.field_150480_ab;
                Intrinsics.checkExpressionValueIsNotNull(blockFire, "Blocks.FIRE");
                world.func_175656_a(pos, blockFire.func_176223_P());
            }
        } else {
            SymbolEffect.Companion.applyEntityEffect(world, caster, hit, spell, radius, new BiConsumer<EntityLivingBase, EntityLivingBase>(level){
                final /* synthetic */ int $level;

                public final void accept(@NotNull EntityLivingBase actor, @NotNull EntityLivingBase target) {
                    Intrinsics.checkParameterIsNotNull(actor, "actor");
                    Intrinsics.checkParameterIsNotNull(target, "target");
                    if (target != actor) {
                        target.func_70015_d(this.$level);
                    }
                }
                {
                    this.$level = n;
                }
            });
            if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                EnumFacing side = hit.field_178784_b;
                SymbolEffect.Companion.applyBlockEffect(world, caster, hit, level, new BiConsumer<BlockPos, IBlockState>(side, world){
                    final /* synthetic */ EnumFacing $side;
                    final /* synthetic */ World $world;

                    public final void accept(@NotNull BlockPos pos, @NotNull IBlockState $noName_1) {
                        Intrinsics.checkParameterIsNotNull(pos, "pos");
                        Intrinsics.checkParameterIsNotNull($noName_1, "<anonymous parameter 1>");
                        if (this.$side == EnumFacing.UP && this.$world.func_175623_d(pos.func_177984_a())) {
                            BlockPos blockPos = pos.func_177984_a();
                            BlockFire blockFire = Blocks.field_150480_ab;
                            Intrinsics.checkExpressionValueIsNotNull(blockFire, "Blocks.FIRE");
                            this.$world.func_175656_a(blockPos, blockFire.func_176223_P());
                        }
                    }
                    {
                        this.$side = enumFacing;
                        this.$world = world;
                    }
                });
            }
        }
    }

    public IncendioSymbolEffect() {
        super(0, false, false, false, 0, false, 63, null);
        this.setColor(16724023);
        this.setSize(2.0f);
    }
}

