/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.init.data.brewing;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.brewing.BrewNameBuilder;
import net.msrandom.witchery.brewing.BrewNamePart;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.ModifierYield;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.EffectBrewAction;
import net.msrandom.witchery.brewing.action.effect.AirHikeBrewEffect;
import net.msrandom.witchery.brewing.action.effect.AnimalAttractionBrewEffect;
import net.msrandom.witchery.brewing.action.effect.BatBurstBrewEffect;
import net.msrandom.witchery.brewing.action.effect.BlastBrewEffect;
import net.msrandom.witchery.brewing.action.effect.BodegaBrewEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionBiomeChange;
import net.msrandom.witchery.brewing.action.effect.BrewActionBlight;
import net.msrandom.witchery.brewing.action.effect.BrewActionFelling;
import net.msrandom.witchery.brewing.action.effect.BrewActionLilify;
import net.msrandom.witchery.brewing.action.effect.BrewActionPlanting;
import net.msrandom.witchery.brewing.action.effect.BrewActionRaiseLand;
import net.msrandom.witchery.brewing.action.effect.BrewActionRaising;
import net.msrandom.witchery.brewing.action.effect.BrewActionSprouting;
import net.msrandom.witchery.brewing.action.effect.BrewActionSummonLeonard;
import net.msrandom.witchery.brewing.action.effect.BrewActionTranspose;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.ColdBrewEffect;
import net.msrandom.witchery.brewing.action.effect.ColorfulBrewEffect;
import net.msrandom.witchery.brewing.action.effect.CombustionBrewEffect;
import net.msrandom.witchery.brewing.action.effect.CureBuffsBrewEffect;
import net.msrandom.witchery.brewing.action.effect.CureDebuffsBrewEffect;
import net.msrandom.witchery.brewing.action.effect.CurseBrewEffect;
import net.msrandom.witchery.brewing.action.effect.DemonbaneBrewEffect;
import net.msrandom.witchery.brewing.action.effect.DissipateBrewEffect;
import net.msrandom.witchery.brewing.action.effect.DrainMangicBrewEffect;
import net.msrandom.witchery.brewing.action.effect.EndlessWaterBrewEffect;
import net.msrandom.witchery.brewing.action.effect.ErosionBrewEffect;
import net.msrandom.witchery.brewing.action.effect.ExtinguishBrewEffect;
import net.msrandom.witchery.brewing.action.effect.FertilizationBrewEffect;
import net.msrandom.witchery.brewing.action.effect.FlamesBrewEffect;
import net.msrandom.witchery.brewing.action.effect.FlowersBrewEffect;
import net.msrandom.witchery.brewing.action.effect.FrogsTongueBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowAcaciaBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowAlderBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowBirchBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowDarkOakBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowHawthornBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowJungleBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowOakBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowRowanBrewEffect;
import net.msrandom.witchery.brewing.action.effect.GrowSpruceBrewEffect;
import net.msrandom.witchery.brewing.action.effect.HarmWerewolvesBrewEffect;
import net.msrandom.witchery.brewing.action.effect.HarvestingBrewEffect;
import net.msrandom.witchery.brewing.action.effect.IceWorldBrewEffect;
import net.msrandom.witchery.brewing.action.effect.IcyShellBrewEffect;
import net.msrandom.witchery.brewing.action.effect.InfernoBrewEffect;
import net.msrandom.witchery.brewing.action.effect.InsectbaneBrewEffect;
import net.msrandom.witchery.brewing.action.effect.KnockbackBrewEffect;
import net.msrandom.witchery.brewing.action.effect.LavaHoldBrewEffect;
import net.msrandom.witchery.brewing.action.effect.LevellingBrewEffect;
import net.msrandom.witchery.brewing.action.effect.PoisonToadBrewEffect;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.brewing.action.effect.PotionLongevityBrewEffect;
import net.msrandom.witchery.brewing.action.effect.PruningBrewEffect;
import net.msrandom.witchery.brewing.action.effect.PulverisationBrewEffect;
import net.msrandom.witchery.brewing.action.effect.RevealingBrewEffect;
import net.msrandom.witchery.brewing.action.effect.SimpleEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.SnowTrailBrewEffect;
import net.msrandom.witchery.brewing.action.effect.SpreadDebuffsBrewEffect;
import net.msrandom.witchery.brewing.action.effect.StealBuffsBrewEffect;
import net.msrandom.witchery.brewing.action.effect.ThornsBrewEffect;
import net.msrandom.witchery.brewing.action.effect.TidalHoldBrewEffect;
import net.msrandom.witchery.brewing.action.effect.TillingBrewEffect;
import net.msrandom.witchery.brewing.action.effect.TransposeOreBrewEffect;
import net.msrandom.witchery.brewing.action.effect.UndeadbaneBrewEffect;
import net.msrandom.witchery.brewing.action.effect.VinesBrewEffect;
import net.msrandom.witchery.brewing.action.effect.WastingBrewEffect;
import net.msrandom.witchery.brewing.action.effect.WeakenVampiresBrewEffect;
import net.msrandom.witchery.brewing.action.effect.WebsBrewEffect;
import net.msrandom.witchery.registry.WitcheryNamespacedInitializer;

public class WitcheryBrewEffects
extends WitcheryNamespacedInitializer<BrewEffectSerializer<?>> {
    public static final WitcheryBrewEffects INSTANCE = new WitcheryBrewEffects();
    public static final PotionBrewEffect.Serializer POTION = INSTANCE.add0("potion", PotionBrewEffect.Serializer.INSTANCE);
    public static final CurseBrewEffect.Serializer CURSE = INSTANCE.add0("curse", CurseBrewEffect.Serializer.INSTANCE);
    public static final ColorfulBrewEffect.Serializer COLORFUL = INSTANCE.add0("tinting", ColorfulBrewEffect.Serializer.INSTANCE);
    public static final SimpleEffectSerializer<SnowTrailBrewEffect> SNOW_TRAIL = INSTANCE.add0("snow_trail", new SimpleEffectSerializer<SnowTrailBrewEffect>(SnowTrailBrewEffect::new));
    public static final SimpleEffectSerializer<TidalHoldBrewEffect> TIDAL_HOLD = INSTANCE.add0("tidal_hold", new SimpleEffectSerializer<TidalHoldBrewEffect>(TidalHoldBrewEffect::new));
    public static final SimpleEffectSerializer<ExtinguishBrewEffect> EXTINGUISH = INSTANCE.add0("extinguish", new SimpleEffectSerializer<ExtinguishBrewEffect>(ExtinguishBrewEffect::new));
    public static final SimpleEffectSerializer<DissipateBrewEffect> DISSIPATE = INSTANCE.add0("dissipate", new SimpleEffectSerializer<DissipateBrewEffect>(DissipateBrewEffect::new));
    public static final SimpleEffectSerializer<FlowersBrewEffect> FLOWERS = INSTANCE.add0("flowers", new SimpleEffectSerializer<FlowersBrewEffect>(FlowersBrewEffect::new));
    public static final SimpleEffectSerializer<FertilizationBrewEffect> FERTILIZATION = INSTANCE.add0("fertilization", new SimpleEffectSerializer<FertilizationBrewEffect>(FertilizationBrewEffect::new));
    public static final SimpleEffectSerializer<HarvestingBrewEffect> HARVESTING = INSTANCE.add0("harvesting", new SimpleEffectSerializer<HarvestingBrewEffect>(HarvestingBrewEffect::new));
    public static final SimpleEffectSerializer<TillingBrewEffect> TILLING = INSTANCE.add0("tilling", new SimpleEffectSerializer<TillingBrewEffect>(TillingBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionPlanting> planting = INSTANCE.add0("planting", new SimpleEffectSerializer<BrewActionPlanting>(BrewActionPlanting::new));
    public static final SimpleEffectSerializer<PruningBrewEffect> pruning = INSTANCE.add0("pruning", new SimpleEffectSerializer<PruningBrewEffect>(PruningBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionFelling> FELLING = INSTANCE.add0("felling", new SimpleEffectSerializer<BrewActionFelling>(BrewActionFelling::new));
    public static final SimpleEffectSerializer<PulverisationBrewEffect> PULVERISATION = INSTANCE.add0("pulverisation", new SimpleEffectSerializer<PulverisationBrewEffect>(PulverisationBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionLilify> LILIFY = INSTANCE.add0("lilify", new SimpleEffectSerializer<BrewActionLilify>(BrewActionLilify::new));
    public static final SimpleEffectSerializer<CombustionBrewEffect> COMBUSTION = INSTANCE.add0("combustion", new SimpleEffectSerializer<CombustionBrewEffect>((serializer, invertible) -> new CombustionBrewEffect((BrewEffectSerializer<?>)serializer)));
    public static final SimpleEffectSerializer<LavaHoldBrewEffect> LAVA_HOLD = INSTANCE.add0("lava_hold", new SimpleEffectSerializer<LavaHoldBrewEffect>(LavaHoldBrewEffect::new));
    public static final SimpleEffectSerializer<BatBurstBrewEffect> BAT_BURST = INSTANCE.add0("bat_burst", new SimpleEffectSerializer<BatBurstBrewEffect>(BatBurstBrewEffect::new));
    public static final SimpleEffectSerializer<BodegaBrewEffect> BODEGA = INSTANCE.add0("bodega", new SimpleEffectSerializer<BodegaBrewEffect>(BodegaBrewEffect::new));
    public static final SimpleEffectSerializer<AirHikeBrewEffect> AIR_HIKE = INSTANCE.add0("air_hike", new SimpleEffectSerializer<AirHikeBrewEffect>(AirHikeBrewEffect::new));
    public static final SimpleEffectSerializer<FrogsTongueBrewEffect> FROGS_TONGUE = INSTANCE.add0("frogs_tongue", new SimpleEffectSerializer<FrogsTongueBrewEffect>(FrogsTongueBrewEffect::new));
    public static final SimpleEffectSerializer<ErosionBrewEffect> EROSION = INSTANCE.add0("erosion", new SimpleEffectSerializer<ErosionBrewEffect>(ErosionBrewEffect::new));
    public static final SimpleEffectSerializer<LevellingBrewEffect> LEVELLING = INSTANCE.add0("levelling", new SimpleEffectSerializer<LevellingBrewEffect>(LevellingBrewEffect::new));
    public static final SimpleEffectSerializer<WebsBrewEffect> WEBS = INSTANCE.add0("webs", new SimpleEffectSerializer<WebsBrewEffect>(WebsBrewEffect::new));
    public static final SimpleEffectSerializer<VinesBrewEffect> VINES = INSTANCE.add0("vines", new SimpleEffectSerializer<VinesBrewEffect>(VinesBrewEffect::new));
    public static final SimpleEffectSerializer<ThornsBrewEffect> THORNS = INSTANCE.add0("thorns", new SimpleEffectSerializer<ThornsBrewEffect>(ThornsBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionSprouting> SPROUTING = INSTANCE.add0("sprouting", new SimpleEffectSerializer<BrewActionSprouting>(BrewActionSprouting::new));
    public static final SimpleEffectSerializer<ColdBrewEffect> COLD = INSTANCE.add0("cold", new SimpleEffectSerializer<ColdBrewEffect>(ColdBrewEffect::new));
    public static final SimpleEffectSerializer<KnockbackBrewEffect> KNOCKBACK = INSTANCE.add0("knockback", new SimpleEffectSerializer<KnockbackBrewEffect>(KnockbackBrewEffect::new));
    public static final SimpleEffectSerializer<UndeadbaneBrewEffect> UNDEADBANE = INSTANCE.add0("undeadbane", new SimpleEffectSerializer<UndeadbaneBrewEffect>(UndeadbaneBrewEffect::new));
    public static final SimpleEffectSerializer<InsectbaneBrewEffect> INSECTBANE = INSTANCE.add0("insectbane", new SimpleEffectSerializer<InsectbaneBrewEffect>(InsectbaneBrewEffect::new));
    public static final SimpleEffectSerializer<GrowOakBrewEffect> GROW_OAK_TREE = INSTANCE.add0("grow_oak", new SimpleEffectSerializer<GrowOakBrewEffect>(GrowOakBrewEffect::new));
    public static final SimpleEffectSerializer<GrowSpruceBrewEffect> GROW_SPRUCE_TREE = INSTANCE.add0("grow_spruce", new SimpleEffectSerializer<GrowSpruceBrewEffect>(GrowSpruceBrewEffect::new));
    public static final SimpleEffectSerializer<GrowBirchBrewEffect> GROW_BIRCH_TREE = INSTANCE.add0("grow_birch", new SimpleEffectSerializer<GrowBirchBrewEffect>(GrowBirchBrewEffect::new));
    public static final SimpleEffectSerializer<GrowJungleBrewEffect> GROW_JUNGLE_TREE = INSTANCE.add0("grow_jungle", new SimpleEffectSerializer<GrowJungleBrewEffect>(GrowJungleBrewEffect::new));
    public static final SimpleEffectSerializer<GrowAcaciaBrewEffect> GROW_ACACIA_TREE = INSTANCE.add0("grow_acacia", new SimpleEffectSerializer<GrowAcaciaBrewEffect>(GrowAcaciaBrewEffect::new));
    public static final SimpleEffectSerializer<GrowDarkOakBrewEffect> GROW_DARK_OAK_TREE = INSTANCE.add0("grow_dark_oak", new SimpleEffectSerializer<GrowDarkOakBrewEffect>(GrowDarkOakBrewEffect::new));
    public static final SimpleEffectSerializer<GrowRowanBrewEffect> GROW_ROWAN_TREE = INSTANCE.add0("grow_rowan", new SimpleEffectSerializer<GrowRowanBrewEffect>(GrowRowanBrewEffect::new));
    public static final SimpleEffectSerializer<GrowAlderBrewEffect> GROW_ALDER_TREE = INSTANCE.add0("grow_alder", new SimpleEffectSerializer<GrowAlderBrewEffect>(GrowAlderBrewEffect::new));
    public static final SimpleEffectSerializer<GrowHawthornBrewEffect> GROW_HAWTHORN_TREE = INSTANCE.add0("grow_hawthorn", new SimpleEffectSerializer<GrowHawthornBrewEffect>(GrowHawthornBrewEffect::new));
    public static final SimpleEffectSerializer<CureBuffsBrewEffect> CURE_BUFFS = INSTANCE.add0("cure_buffs", new SimpleEffectSerializer<CureBuffsBrewEffect>(CureBuffsBrewEffect::new));
    public static final SimpleEffectSerializer<CureDebuffsBrewEffect> CURE_DEBUFFS = INSTANCE.add0("cure_debuffs", new SimpleEffectSerializer<CureDebuffsBrewEffect>(CureDebuffsBrewEffect::new));
    public static final SimpleEffectSerializer<EndlessWaterBrewEffect> ENDLESS_WATER = INSTANCE.add0("endless_water", new SimpleEffectSerializer<EndlessWaterBrewEffect>((serializer, invertible) -> new EndlessWaterBrewEffect((BrewEffectSerializer<?>)serializer)));
    public static final SimpleEffectSerializer<FlamesBrewEffect> FLAMES = INSTANCE.add0("flames", new SimpleEffectSerializer<FlamesBrewEffect>(FlamesBrewEffect::new));
    public static final SimpleEffectSerializer<WastingBrewEffect> WASTING = INSTANCE.add0("wasting", new SimpleEffectSerializer<WastingBrewEffect>(WastingBrewEffect::new));
    public static final SimpleEffectSerializer<RevealingBrewEffect> REVEALING = INSTANCE.add0("revealing", new SimpleEffectSerializer<RevealingBrewEffect>(RevealingBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionBlight> BLIGHT = INSTANCE.add0("blight", new SimpleEffectSerializer<BrewActionBlight>(BrewActionBlight::new));
    public static final SimpleEffectSerializer<BrewActionTranspose> TRANSPOSE = INSTANCE.add0("transpose", new SimpleEffectSerializer<BrewActionTranspose>(BrewActionTranspose::new));
    public static final SimpleEffectSerializer<TransposeOreBrewEffect> TRANSPOSE_ORE = INSTANCE.add0("transpose_ore", new SimpleEffectSerializer<TransposeOreBrewEffect>(TransposeOreBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionRaising> RAISING = INSTANCE.add0("raising", new SimpleEffectSerializer<BrewActionRaising>(BrewActionRaising::new));
    public static final SimpleEffectSerializer<BrewActionRaiseLand> RAISE_LAND = INSTANCE.add0("raise_land", new SimpleEffectSerializer<BrewActionRaiseLand>(BrewActionRaiseLand::new));
    public static final SimpleEffectSerializer<HarmWerewolvesBrewEffect> HARM_WEREWOLVES = INSTANCE.add0("harm_werewolves", new SimpleEffectSerializer<HarmWerewolvesBrewEffect>(HarmWerewolvesBrewEffect::new));
    public static final SimpleEffectSerializer<WeakenVampiresBrewEffect> WEAKEN_VAMPIRES = INSTANCE.add0("weaken_vampires", new SimpleEffectSerializer<WeakenVampiresBrewEffect>(WeakenVampiresBrewEffect::new));
    public static final SimpleEffectSerializer<AnimalAttractionBrewEffect> ANIMAL_ATTRACTION = INSTANCE.add0("animal_attraction", new SimpleEffectSerializer<AnimalAttractionBrewEffect>(AnimalAttractionBrewEffect::new));
    public static final SimpleEffectSerializer<InfernoBrewEffect> INFERNO = INSTANCE.add0("inferno", new SimpleEffectSerializer<InfernoBrewEffect>(InfernoBrewEffect::new));
    public static final SimpleEffectSerializer<BlastBrewEffect> BLAST = INSTANCE.add0("blast", new SimpleEffectSerializer<BlastBrewEffect>(BlastBrewEffect::new));
    public static final SimpleEffectSerializer<PoisonToadBrewEffect> poison_toad = INSTANCE.add0("poison_toad", new SimpleEffectSerializer<PoisonToadBrewEffect>(PoisonToadBrewEffect::new));
    public static final SimpleEffectSerializer<IceWorldBrewEffect> ICE_WORLD = INSTANCE.add0("ice_world", new SimpleEffectSerializer<IceWorldBrewEffect>(IceWorldBrewEffect::new));
    public static final SimpleEffectSerializer<IcyShellBrewEffect> icy_shell = INSTANCE.add0("icy_shell", new SimpleEffectSerializer<IcyShellBrewEffect>(IcyShellBrewEffect::new));
    public static final SimpleEffectSerializer<DemonbaneBrewEffect> DEMONBANE = INSTANCE.add0("demonbane", new SimpleEffectSerializer<DemonbaneBrewEffect>(DemonbaneBrewEffect::new));
    public static final SimpleEffectSerializer<PotionLongevityBrewEffect> POTION_LONGEVITY = INSTANCE.add0("potion_longevity", new SimpleEffectSerializer<PotionLongevityBrewEffect>(PotionLongevityBrewEffect::new));
    public static final SimpleEffectSerializer<StealBuffsBrewEffect> STEAL_BUFFS = INSTANCE.add0("steal_buffs", new SimpleEffectSerializer<StealBuffsBrewEffect>(StealBuffsBrewEffect::new));
    public static final SimpleEffectSerializer<DrainMangicBrewEffect> DRAIN_MAGIC = INSTANCE.add0("drain_magic", new SimpleEffectSerializer<DrainMangicBrewEffect>(DrainMangicBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionBiomeChange> SHIFTING_SEASONS = INSTANCE.add0("shifting_seasons", new SimpleEffectSerializer<BrewActionBiomeChange>(BrewActionBiomeChange::new));
    public static final SimpleEffectSerializer<SpreadDebuffsBrewEffect> SPREAD_DEBUFFS = INSTANCE.add0("spread_debuffs", new SimpleEffectSerializer<SpreadDebuffsBrewEffect>(SpreadDebuffsBrewEffect::new));
    public static final SimpleEffectSerializer<BrewActionSummonLeonard> SUMMON_LEONARD = INSTANCE.add0("summon_leonard", new SimpleEffectSerializer<BrewActionSummonLeonard>((serializer, invertible) -> new BrewActionSummonLeonard((BrewEffectSerializer<?>)serializer)));

    private WitcheryBrewEffects() {
        super(BrewEffectSerializer.REGISTRY, "witchery", null);
    }

    public static String getBrewName(BrewActionList actionList) {
        BrewNameBuilder nameBuilder = new BrewNameBuilder(true);
        for (BrewAction action : actionList.actions) {
            BrewNamePart name2 = action.getNamePart();
            if (name2 == null) continue;
            name2.applyTo(nameBuilder);
        }
        return nameBuilder.toString();
    }

    public static int getUsedCapacity(BrewActionList actionList) {
        EffectLevelCounter effectCounter = new EffectLevelCounter();
        for (BrewAction action2 : actionList.actions) {
            action2.augmentEffectLevels(effectCounter);
        }
        return effectCounter.usedCapacity();
    }

    public static boolean canNotAdd(TileEntityCauldron cauldron, BrewAction brewAction, boolean isCauldronFull) {
        if (cauldron.isRitualTriggered()) {
            return true;
        }
        if (brewAction == null) {
            return false;
        }
        BrewActionList actionList = cauldron.getActions();
        EffectLevelCounter effectCounter = cauldron.getEffectCounter();
        boolean actionFound = false;
        for (BrewAction action : actionList.actions) {
            if (action == brewAction) {
                actionFound = true;
                continue;
            }
            if (!(action instanceof EffectBrewAction)) continue;
            actionFound = false;
        }
        return !brewAction.canAdd(actionList, cauldron.isSplash(), isCauldronFull, effectCounter.hasEffects()) || actionFound && !brewAction.getAllowMultiple() || !brewAction.augmentEffectLevels(effectCounter);
    }

    public static EffectLevelCounter getBrewLevel(BrewActionList actionList) {
        EffectLevelCounter effectCounter = new EffectLevelCounter();
        for (BrewAction action : actionList.actions) {
            action.augmentEffectLevels(effectCounter);
        }
        return effectCounter;
    }

    public static ModifierYield getYieldModifier(BrewActionList actionList) {
        ModifierYield counter = new ModifierYield(0);
        for (BrewAction action : actionList.actions) {
            action.prepareYield(counter);
        }
        return counter;
    }

    public static RitualStatus updateRitual(MinecraftServer server, TileEntityCauldron cauldron, int covenSize, int ritualPulses, boolean lennyPresent) {
        BrewActionList actionList = cauldron.getActions();
        ModifiersRitual ritualModifiers = new ModifiersRitual(cauldron.func_174877_v(), cauldron.func_145831_w().field_73011_w.getDimension(), covenSize, ritualPulses, lennyPresent);
        ModifiersImpact impactModifiers = new ModifiersImpact(new Vec3d((Vec3i)ritualModifiers.getTarget()), true, ritualModifiers.covenSize, null);
        ModifiersEffect effectModifiers = new ModifiersEffect(1.0, 1.0, false, new Vec3d((Vec3i)cauldron.func_174877_v()), impactModifiers);
        for (int i = 0; i < actionList.actions.size(); ++i) {
            BrewAction action = actionList.actions.get(i);
            action.prepareRitual(ritualModifiers, actionList.items.get(i));
            action.prepareSplashPotion(cauldron.func_145831_w(), actionList, impactModifiers);
            if (!action.augmentEffectLevels(effectModifiers.effectLevel)) continue;
            action.augmentEffectModifiers(effectModifiers);
        }
        return actionList.getTopAction().updateRitual(server, actionList, cauldron.func_145831_w(), cauldron.func_174877_v(), ritualModifiers, impactModifiers, effectModifiers);
    }

    public static boolean impactSplashPotion(World world, ItemStack stack, RayTraceResult mop, ModifiersImpact modifiers) {
        return WitcheryBrewEffects.impactSplashPotion(world, stack.func_77978_p(), mop, modifiers);
    }

    public static boolean impactSplashPotion(World world, NBTTagCompound nbtBrew, RayTraceResult mop, ModifiersImpact modifiers) {
        return WitcheryBrewEffects.impactSplashPotion(world, new BrewActionList(nbtBrew == null ? null : nbtBrew.func_150295_c("Items", 10)), mop, modifiers);
    }

    public static boolean impactSplashPotion(World world, BrewActionList actionList, RayTraceResult mop, ModifiersImpact modifiers) {
        modifiers.getDispersal().onImpactSplashPotion(world, actionList, mop, modifiers);
        return true;
    }

    public static void applyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, BrewActionList actionList, ModifiersRitual ritualModifiers, ModifiersEffect effectModifiers) {
        actionList.applyRitualToBlock(world, pos, side, radius, ritualModifiers, effectModifiers);
    }
}

