/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Dyeable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.inventory.InventoryBrewBag;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketBrewPrepared;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemBrewBag
extends Item
implements Dyeable {
    private static final float THRESHOLD_ORTHOGONAL = 7.0f;
    private static final float THRESHOLD_DIAGONAL = 3.5f;

    public ItemBrewBag() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCauldron cauldron;
        int i;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150383_bp && (i = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
            if (this.hasColor(stack)) {
                this.removeColor(stack);
                Blocks.field_150383_bp.func_176590_a(world, pos, state, i - 1);
                return EnumActionResult.SUCCESS;
            }
        } else if (state.func_177230_c() == WitcheryBlocks.CAULDRON && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos)) != null && cauldron.drain(1000, true) != null) {
            if (this.hasColor(stack)) {
                this.removeColor(stack);
            } else {
                this.setColor(stack, cauldron.getColor());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!player.func_70093_af()) {
            NBTTagCompound nbtTag = player.getEntityData();
            nbtTag.func_74776_a("StartPitch", player.field_70125_A);
            nbtTag.func_74776_a("StartYaw", player.field_70759_as);
            nbtTag.func_82580_o("WitcheryLastBrewIndex");
        } else {
            WitcheryUtils.openContainer(WitcheryContainers.getBrewBag(), player, BlockPos.field_177992_a, (ITextComponent)new TextComponentString(stack.func_82833_r()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int countdown) {
        if (player instanceof EntityPlayer) {
            NBTTagCompound nbtTag;
            if (player.field_70170_p.field_72995_K) {
                NBTTagCompound tag = player.getEntityData();
                if (player.func_70093_af()) {
                    tag.func_82580_o("Stroke");
                    tag.func_74776_a("StartPitch", player.field_70125_A);
                    tag.func_74776_a("StartYaw", player.field_70759_as);
                    return;
                }
                float yawDiff = tag.func_74760_g("StartYaw") - player.field_70759_as;
                float pitchDiff = tag.func_74760_g("StartPitch") - player.field_70125_A;
                if (!tag.func_74764_b("Stroke")) {
                    int stroke = -1;
                    if (pitchDiff >= 3.5f && yawDiff <= -3.5f) {
                        stroke = BranchStroke.DOWN_LEFT.ordinal();
                    } else if (pitchDiff >= 3.5f && yawDiff >= 3.5f) {
                        stroke = BranchStroke.UP_LEFT.ordinal();
                    } else if (pitchDiff <= -3.5f && yawDiff <= -3.5f) {
                        stroke = BranchStroke.DOWN_RIGHT.ordinal();
                    } else if (pitchDiff <= -3.5f && yawDiff >= 3.5f) {
                        stroke = BranchStroke.UP_RIGHT.ordinal();
                    } else if (pitchDiff >= 7.0f) {
                        stroke = BranchStroke.UP.ordinal();
                    } else if (pitchDiff <= -7.0f) {
                        stroke = BranchStroke.DOWN.ordinal();
                    } else if (yawDiff <= -7.0f) {
                        stroke = BranchStroke.RIGHT.ordinal();
                    } else if (yawDiff >= 7.0f) {
                        stroke = BranchStroke.LEFT.ordinal();
                    }
                    if (stroke != -1) {
                        tag.func_74776_a("StartPitch", player.field_70125_A);
                        tag.func_74776_a("StartYaw", player.field_70759_as);
                        tag.func_74774_a("Stroke", (byte)stroke);
                        int brewIndex = BranchStroke.VALUES[stroke].getIndex();
                        InventoryBrewBag inv = new InventoryBrewBag((EntityPlayer)player);
                        ItemStack brew = inv.func_70301_a(brewIndex);
                        if (!brew.func_190926_b()) {
                            WitcheryNetworkChannel.sendToServer(new PacketBrewPrepared(brewIndex));
                            WitcheryUtils.playSoundAt((EntityPlayer)player, SoundEvents.field_187638_cR, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        } else {
                            tag.func_82580_o("Stroke");
                        }
                    }
                }
            } else if (player.func_70093_af() && (nbtTag = player.getEntityData()).func_74764_b("WitcheryLastBrewIndex")) {
                nbtTag.func_82580_o("WitcheryLastBrewIndex");
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound nbtTag = player.getEntityData();
            if (!world.field_72995_K && nbtTag.func_74764_b("WitcheryLastBrewIndex")) {
                int brewIndex = nbtTag.func_74762_e("WitcheryLastBrewIndex");
                nbtTag.func_82580_o("WitcheryLastBrewIndex");
                if (!player.func_70093_af()) {
                    if (brewIndex > -1) {
                        InventoryBrewBag inv = new InventoryBrewBag(player);
                        ItemStack brew = inv.func_70301_a(brewIndex);
                        if (!brew.func_190926_b()) {
                            if (brew.func_77973_b() == WitcheryGeneralItems.SPLASH_BREW_BOTTLE || brew.func_77973_b() == WitcheryGeneralItems.LINGERING_BREW_BOTTLE) {
                                if (!player.field_71075_bZ.field_75098_d) {
                                    brew.func_190918_g(1);
                                }
                                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187737_v, player.func_184176_by(), 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                                EntityBrew brewEntity = new EntityBrew(world, (EntityLivingBase)player, brew, false);
                                brewEntity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.75f, 1.0f);
                                world.func_72838_d((Entity)brewEntity);
                            } else {
                                ItemKettleBrew.Companion.throwStack(world, player, brew);
                            }
                            inv.writeToNBT();
                        }
                    } else {
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / ((float)player.func_70681_au().nextDouble() * 0.4f + 0.8f));
                    }
                }
            } else {
                nbtTag.func_82580_o("Stroke");
                nbtTag.func_82580_o("StartYaw");
                nbtTag.func_82580_o("StartPitch");
            }
        }
    }
}

