/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.BlockUtil;

public class ItemChalk
extends ItemBlock {
    public ItemChalk(Block block) {
        super(block);
        this.func_77656_e(64);
        this.setNoRepair();
    }

    public static boolean drawGlyph(World world, BlockPos pos, EnumFacing side, Block block, EntityPlayer player) {
        boolean chalkUsed = false;
        if (block != WitcheryBlocks.CIRCLE) {
            Block overBlock = world.func_180495_p(pos).func_177230_c();
            if (overBlock == block) {
                world.func_180501_a(pos, overBlock.func_176223_P().func_177226_a(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.field_73012_v))), 3);
                chalkUsed = true;
            } else if (overBlock == WitcheryBlocks.GLYPH_RITUAL || overBlock == WitcheryBlocks.GLYPH_OTHERWHERE || overBlock == WitcheryBlocks.GLYPH_INFERNAL) {
                world.func_180501_a(pos, block.func_176223_P().func_177226_a(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.field_73012_v))), 3);
                chalkUsed = true;
            } else if (side == EnumFacing.UP && WitcheryBlocks.GLYPH_RITUAL.func_176196_c(world, pos.func_177984_a()) && BlockUtil.isReplaceableBlock(world, pos.func_177984_a(), (EntityLivingBase)player)) {
                world.func_180501_a(pos.func_177984_a(), block.func_176223_P().func_177226_a(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.field_73012_v))), 3);
                chalkUsed = true;
            }
        } else if (world.func_180495_p(pos).func_177230_c() != block && side == EnumFacing.UP && WitcheryBlocks.CIRCLE.func_176196_c(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), block.func_176223_P());
            chalkUsed = true;
        }
        if (chalkUsed) {
            world.func_184133_a(null, pos, WitcherySounds.ITEM_CHALK_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return chalkUsed;
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77951_h() ? 1 : 64;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            boolean chalkUsed = ItemChalk.drawGlyph(world, pos, side, this.field_150939_a, player);
            if (chalkUsed) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (stack.func_190916_E() > 1) {
                        ItemStack newStack = stack.func_77946_l();
                        newStack.func_190918_g(1);
                        newStack.func_77964_b(0);
                        if (!player.field_71071_by.func_70441_a(newStack)) {
                            player.func_71019_a(newStack, false);
                        }
                        stack.func_190920_e(1);
                    }
                }
            } else {
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

