/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelDeathsClothes;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemDeathsClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelDeathsClothes model;

    public ItemDeathsClothes(EntityEquipmentSlot armorSlot) {
        super(ItemArmor.ArmorMaterial.IRON, 1, armorSlot);
        this.func_77656_e(ItemArmor.ArmorMaterial.DIAMOND.func_78046_a(armorSlot));
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static boolean isFullSetWorn(EntityLivingBase entity) {
        int count = 0;
        for (int i = 2; i <= 5; ++i) {
            ItemStack item = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (!(item.func_77973_b() instanceof ItemDeathsClothes)) continue;
            ++count;
        }
        return count >= 3;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type2) {
        if (!stack.func_190926_b()) {
            return "witchery:textures/entities/deathsclothes" + (type2 == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && player.field_71071_by.field_70460_b.get(3) == stack) {
            PotionEffect potion;
            int offset = (int)(world.func_82737_E() % 10L);
            if (WitcheryConfigOptions.allowDeathsHoodToFreezeVictims && offset == 1) {
                EntityLivingBase victim;
                RayTraceResult mop = OtherwhereInfusion.raytraceEntities(world, player, 16.0);
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g instanceof EntityLivingBase && (victim = (EntityLivingBase)mop.field_72308_g).func_70685_l((Entity)player) && !victim.func_70644_a(MobEffects.field_76421_d)) {
                    victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 2));
                }
            } else if (offset == 2 && world.func_175699_k(player.func_180425_c()) < 8 && ((potion = player.func_70660_b(MobEffects.field_76439_r)) == null || potion.func_76459_b() <= 300)) {
                player.func_184589_d(MobEffects.field_76439_r);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 400, 0, true, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.model == null) {
            this.model = new ModelDeathsClothes();
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        if (!stack.func_190926_b() && (stack.func_77973_b() != WitcheryEquipmentItems.DEATH_HOOD || WitcheryConfigOptions.allowDeathsHoodToFreezeVictims)) {
            String localText = WitcheryResurrected.translateSplit(this.func_77658_a() + ".tip", new Object[0]);
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }
}

