/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemDeathsClothes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.EntityUtil;

public class ItemDeathsHand
extends Item {
    private final boolean deployed;

    public ItemDeathsHand(boolean deployed) {
        this.deployed = deployed;
        this.func_77625_d(1);
        this.func_77664_n();
        if (!deployed) {
            this.func_77637_a(WitcheryGeneralItems.TAB);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translateSplit(WitcheryGeneralItems.DEATH_HAND.func_77658_a() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean isHeldItem) {
        if (this.deployed && entity instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            if (world.func_72820_D() % 20L == 0L) {
                if (!ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player)) {
                    player.field_71071_by.func_70299_a(inventorySlot, new ItemStack((Item)WitcheryGeneralItems.DEATH_HAND));
                } else {
                    int level = player.func_71024_bL().func_75116_a();
                    if (level > 0) {
                        player.func_71024_bL().func_75122_a(level == 1 ? -1 : -2, 0.0f);
                    }
                }
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity otherEntity) {
        if (!player.field_70170_p.field_72995_K && otherEntity instanceof EntityLivingBase) {
            EntityLivingBase victim = (EntityLivingBase)otherEntity;
            float MAX_DAMAGE = 15.0f;
            float damagePct = 0.1f;
            float minDamage = 2.0f;
            int hungerRestore = 0;
            int healthRestore = 0;
            if (this.deployed) {
                int hunger = player.func_71024_bL().func_75116_a();
                if (hunger == 0) {
                    damagePct = 0.5f;
                    minDamage = 4.0f;
                    hungerRestore = 10;
                    healthRestore = 3;
                } else if (hunger <= 4) {
                    damagePct = 0.25f;
                    minDamage = 4.0f;
                    hungerRestore = 3;
                    healthRestore = 2;
                } else if (hunger <= 10) {
                    damagePct = 0.2f;
                    minDamage = 3.0f;
                    hungerRestore = 2;
                    healthRestore = 1;
                } else if (hunger <= 20) {
                    damagePct = 0.15f;
                    minDamage = 3.0f;
                    hungerRestore = 1;
                } else {
                    damagePct = 0.15f;
                    minDamage = 3.0f;
                }
            }
            if (this.deployed) {
                double r = 1.5;
                AxisAlignedBB bb = new AxisAlignedBB(victim.field_70165_t - r, victim.func_174813_aQ().field_72338_b, victim.field_70161_v - r, victim.field_70165_t + r, victim.func_174813_aQ().field_72337_e, victim.field_70161_v + r);
                List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
                for (EntityLivingBase hitEntity : entities) {
                    float maxHealth;
                    float damage;
                    boolean flag;
                    if (hitEntity == player || !(flag = EntityUtil.touchOfDeath((Entity)hitEntity, (EntityLivingBase)player, damage = Math.min(Math.max((maxHealth = Math.min(hitEntity.func_110138_aP(), 20.0f)) * damagePct, minDamage), MAX_DAMAGE)))) continue;
                    if (hungerRestore > 0) {
                        player.func_71024_bL().func_75122_a(hungerRestore, 0.0f);
                    }
                    if (healthRestore <= 0) continue;
                    player.func_70691_i((float)healthRestore);
                }
            } else {
                float maxHealth2 = Math.min(victim.func_110138_aP(), 20.0f);
                float damage2 = Math.min(Math.max(maxHealth2 * damagePct, minDamage), MAX_DAMAGE);
                EntityUtil.touchOfDeath((Entity)victim, (EntityLivingBase)player, damage2);
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player)) {
            if (this.deployed) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)WitcheryGeneralItems.DEATH_HAND));
            }
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187525_aO, player.func_184176_by(), 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.SPELL_MOB), (Entity)player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)WitcheryGeneralItems.DEPLOYED_DEATH_HAND));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

