/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityBroom;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0004\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/item/ItemEnchantedBroom;", "Lnet/minecraft/item/Item;", "()V", "getColor", "Lnet/minecraft/item/EnumDyeColor;", "stack", "Lnet/minecraft/item/ItemStack;", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "hasEffect", "", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "setBroomEntityColor", "", "broomEntity", "Lnet/msrandom/witchery/entity/EntityBroom;", "itemstack", "setColor", "color", "WitcheryResurrected"})
public final class ItemEnchantedBroom
extends Item {
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult enumActionResult;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        Intrinsics.checkParameterIsNotNull(facing, "facing");
        ItemStack stack = player.func_184586_b(hand);
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q);
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) + (double)player.func_70047_e();
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s);
        Vec3d playerPosition = new Vec3d(x, y, z);
        Vec3d look = player.func_70676_i(1.0f);
        boolean colliding = false;
        for (Entity entity : world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0).func_186662_g(1.0))) {
            if (!entity.func_70067_L()) continue;
            Entity entity2 = entity;
            Intrinsics.checkExpressionValueIsNotNull(entity2, "entity");
            if (!entity2.func_174813_aQ().func_186662_g((double)entity.func_70111_Y()).func_72318_a(playerPosition)) continue;
            colliding = true;
        }
        if (colliding) {
            EnumActionResult enumActionResult2 = super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            Intrinsics.checkExpressionValueIsNotNull(enumActionResult2, "super.onItemUse(player, \u2026facing, hitX, hitY, hitZ)");
            return enumActionResult2;
        }
        BlockPos position = pos.func_177972_a(facing);
        IBlockState iBlockState = world.func_180495_p(position);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(position)");
        if (Intrinsics.areEqual(iBlockState.func_177230_c(), Blocks.field_150433_aE)) {
            position = position.func_177977_b();
        }
        BlockPos blockPos = position;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "position");
        EntityBroom broomEntity = new EntityBroom(world, (double)blockPos.func_177958_n() + 0.5, (double)position.func_177956_o() + 1.0, (double)position.func_177952_p() + 0.5);
        if (stack.func_82837_s()) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
            broomEntity.func_96094_a(itemStack.func_82833_r());
        }
        ItemStack itemStack = stack;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
        this.setBroomEntityColor(broomEntity, itemStack);
        broomEntity.field_70177_z = player.field_70177_z;
        if (world.func_184144_a((Entity)broomEntity, broomEntity.func_174813_aQ().func_72321_a(-0.1, -0.1, -0.1)).isEmpty()) {
            broomEntity.field_70177_z = player.field_70177_z;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)broomEntity);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
            enumActionResult = EnumActionResult.SUCCESS;
        } else {
            enumActionResult = EnumActionResult.FAIL;
        }
        return enumActionResult;
    }

    private final void setBroomEntityColor(EntityBroom broomEntity, ItemStack itemstack) {
        broomEntity.setBrushColor(this.getColor(itemstack));
    }

    public final void setColor(@NotNull ItemStack stack, @NotNull EnumDyeColor color2) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(color2, "color");
        WitcheryUtils.getOrCreateTag(stack).func_74774_a("BrushColor", (byte)color2.func_176765_a());
    }

    @NotNull
    public final EnumDyeColor getColor(@NotNull ItemStack stack) {
        NBTTagCompound tag;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        if (stack.func_77942_o() && (tag = WitcheryUtils.getOrCreateTag(stack)).func_74764_b("BrushColor")) {
            EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)tag.func_74771_c("BrushColor"));
            Intrinsics.checkExpressionValueIsNotNull(enumDyeColor, "EnumDyeColor.byMetadata(\u2026te(\"BrushColor\").toInt())");
            return enumDyeColor;
        }
        return EnumDyeColor.BROWN;
    }

    public boolean func_77636_d(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return true;
    }

    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return EnumRarity.EPIC;
    }

    public ItemEnchantedBroom() {
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }
}

