/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016JH\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010)\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0011\u00a8\u0006,"}, d2={"Lnet/msrandom/witchery/item/ItemEndlessWaterBrew;", "Lnet/minecraft/item/Item;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getDurabilityForDisplay", "", "getRemaining", "", "getUsedAmount", "hasEffect", "", "initCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "face", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "showDurabilityBar", "use", "amount", "FluidHandler", "WitcheryResurrected"})
public final class ItemEndlessWaterBrew
extends Item {
    public boolean func_77636_d(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        Intrinsics.checkParameterIsNotNull(face, "face");
        BlockPos placementPosition = pos;
        ItemStack itemStack = stack = player.func_184586_b(hand);
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
        if (this.getRemaining(itemStack) >= 1000) {
            IBlockState state;
            IBlockState iBlockState = state = world.func_180495_p(placementPosition);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
            Block block = iBlockState.func_177230_c();
            if (block == Blocks.field_150383_bp) {
                if (!world.field_72995_K && Intrinsics.compare(((Number)((Object)state.func_177229_b((IProperty)BlockCauldron.field_176591_a))).intValue(), 3) < 0) {
                    int n = this.getRemaining(stack);
                    Comparable comparable = state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                    Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(BlockCauldron.LEVEL)");
                    this.use(player, stack, RangesKt.coerceAtMost(n, MathKt.roundToInt((float)(3 - ((Number)((Object)comparable)).intValue()) * 333.33334f)));
                    Blocks.field_150383_bp.func_176590_a(world, placementPosition, state, 3);
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                EnumActionResult enumActionResult;
                TileEntity tileEntity = world.func_175625_s(placementPosition);
                if (tileEntity instanceof IFluidHandler) {
                    int used = ((IFluidHandler)tileEntity).fill(new FluidStack(FluidRegistry.WATER, 3000), true);
                    if (used > 0) {
                        this.use(player, stack, used);
                        world.func_184133_a(null, pos, SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        tileEntity.func_70296_d();
                        enumActionResult = EnumActionResult.SUCCESS;
                    } else {
                        enumActionResult = EnumActionResult.FAIL;
                    }
                } else {
                    Material material;
                    IBlockState iblockstate;
                    BlockPos blockPos = placementPosition.func_177972_a(face);
                    Intrinsics.checkExpressionValueIsNotNull(blockPos, "placementPosition.offset(face)");
                    placementPosition = blockPos;
                    IBlockState iBlockState2 = iblockstate = world.func_180495_p(placementPosition);
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "iblockstate");
                    Material material2 = material = iBlockState2.func_185904_a();
                    Intrinsics.checkExpressionValueIsNotNull(material2, "material");
                    boolean flag = !material2.func_76220_a();
                    boolean flag1 = iblockstate.func_177230_c().func_176200_f((IBlockAccess)world, placementPosition);
                    if (!(world.func_175623_d(placementPosition) || flag || flag1)) {
                        enumActionResult = EnumActionResult.FAIL;
                    } else {
                        if (world.field_73011_w.func_177500_n()) {
                            int l = placementPosition.func_177958_n();
                            int i = placementPosition.func_177956_o();
                            int j = placementPosition.func_177952_p();
                            world.func_184133_a(player, placementPosition, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                            int n = 0;
                            int n2 = 7;
                            while (n <= n2) {
                                void k;
                                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                                ++k;
                            }
                        } else {
                            if (!world.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                                world.func_175655_b(placementPosition, true);
                            }
                            this.use(player, stack, 1000);
                            world.func_184133_a(player, placementPosition, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            BlockDynamicLiquid blockDynamicLiquid = Blocks.field_150358_i;
                            Intrinsics.checkExpressionValueIsNotNull(blockDynamicLiquid, "Blocks.FLOWING_WATER");
                            world.func_180501_a(placementPosition, blockDynamicLiquid.func_176223_P(), 11);
                        }
                        enumActionResult = EnumActionResult.SUCCESS;
                    }
                }
                return enumActionResult;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return WitcheryUtils.getOrCreateTag(stack).func_74762_e("Amount") != 0;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return (double)WitcheryUtils.getOrCreateTag(stack).func_74762_e("Amount") / 300000.0;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flagIn, "flagIn");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String string = I18n.func_135052_a((String)(this.func_77658_a() + ".tip"), (Object[])new Object[]{"" + TextFormatting.AQUA + this.getRemaining(stack) / 1000 + TextFormatting.GRAY, TextFormatting.AQUA + "300" + TextFormatting.GRAY});
        Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(\"$translatio\u20260${TextFormatting.GRAY}\")");
        tooltip.add(string);
    }

    @NotNull
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return new FluidHandler(stack);
    }

    public final void use(@Nullable EntityPlayer player, @NotNull ItemStack stack, int amount) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack);
            int newAmount = tag.func_74762_e("Amount") + amount;
            tag.func_74768_a("Amount", newAmount);
            if (newAmount >= 300000) {
                stack.func_190918_g(1);
            }
        }
    }

    public final int getRemaining(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 300000 - this.getUsedAmount(stack);
    }

    public final int getUsedAmount(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return WitcheryUtils.getOrCreateTag(stack).func_74762_e("Amount");
    }

    public ItemEndlessWaterBrew() {
        this.func_77625_d(1);
        this.func_77637_a(WitcheryGeneralItems.TAB);
        this.func_185043_a(new ResourceLocation("witchery", "emptiness"), new IItemPropertyGetter(){

            public final float func_185085_a(ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                float f = 1.0f;
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
                return f - (float)this.getRemaining(itemStack) / 300000.0f;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J-\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/msrandom/witchery/item/ItemEndlessWaterBrew$FluidHandler;", "Lnet/minecraftforge/fluids/capability/IFluidHandlerItem;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "container", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "", "doDrain", "", "resource", "fill", "doFill", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getContainer", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/FluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/FluidTankProperties;", "hasCapability", "WitcheryResurrected"})
    private static final class FluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private ItemStack container;

        public boolean hasCapability(@NotNull Capability<?> capability2, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability2, "capability");
            return capability2 == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability2, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability2, "capability");
            return (T)(capability2 == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this) : null);
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }

        @NotNull
        public FluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, 3000), 300000, false, true)};
        }

        public int fill(@NotNull FluidStack resource, boolean doFill) {
            Intrinsics.checkParameterIsNotNull(resource, "resource");
            return 0;
        }

        @Nullable
        public FluidStack drain(@NotNull FluidStack resource, boolean doDrain) {
            Intrinsics.checkParameterIsNotNull(resource, "resource");
            return resource.getFluid() != FluidRegistry.WATER ? null : this.drain(resource.amount, doDrain);
        }

        @NotNull
        public FluidStack drain(int maxDrain, boolean doDrain) {
            Item item = this.container.func_77973_b();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.ItemEndlessWaterBrew");
            }
            int drainAmount = RangesKt.coerceAtMost(((ItemEndlessWaterBrew)item).getRemaining(this.getContainer()), maxDrain);
            if (doDrain) {
                Item item2 = this.container.func_77973_b();
                if (item2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.ItemEndlessWaterBrew");
                }
                ((ItemEndlessWaterBrew)item2).use(null, this.getContainer(), drainAmount);
            }
            return new FluidStack(FluidRegistry.WATER, drainAmount);
        }

        public FluidHandler(@NotNull ItemStack container) {
            Intrinsics.checkParameterIsNotNull(container, "container");
            this.container = container;
        }
    }
}

