/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.passive.EntityElle;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.BloodStorage;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.VampireCreatureTrait;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemGlassGoblet
extends Item
implements BloodStorage {
    private final boolean isFull;

    public ItemGlassGoblet(boolean isFull) {
        this.isFull = isFull;
        this.func_77625_d(1);
        if (!isFull) {
            this.func_77637_a(WitcheryGeneralItems.TAB);
        }
    }

    private static boolean tryConvertToVampire(EntityLiving target, int blood, EntityPlayer player, ItemStack stack) {
        PotionEffect effect = target.func_70660_b(WitcheryPotionEffects.PARALYSED);
        if (effect != null && effect.func_76458_c() >= 5) {
            if (blood == 0) {
                if (ItemGlassGoblet.isCoffinNear(player.field_70170_p, (Entity)target)) {
                    ItemGlassGoblet.convertToVampire(target);
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    VampireCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.VAMPIRE);
                    if (transformation.getLevel() == 9 && transformation.getCanLevelUp() && ItemTaglockKit.getBoundCreatureID(stack, 0).equals(player.func_110124_au()) && transformation.levelUp()) {
                        playerEx.markChanged();
                    }
                    return true;
                }
                player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".needs_coffin", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            } else {
                player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".victim_has_blood", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        } else {
            player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".victim_not_transfixed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
        ITextComponent bloodName;
        super.func_77624_a(stack, worldIn, list2, advTooltips);
        if (this.isFull && (bloodName = this.getBloodName(stack, 0)) != null) {
            list2.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tip"), (Object[])new Object[]{bloodName.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)).func_150254_d()}));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isFull ? EnumAction.DRINK : EnumAction.BLOCK;
    }

    private boolean isElleNear(World world, BlockPos pos) {
        return world.func_72872_a(EntityElle.class, new AxisAlignedBB(0.5 + (double)pos.func_177958_n() - 32.0, (double)pos.func_177956_o() - 32.0, 0.5 + (double)pos.func_177952_p() - 32.0, 0.5 + (double)pos.func_177958_n() + 32.0, (double)pos.func_177956_o() + 32.0, 0.5 + (double)pos.func_177956_o() + 32.0)).size() > 0;
    }

    private static boolean isRitual(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        TileEntitySkull skull = (TileEntitySkull)world.func_175625_s(pos);
        if (skull == null || skull.func_145904_a() != 0) {
            return false;
        }
        Block string = Blocks.field_150473_bD;
        boolean b = world.func_180495_p(pos.func_177964_d(3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(1, 0, -3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(2, 0, -3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(2, 0, -2)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, -2)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, -1)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177965_g(3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, 1)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, 2)).func_177230_c() == string;
        if (!(b &= world.func_180495_p(pos.func_177982_a(2, 0, 2)).func_177230_c() == string)) {
            return false;
        }
        b = world.func_180495_p(pos.func_177982_a(2, 0, 3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(1, 0, 3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177970_e(3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(-1, 0, 3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(-2, 0, 3)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(-2, 0, 2)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(-3, 0, 2)).func_177230_c() == string;
        b &= world.func_180495_p(pos.func_177982_a(-3, 0, 1)).func_177230_c() == string;
        if (!(b &= world.func_180495_p(pos.func_177985_f(3)).func_177230_c() == string)) {
            return false;
        }
        Block candle = Blocks.field_150478_aa;
        b = world.func_180495_p(pos.func_177982_a(-3, 0, 3)).func_177230_c() == candle;
        b &= world.func_180495_p(pos.func_177982_a(-3, 0, -3)).func_177230_c() == candle;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, 3)).func_177230_c() == candle;
        b &= world.func_180495_p(pos.func_177982_a(3, 0, -3)).func_177230_c() == candle;
        BlockRedstoneWire redstone = Blocks.field_150488_af;
        b &= world.func_180495_p(pos.func_177976_e()).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177974_f()).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177968_d()).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177978_c()).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177982_a(-1, 0, -1)).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177982_a(-1, 0, 1)).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177982_a(1, 0, -1)).func_177230_c() == redstone;
        b &= world.func_180495_p(pos.func_177982_a(1, 0, 1)).func_177230_c() == redstone;
        for (int dx = pos.func_177958_n() - 3; dx <= pos.func_177958_n() + 3; ++dx) {
            for (int dz = pos.func_177952_p() - 3; dz <= pos.func_177952_p() + 3; ++dz) {
                BlockPos p = new BlockPos(dx, pos.func_177956_o(), dz);
                if (!world.func_180495_p(p.func_177977_b()).func_185915_l()) {
                    return false;
                }
                if (!world.func_175623_d(p.func_177984_a())) {
                    return false;
                }
                if (world.func_175623_d(p.func_177981_b(2))) continue;
                return false;
            }
        }
        return b;
    }

    public static void handleCreatureDeath(World world, EntityPlayer player, EntityLivingBase victim) {
        if (victim instanceof EntityChicken && player.func_184614_ca().func_77973_b() == WitcheryGeneralItems.BOLINE) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGlassGoblet)) continue;
                int x = MathHelper.func_76128_c((double)victim.field_70165_t);
                int y = MathHelper.func_76128_c((double)victim.field_70163_u);
                int z = MathHelper.func_76128_c((double)victim.field_70161_v);
                for (int dx = x - 1; dx <= x + 1; ++dx) {
                    for (int dz = z - 1; dz <= z + 1; ++dz) {
                        for (int dy = y - 1; dy <= y + 1; ++dy) {
                            if (!ItemGlassGoblet.isRitual(world, new BlockPos(dx, dy, dz))) continue;
                            player.field_71071_by.func_70299_a(i, ((ItemGlassGoblet)stack.func_77973_b()).getNewGoblet(stack, (Entity)victim));
                            world.func_184148_a(null, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O * 0.85f), victim.field_70161_v, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O * 0.85f), victim.field_70161_v, 0.5f, 0.5f, EnumParticleTypes.REDSTONE), world, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O * 0.85f), victim.field_70161_v);
                            return;
                        }
                    }
                }
                break;
            }
        }
    }

    public static void onEntityInteract(World world, EntityPlayer player, ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && ((ItemGlassGoblet)stack.func_77973_b()).isFull && !CreatureUtil.isWerewolf(event.getTarget(), true) && !CreatureUtil.isVampire(event.getTarget())) {
            EntityVillageGuard entity2;
            boolean success = false;
            if (event.getTarget() instanceof EntityVillager) {
                EntityVillager entity = (EntityVillager)event.getTarget();
                if (ItemGlassGoblet.tryConvertToVampire((EntityLiving)entity, WitcheryDataExtensions.VILLAGER.get(entity).getBlood(), player, stack)) {
                    success = true;
                }
            } else if (event.getTarget() instanceof EntityVillageGuard && ItemGlassGoblet.tryConvertToVampire((EntityLiving)(entity2 = (EntityVillageGuard)event.getTarget()), entity2.getBlood(), player, stack)) {
                success = true;
            }
            if (success) {
                world.func_184133_a(null, event.getTarget().func_180425_c(), WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, event.getTarget().field_70130_N, event.getTarget().field_70131_O, EnumParticleTypes.REDSTONE), event.getTarget());
                player.func_184611_a(event.getHand(), ((ItemGlassGoblet)stack.func_77973_b()).getNewGoblet(stack, null));
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            event.setCanceled(true);
        }
    }

    public ItemStack getNewGoblet(ItemStack oldStack, Entity entity) {
        if (entity != null) {
            return this.updateBloodOwner(new ItemStack((Item)WitcheryGeneralItems.FULL_GLASS_GOBLET, oldStack.func_190916_E()), entity, 0);
        }
        return new ItemStack((Item)WitcheryGeneralItems.GLASS_GOBLET, oldStack.func_190916_E());
    }

    private static boolean isCoffinNear(World world, Entity entity) {
        BlockPos entityPosition = entity.func_180425_c();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)entityPosition.func_177982_a(-4, -4, -4), (BlockPos)entityPosition.func_177982_a(4, 4, 4))) {
            if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockCoffin)) continue;
            return true;
        }
        return false;
    }

    private static void convertToVampire(EntityLiving entity) {
        EntityVampire vampire = new EntityVampire(entity.field_70170_p);
        vampire.func_110163_bv();
        vampire.func_82149_j((Entity)entity);
        vampire.func_180482_a(entity.field_70170_p.func_175649_E(entity.func_180425_c()), null);
        entity.field_70170_p.func_72900_e((Entity)entity);
        entity.field_70170_p.func_72838_d((Entity)vampire);
        entity.field_70170_p.func_175718_b(1017, vampire.func_180425_c(), 0);
    }

    private boolean hasChickenBlood(ItemStack stack) {
        return this.getEntityType(stack, 0) == EntityChicken.class;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            VampireCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.VAMPIRE);
            if (!this.isFull) {
                if (transformation.getLevel() >= 9) {
                    if (transformation.decreaseBlood(125, true)) {
                        playerEx.markChanged();
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O * 0.85f), player.field_70161_v, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entity.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O * 0.85f), player.field_70161_v, 0.8f, 0.3f, EnumParticleTypes.REDSTONE), world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O * 0.85f), player.field_70161_v);
                        return this.getNewGoblet(stack, (Entity)player);
                    }
                    player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".needs_blood", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                } else if (playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) {
                    player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".not_master", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                } else {
                    player.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".failed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187739_dZ, player.func_184176_by(), 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (!playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE) && !this.hasChickenBlood(stack)) {
                    if (!WitcheryConfigOptions.allowVampireWolfHybrids && playerEx.isTransformation(WitcheryCreatureTraits.WEREWOLF)) {
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.hybridsnotallow", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        return stack;
                    }
                    if (transformation.getBloodPower() == 0) {
                        transformation.setLevel(1);
                        playerEx.markChanged();
                        player.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.8f, 1.5f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                    } else if (CreatureUtil.isInSunlight((EntityLivingBase)player)) {
                        player.func_70015_d(5);
                    } else {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 600));
                        player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 600, 1));
                    }
                }
                return this.getNewGoblet(stack, null);
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult mop = OtherwhereInfusion.raytraceBlocks(world, player, true, 2.0);
        ItemStack stack = player.func_184586_b(hand);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_178782_a()).func_177230_c() == Blocks.field_150465_bP) {
            TileEntitySkull skull = (TileEntitySkull)world.func_175625_s(mop.func_178782_a());
            if (!world.field_72995_K && skull != null && skull.func_145904_a() == 0) {
                if (this.hasChickenBlood(stack) && world.field_73011_w.func_76567_e() && ItemGlassGoblet.isRitual(world, mop.func_178782_a()) && world.func_175678_i(mop.func_178782_a()) && !world.func_72935_r() && WitcheryConfigOptions.allowVampireRitual && !this.isElleNear(world, mop.func_178782_a().func_177977_b())) {
                    stack = this.getNewGoblet(stack, null);
                    player.func_184611_a(hand, stack);
                    EntityLightningBolt bolt = new EntityLightningBolt(world, 0.5 + (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o() + 0.05, 0.5 + (double)mop.func_178782_a().func_177952_p(), true);
                    world.func_175698_g(mop.func_178782_a());
                    world.func_72942_c((Entity)bolt);
                    EntityElle elle = WitcheryEntities.ELLE.create(world);
                    if (elle != null) {
                        elle.func_110163_bv();
                        elle.func_70080_a(0.5 + (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o() + 1.05, 0.5 + (double)mop.func_178782_a().func_177952_p(), 0.0f, 0.0f);
                        elle.func_184754_b(player.func_110124_au());
                        elle.func_70903_f(true);
                        world.func_72960_a((Entity)elle, (byte)7);
                        world.func_184148_a(null, 0.5 + (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o() + 1.05, 0.5 + (double)mop.func_178782_a().func_177952_p(), WitcherySounds.ENTITY_LILITH_AMBIENT, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o() + 1.05, 0.5 + (double)mop.func_178782_a().func_177952_p(), 1.0f, 2.0f, EnumParticleTypes.REDSTONE), world, mop.func_178782_a().func_177984_a());
                        player.func_145747_a(new TextComponentTranslation("entity.witchery.lilith.quest.start", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        world.func_72838_d((Entity)elle);
                    }
                } else {
                    player.func_146105_b(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.func_77658_a() + ".something_wrong", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

