/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelGoblinClothes;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemGoblinClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesLegs;

    public ItemGoblinClothes(EntityEquipmentSlot armorSlot) {
        super(armorSlot == EntityEquipmentSlot.HEAD ? ItemArmor.ArmorMaterial.IRON : ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.func_77656_e(armorSlot == EntityEquipmentSlot.HEAD ? ItemArmor.ArmorMaterial.DIAMOND.func_78046_a(armorSlot) : ItemArmor.ArmorMaterial.IRON.func_78046_a(armorSlot));
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static boolean isQuiverWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        return !currentArmor.func_190926_b() && currentArmor.func_77973_b() == WitcheryEquipmentItems.MOGS_QUIVER;
    }

    private static boolean isHelmWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return !currentArmor.func_190926_b() && currentArmor.func_77973_b() == WitcheryEquipmentItems.KOBOLDITE_HELM;
    }

    public static boolean isBeltWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        return !currentArmor.func_190926_b() && currentArmor.func_77973_b() == WitcheryEquipmentItems.GULGS_GURDLE;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82737_E() % 100L == 0L) {
            double R = 8.0;
            AxisAlignedBB bb = new AxisAlignedBB(player.field_70165_t - R, player.field_70163_u - R, player.field_70161_v - R, player.field_70165_t + R, player.field_70163_u + R, player.field_70161_v + R);
            List players = world.func_72872_a(EntityPlayer.class, bb);
            for (EntityPlayer otherPlayer : players) {
                if (player == otherPlayer || (!ItemGoblinClothes.isQuiverWorn(player) || !ItemGoblinClothes.isBeltWorn(otherPlayer)) && (!ItemGoblinClothes.isQuiverWorn(otherPlayer) || !ItemGoblinClothes.isBeltWorn(player))) continue;
                if (player.func_70644_a(MobEffects.field_76429_m)) {
                    player.func_184589_d(MobEffects.field_76429_m);
                }
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
                return;
            }
        }
        if (!world.field_72995_K && ItemGoblinClothes.isHelmWorn(player) && world.func_82737_E() % 5L == 1L) {
            double R2 = 16.0;
            AxisAlignedBB bb2 = new AxisAlignedBB(player.field_70165_t - R2, player.field_70163_u - R2, player.field_70161_v - R2, player.field_70165_t + R2, player.field_70163_u + R2, player.field_70161_v + R2);
            List entities = world.func_72872_a(EntityLivingBase.class, bb2);
            for (EntityLivingBase otherPlayer2 : entities) {
                if (player == otherPlayer2 || !this.shouldAffectTarget((EntityLivingBase)player, otherPlayer2)) continue;
                if (otherPlayer2 instanceof EntityPlayer) {
                    double yawRadians = Math.atan2(otherPlayer2.field_70161_v - player.field_70161_v, otherPlayer2.field_70165_t - player.field_70161_v);
                    double yaw = Math.toDegrees(yawRadians) + 180.0;
                    float rev = ((float)yaw + 90.0f) % 360.0f;
                    if (otherPlayer2 instanceof EntityPlayerMP) {
                        SPacketPlayerPosLook packet2 = new SPacketPlayerPosLook(otherPlayer2.field_70165_t, otherPlayer2.field_70163_u, otherPlayer2.field_70161_v, rev, otherPlayer2.field_70125_A, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), ((EntityPlayerMP)otherPlayer2).field_71135_a.field_184363_z);
                        ((EntityPlayerMP)otherPlayer2).field_71135_a.func_147359_a((Packet)packet2);
                    }
                    if (otherPlayer2.func_70644_a(MobEffects.field_76438_s)) continue;
                    otherPlayer2.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100, 0));
                    continue;
                }
                if (otherPlayer2.func_70644_a(MobEffects.field_76437_t)) continue;
                otherPlayer2.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
            }
        }
    }

    private boolean shouldAffectTarget(EntityLivingBase player, EntityLivingBase target) {
        ItemStack itemstack = target.func_184582_a(EntityEquipmentSlot.FEET);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3d vec3 = target.func_70676_i(1.0f).func_72432_b();
        Vec3d vec4 = new Vec3d(player.field_70165_t - target.field_70165_t, player.func_174813_aQ().field_72338_b + (double)(player.field_70131_O / 2.0f) - (target.field_70163_u + (double)target.func_70047_e()), player.field_70161_v - target.field_70161_v);
        double d0 = vec4.func_72433_c();
        double d2 = vec3.func_72430_b(vec4 = vec4.func_72432_b());
        return d2 > 1.0 - 0.025 / d0 && target.func_70685_l((Entity)player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77973_b() != WitcheryEquipmentItems.KOBOLDITE_HELM;
    }

    public boolean func_82816_b_(ItemStack stack) {
        return false;
    }

    public int func_82814_b(ItemStack stack) {
        if (!this.func_82816_b_(stack)) {
            return 0xFFFFFF;
        }
        return super.func_82814_b(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return this.field_77881_a != EntityEquipmentSlot.HEAD ? EnumRarity.EPIC : EnumRarity.RARE;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        if (!stack.func_190926_b()) {
            String localText = WitcheryResurrected.translateSplit(this.func_77658_a() + ".tip", new Object[0]);
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type2) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (slot == EntityEquipmentSlot.HEAD) {
            return "witchery:textures/entities/goblinclothes_head" + (type2 == null ? "" : "_overlay") + ".png";
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return "witchery:textures/entities/goblinclothes_legs" + (type2 == null ? "" : "_overlay") + ".png";
        }
        return "witchery:textures/entities/goblinclothes" + (type2 == null ? "" : "_overlay") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelGoblinClothes(0.61f);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelGoblinClothes(0.0f);
        }
        return armorSlot == EntityEquipmentSlot.LEGS ? this.modelClothesLegs : this.modelClothesChest;
    }
}

