/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelHunterClothes;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.traits.Invisible;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemHunterClothes
extends ItemArmor
implements ISpecialArmor,
Invisible {
    private final boolean silvered;
    private final boolean garlicked;
    @SideOnly(value=Side.CLIENT)
    private ModelHunterClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelHunterClothes modelClothesLegs;

    public ItemHunterClothes(EntityEquipmentSlot armorSlot) {
        this(armorSlot, false);
    }

    public ItemHunterClothes(EntityEquipmentSlot armorSlot, boolean silvered) {
        this(armorSlot, silvered, false);
    }

    public ItemHunterClothes(EntityEquipmentSlot armorSlot, boolean silvered, boolean garlicked) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.silvered = silvered;
        this.garlicked = garlicked;
        this.func_77656_e(ItemArmor.ArmorMaterial.IRON.func_78046_a(armorSlot));
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static boolean isFullSetWorn(EntityLivingBase entity, boolean silvered) {
        for (int i = 2; i <= 5; ++i) {
            ItemStack item = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (!(item.func_77973_b() instanceof ItemHunterClothes)) {
                return false;
            }
            ItemHunterClothes clothes = (ItemHunterClothes)item.func_77973_b();
            if (!silvered || clothes.silvered) continue;
            return false;
        }
        return true;
    }

    public static boolean isMagicalProtectionActive(EntityLivingBase entity) {
        return entity == null || !ItemHunterClothes.isFullSetWorn(entity, false) || entity.field_70170_p == null || !(entity.field_70170_p.field_73012_v.nextDouble() < 0.25);
    }

    public static boolean isCurseProtectionActive(EntityLivingBase entity) {
        return entity != null && ItemHunterClothes.isFullSetWorn(entity, false) && entity.field_70170_p != null && entity.field_70170_p.field_73012_v.nextDouble() < 0.9;
    }

    public static boolean isWolfProtectionActive(EntityLivingBase entity) {
        return entity != null && ItemHunterClothes.isFullSetWorn(entity, true);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type2) {
        if (!stack.func_190926_b() && this.field_77881_a == EntityEquipmentSlot.LEGS) {
            return "witchery:textures/entities/hunterclothes2" + (type2 == null ? "" : "_overlay") + ".png";
        }
        if (!stack.func_190926_b()) {
            return "witchery:textures/entities/hunterclothes" + (type2 == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && player.field_70173_aa % 20 == 2) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            if (this.silvered && playerEx.isTransformation(WitcheryCreatureTraits.WEREWOLF) || this.garlicked && playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) {
                player.func_70097_a(DamageSource.field_76372_a, 1.0f);
            }
        }
    }

    public int func_82814_b(ItemStack stack) {
        if (!this.func_82816_b_(stack)) {
            return super.func_82814_b(stack);
        }
        int color2 = super.func_82814_b(stack);
        if (color2 == 10511680) {
            color2 = stack.func_77973_b() == WitcheryEquipmentItems.HUNTER_BOOTS ? 1642763 : (stack.func_77973_b() == WitcheryEquipmentItems.HUNTER_LEGS ? 4798251 : 4139550);
        }
        return color2;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelHunterClothes(0.4f);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelHunterClothes(0.01f);
        }
        return armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.FEET ? this.modelClothesChest : this.modelClothesLegs;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translateSplit(this.func_77658_a() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.silvered && source != null && CreatureUtil.isWerewolf(source.func_76346_g())) {
            source.func_76346_g().func_70097_a(DamageSource.field_76372_a, 1.0f);
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b * 2.5 / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        }
        if (this.garlicked && source != null && CreatureUtil.isVampire(source.func_76346_g())) {
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b * 2.5 / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.silvered && source != null && CreatureUtil.isWerewolf(source.func_76346_g())) {
            return;
        }
        if (this.garlicked && source != null && CreatureUtil.isVampire(source.func_76346_g())) {
            return;
        }
        stack.func_77972_a(damage, entity);
    }
}

