/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.transformation.WerewolfCreatureTrait;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class ItemMoonCharm
extends Item {
    public ItemMoonCharm() {
        this.func_77625_d(1);
        this.func_77656_e(49);
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static boolean isWolfsbaneInactive(EntityPlayer player, PlayerExtendedData playerEx) {
        PotionEffect potion = player.func_70660_b(WitcheryPotionEffects.WOLFSBANE);
        if (potion == null) {
            return true;
        }
        int amplifier = 1 + Math.max(0, potion.func_76458_c() * 3 - 1);
        return amplifier < playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tip"), (Object[])new Object[0]));
    }

    public boolean func_82789_a(ItemStack item, ItemStack otherMaterial) {
        return otherMaterial.func_77969_a(new ItemStack(Items.field_151043_k));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 60;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int countdown) {
        EntityPlayer player;
        PlayerExtendedData playerEx;
        WerewolfCreatureTrait transformation;
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && countdown == Math.max(((transformation = (playerEx = WitcheryUtils.getExtension(player = (EntityPlayer)entity)).getTransformation(WitcheryCreatureTraits.WEREWOLF)).getLevel() - 1) * 4, 1)) {
            if (ItemMoonCharm.isWolfsbaneInactive(player, playerEx) && ShapeShift.INSTANCE.canControlTransform(transformation)) {
                CreatureForm form = player.func_70093_af() && ShapeShift.INSTANCE.isWolfmanAllowed(transformation) ? WitcheryAlternateForms.WOLFMAN : WitcheryAlternateForms.WOLF;
                CreatureForm currentForm = playerEx.getCurrentForm();
                if (currentForm == null || CreatureFormStatManager.INSTANCE.getStats(currentForm).canHowl()) {
                    playerEx.setCurrentForm(currentForm == form ? null : form);
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187646_bt, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryUtils.addNewParticles(player.field_70170_p, EnumParticleTypes.EXPLOSION_NORMAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 30, 1.5, 1.5);
                } else {
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryUtils.addNewParticles(player.field_70170_p, EnumParticleTypes.SMOKE_NORMAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 0.5, 0.5);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.field_189107_dL, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(player.field_70170_p, EnumParticleTypes.SMOKE_NORMAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 0.5, 0.5);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

