/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import javax.vecmath.Vector2f;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockPlacedItem;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.StrokeSet;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketSpellPrepared;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.resources.SymbolEffectManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JH\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0016J \u0010$\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0016\u00a8\u0006&"}, d2={"Lnet/msrandom/witchery/item/ItemMysticBranch;", "Lnet/minecraft/item/Item;", "()V", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "stack", "Lnet/minecraft/item/ItemStack;", "getMaxItemUseDuration", "", "getRarity", "Lnet/minecraft/item/EnumRarity;", "hasEffect", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "pos", "Lnet/minecraft/util/math/BlockPos;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onPlayerStoppedUsing", "", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "countdown", "onUsingTick", "Companion", "WitcheryResurrected"})
public final class ItemMysticBranch
extends Item {
    private static final int MAX_STROKES = 15;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public EnumRarity func_77613_e(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return EnumRarity.RARE;
    }

    @NotNull
    public EnumAction func_77661_b(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return EnumAction.BLOCK;
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 36000;
    }

    public boolean func_77636_d(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return true;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound playerData = player.getEntityData();
        playerData.func_82580_o("WitcherySpellEffect");
        playerData.func_82580_o("WitcherySpellEffectEnhanced");
        playerData.func_74773_a("Strokes", new byte[0]);
        playerData.func_74776_a("StartPitch", player.field_70125_A);
        playerData.func_74776_a("StartYaw", player.field_70759_as);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        Intrinsics.checkParameterIsNotNull(facing, "facing");
        IBlockState iBlockState = world.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(pos)");
        if (iBlockState.func_177230_c() == WitcheryBlocks.ALTAR && facing == EnumFacing.UP && world.func_175623_d(pos.func_177984_a())) {
            BlockPlacedItem.placeInWorld(hand, player, world, pos.func_177984_a());
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        EnumActionResult enumActionResult = super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        Intrinsics.checkExpressionValueIsNotNull(enumActionResult, "super.onItemUse(player, \u2026facing, hitX, hitY, hitZ)");
        return enumActionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase entity, int countdown) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (entity.field_70170_p.field_72995_K) {
            NBTTagCompound playerData = entity.getEntityData();
            float yawDiff = playerData.func_74760_g("StartYaw") - entity.field_70759_as;
            float pitchDiff = playerData.func_74760_g("StartPitch") - entity.field_70125_A;
            byte[] byArray = playerData.func_74770_j("Strokes");
            Intrinsics.checkExpressionValueIsNotNull(byArray, "playerData.getByteArray(\"Strokes\")");
            StrokeArray strokes = new StrokeArray(byArray);
            int strokesStart = strokes.getSize();
            if (SymbolEffectManager.INSTANCE.getEffect(strokes) == null && strokesStart <= 15) {
                double d;
                double d2 = pitchDiff;
                double d3 = yawDiff;
                boolean bl = false;
                double angle = Math.atan2(d2, d3);
                double bearing = angle + 4.71238898038469;
                if (bearing < 0.0) {
                    bearing += Math.PI * 2;
                }
                if (bearing > Math.PI * 2) {
                    bearing -= Math.PI * 2;
                }
                Vector2f movement = new Vector2f(yawDiff, pitchDiff);
                double d4 = bearing * (double)2;
                double d5 = 9.9;
                double d6 = 7.0;
                boolean bl2 = false;
                d4 = d = Math.sin(d4);
                bl2 = false;
                d = Math.abs(d4);
                double lengthRequired = MathHelper.func_151238_b((double)d6, (double)d5, (double)d);
                if ((double)movement.length() > lengthRequired) {
                    byte[] tempArray = new byte[strokesStart + 1];
                    System.arraycopy(strokes.getArray(), 0, tempArray, 0, strokesStart);
                    tempArray[strokesStart] = (byte)BranchStroke.Companion.byAngle(angle).ordinal();
                    strokes = new StrokeArray(tempArray);
                }
                if (strokes.getSize() > strokesStart) {
                    playerData.func_74773_a("Strokes", strokes.getArray());
                    playerData.func_74776_a("StartPitch", entity.field_70125_A);
                    playerData.func_74776_a("StartYaw", entity.field_70759_as);
                    StrokeSet effect = SymbolEffectManager.INSTANCE.getEffect(strokes);
                    if (effect != null) {
                        WitcheryNetworkChannel.sendToServer(new PacketSpellPrepared(effect));
                        ResourceLocation resourceLocation = (ResourceLocation)SymbolEffect.REGISTRY.getKey(effect.getResult());
                        if (resourceLocation != null) {
                            ResourceLocation resourceLocation2 = resourceLocation;
                            bl2 = false;
                            boolean bl3 = false;
                            ResourceLocation it = resourceLocation2;
                            boolean bl4 = false;
                            playerData.func_74778_a("WitcherySpellEffect", it.toString());
                        }
                        playerData.func_74768_a("WitcherySpellEffectEnhanced", effect.getLevel());
                        playerData.func_74768_a("SpellPreparedTime", entity.field_70173_aa);
                    }
                }
            }
        }
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entity, int countdown) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (entity instanceof EntityPlayer) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)entity);
            NBTTagCompound playerData = ((EntityPlayer)entity).getEntityData();
            if (!world.field_72995_K) {
                ResourceLocation effectID = new ResourceLocation(playerData.func_74779_i("WitcherySpellEffect"));
                int level = playerData.func_74762_e("WitcherySpellEffectEnhanced");
                playerData.func_82580_o("WitcherySpellEffect");
                playerData.func_82580_o("WitcherySpellEffectEnhanced");
                SymbolEffect effect = (SymbolEffect)SymbolEffect.REGISTRY.get(effectID);
                NBTTagCompound nbtPerm = ((EntityPlayer)entity).getEntityData();
                if (effect != null) {
                    if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || playerEx.infusionPower.getCurrentPower() > 0) {
                        if (effect.hasValidInfusion((EntityPlayer)entity, playerEx.infusionPower.getInfusionType())) {
                            EntityPlayer entityPlayer = (EntityPlayer)entity;
                            NBTTagCompound nBTTagCompound = nbtPerm;
                            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "nbtPerm");
                            if (effect.hasValidKnowledge(entityPlayer, nBTTagCompound)) {
                                long ticksRemaining = effect.cooldownRemaining(nbtPerm);
                                if (ticksRemaining <= 0L || ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                                    if (level > 1) {
                                        int newLevel = 1;
                                        if (entity.func_70644_a(WitcheryPotionEffects.WORSHIP)) {
                                            PotionEffect potion;
                                            PotionEffect potionEffect = potion = entity.func_70660_b(WitcheryPotionEffects.WORSHIP);
                                            if (potionEffect == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            if (level <= potionEffect.func_76458_c() + 2) {
                                                newLevel = level;
                                            }
                                        }
                                        level = newLevel;
                                    }
                                    if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || playerEx.infusionPower.getCurrentPower() >= effect.getChargeCost((EntityPlayer)entity, level)) {
                                        effect.perform(world, (EntityPlayer)entity, level);
                                        if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                                            playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), playerEx.infusionPower.getCurrentPower() - effect.getChargeCost((EntityPlayer)entity, level), playerEx.infusionPower.getMaxPower());
                                            Infusion.syncPlayer(world, (EntityPlayer)entity);
                                        }
                                    } else {
                                        ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".insufficient_infusion_power", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                                        world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                    }
                                } else {
                                    ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".effect_not_ready", new Object[]{ticksRemaining / (long)20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                                    world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                }
                            } else {
                                ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".unknown_effect", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                                world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            }
                        } else {
                            ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".weak_infusion", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                            world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        }
                    } else {
                        ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".no_infusion", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                        world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                } else {
                    ((EntityPlayer)entity).func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".unknown_symbol", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    world.func_184133_a(null, ((EntityPlayer)entity).func_180425_c(), SoundEvents.field_187688_dI, ((EntityPlayer)entity).func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                playerData.func_82580_o("Strokes");
                playerData.func_82580_o("StartYaw");
                playerData.func_82580_o("StartPitch");
            }
        }
    }

    public ItemMysticBranch() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(WitcheryGeneralItems.TAB);
        this.func_185043_a(new ResourceLocation("witchery", "using"), 1.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/item/ItemMysticBranch$Companion;", "", "()V", "MAX_STROKES", "", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

