/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntitySpectralFamiliar;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class ItemPolynesiaCharm
extends Item {
    private final boolean charmDemons;

    public ItemPolynesiaCharm(boolean charmDemons) {
        this.charmDemons = charmDemons;
        this.func_77637_a(WitcheryGeneralItems.TAB);
        this.func_77656_e(50);
        this.func_77625_d(1);
    }

    public static boolean hasStockInventory(EntityLiving entity) {
        if (entity == null) {
            return false;
        }
        NBTTagCompound nbtTag = entity.getEntityData();
        return nbtTag.func_74764_b("WitcheryShopStock");
    }

    public static void setEmptyStockInventory(World world, EntityLiving entity) {
        if (entity != null && !world.field_72995_K) {
            NBTTagCompound nbtTag = entity.getEntityData();
            nbtTag.func_74782_a("WitcheryShopStock", (NBTBase)new NBTTagCompound());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            EntityLiving living2;
            boolean success = false;
            RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, player, true, 5.0);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g instanceof EntityLiving && ((living2 = (EntityLiving)mop.field_72308_g) instanceof EntityAnimal || living2 instanceof EntityAmbientCreature || living2 instanceof EntitySpider || living2 instanceof EntityWaterMob || living2 instanceof EntityCreeper && WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player) || living2.func_70662_br() && WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) && !(living2 instanceof EntitySpectralFamiliar) && !(living2 instanceof EntityCovenWitch) && !(living2 instanceof EntityImp) && living2.func_70089_S() && !living2.func_70631_g_() && living2.func_70638_az() == null && (!(living2 instanceof EntityBat) || this.canBatDrop(living2))) {
                AnimalMerchant merchant = new AnimalMerchant(living2);
                merchant.playIntro();
                merchant.func_70932_a_(player);
                player.func_180472_a((IMerchant)merchant);
                success = true;
            }
            if (!success || mop.field_72308_g instanceof EntityDemon) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            } else {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private boolean canBatDrop(EntityLiving living2) {
        NBTTagCompound nbtBat = living2.getEntityData();
        return !nbtBat.func_74764_b("WitcheryNoDrops") || !nbtBat.func_74767_n("WitcheryNoDrops");
    }

    public boolean canCharmDemons() {
        return this.charmDemons;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World worldIn, List<String> list2, ITooltipFlag par4) {
        list2.addAll(Arrays.asList(I18n.func_135052_a((String)(this.func_77658_a() + ".tip"), (Object[])new Object[0]).split("\\n")));
    }

    private static class AnimalMerchant
    implements IMerchant {
        static final String STOCKS_KEY = "WitcheryShopStock";
        private final EntityLiving animal;
        private EntityPlayer customer;
        private MerchantRecipeList currentList = null;

        public AnimalMerchant(EntityLiving animal) {
            this.animal = animal;
        }

        private static void populateList(EntityLiving animal, MerchantRecipeList finalList) {
            Random r = animal.field_70170_p.field_73012_v;
            MerchantRecipeList list2 = new MerchantRecipeList();
            ItemStack[] stacks = new ItemStack[]{new ItemStack(WitcheryIngredientItems.MANDRAKE_ROOT, 3), new ItemStack(WitcheryIngredientItems.BELLADONNA, 3), new ItemStack(WitcheryIngredientItems.ARTICHOKE, 3), new ItemStack(Blocks.field_150345_g, 4, 0), new ItemStack(Blocks.field_150345_g, 4, 1), new ItemStack(Blocks.field_150345_g, 4, 2), new ItemStack(Blocks.field_150345_g, 4, 3), new ItemStack((Block)Blocks.field_150436_aH, 2), new ItemStack((Block)Blocks.field_150434_aF, 2), new ItemStack(Items.field_151074_bl, 5), new ItemStack(Items.field_151042_j, 2), new ItemStack(Items.field_151103_aS, 4), new ItemStack(Items.field_151145_ak, 5), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, 2), new ItemStack(Items.field_151174_bG, 5), new ItemStack(Items.field_151170_bI, 2), new ItemStack(Items.field_151172_bF, 5), new ItemStack(Items.field_151119_aD, 10)};
            ArrayList<ItemStack> currencies = new ArrayList<ItemStack>();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(stacks[r.nextInt(stacks.length)]);
            if (animal.field_70170_p.field_73012_v.nextDouble() < 0.03) {
                items.add(new ItemStack(WitcheryIngredientItems.TREEFYD_SEEDS));
            }
            if (animal instanceof EntityPig) {
                currencies.add(new ItemStack(Items.field_151172_bF));
                currencies.add(new ItemStack(Items.field_151034_e));
                currencies.add(new ItemStack(Items.field_151174_bG));
                items.add(new ItemStack((Block)Blocks.field_150337_Q, 5));
                items.add(new ItemStack((Block)Blocks.field_150338_P, 5));
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(Items.field_151166_bC, 1));
                }
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.field_151045_i, 1));
                }
            } else if (animal instanceof EntityHorse) {
                currencies.add(new ItemStack(Items.field_151172_bF));
                currencies.add(new ItemStack(Items.field_151034_e));
                currencies.add(new ItemStack(Items.field_151015_O));
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.field_151141_av, 1));
                }
            } else if (animal instanceof EntityWolf) {
                currencies.add(new ItemStack(Items.field_151082_bd));
                currencies.add(new ItemStack(Items.field_151147_al));
                currencies.add(new ItemStack(Items.field_151076_bf));
                items.add(new ItemStack(Items.field_151103_aS, 5));
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(Items.field_151166_bC, 1));
                }
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.field_151045_i, 1));
                }
            } else if (animal instanceof EntityOcelot) {
                currencies.add(new ItemStack(Items.field_151117_aB));
                currencies.add(new ItemStack(Items.field_151115_aP));
            } else if (animal instanceof EntityMooshroom) {
                currencies.add(new ItemStack((Block)Blocks.field_150337_Q));
                currencies.add(new ItemStack((Block)Blocks.field_150338_P));
            } else if (animal instanceof EntityCow) {
                currencies.add(new ItemStack(Items.field_151015_O));
            } else if (animal instanceof EntityChicken) {
                currencies.add(new ItemStack(Items.field_151014_N));
                items.add(new ItemStack(Items.field_151008_G, 10));
                items.add(new ItemStack(Items.field_151110_aK, 5));
            } else if (animal instanceof EntitySheep) {
                currencies.add(new ItemStack(Items.field_151015_O));
            } else if (animal instanceof EntitySquid) {
                currencies.add(new ItemStack(Items.field_151115_aP));
                items.add(new ItemStack(Items.field_151100_aR, 10, EnumDyeColor.BLACK.func_176767_b()));
            } else if (animal instanceof EntityBat) {
                currencies.add(new ItemStack(Items.field_151014_N));
                currencies.add(new ItemStack(Items.field_151015_O));
                currencies.add(new ItemStack(Items.field_151082_bd));
                currencies.add(new ItemStack(Items.field_151147_al));
                items.add(new ItemStack(WitcheryIngredientItems.BAT_WOOL, 5));
            } else if (animal instanceof EntitySpider) {
                currencies.add(new ItemStack(Items.field_151082_bd));
                currencies.add(new ItemStack(Items.field_151147_al));
                currencies.add(new ItemStack(Items.field_151076_bf));
                currencies.add(new ItemStack(Items.field_151115_aP));
                items.add(new ItemStack(Items.field_151007_F, 8));
                items.add(new ItemStack(WitcheryIngredientItems.WEB, 4));
            } else if (animal instanceof EntityCreeper) {
                currencies.add(new ItemStack(Items.field_151016_H));
                currencies.add(new ItemStack(Items.field_151115_aP));
                if (r.nextDouble() < 0.05) {
                    items.add(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, 2));
                }
                if (animal.field_70170_p.field_73012_v.nextDouble() < 0.1) {
                    items.add(new ItemStack(WitcheryIngredientItems.TREEFYD_SEEDS));
                }
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(WitcheryIngredientItems.CREEPER_HEART, 1));
                }
            } else if (animal.func_70662_br()) {
                currencies.add(new ItemStack(Items.field_151103_aS));
                items.add(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, 1));
            } else {
                currencies.add(new ItemStack(Items.field_151082_bd));
                currencies.add(new ItemStack(Items.field_151147_al));
                currencies.add(new ItemStack(Items.field_151076_bf));
                currencies.add(new ItemStack(Items.field_151115_aP));
                currencies.add(new ItemStack(Items.field_151015_O));
                currencies.add(new ItemStack(Items.field_151014_N));
                currencies.add(new ItemStack(Items.field_151172_bF));
                currencies.add(new ItemStack(Items.field_151034_e));
                currencies.add(new ItemStack(Items.field_151174_bG));
            }
            for (ItemStack itemstack : items) {
                if (itemstack.func_190926_b()) continue;
                itemstack.func_77973_b();
                ItemStack goods = itemstack.func_77946_l();
                goods.func_190920_e(Math.min(r.nextInt(itemstack.func_190916_E()) + (itemstack.func_190916_E() > 4 ? 3 : 1), goods.func_77976_d()));
                ItemStack currency = (ItemStack)currencies.get(r.nextInt(currencies.size()));
                ItemStack cost = currency.func_77946_l();
                int multiplier = 1;
                if (goods.func_77973_b() == Items.field_151045_i || goods.func_77973_b() == Items.field_151166_bC || goods.func_77973_b() == Items.field_151141_av || goods.func_77973_b() == WitcheryIngredientItems.TREEFYD_SEEDS || animal.func_70662_br()) {
                    multiplier = 2;
                }
                int factor = goods.func_190916_E() > 4 ? 1 : 2;
                cost.func_190920_e(Math.min(r.nextInt(2) + goods.func_190916_E() * multiplier * (r.nextInt(2) + factor), currency.func_77976_d()));
                MerchantRecipe recipe = new MerchantRecipe(cost, goods);
                recipe.func_82783_a(-(6 - r.nextInt(2)));
                list2.add((Object)recipe);
            }
            Collections.shuffle(list2);
            int MAX_ITEMS = r.nextInt(2) + 1;
            for (int i = 0; i < MAX_ITEMS && i < list2.size(); ++i) {
                finalList.add(list2.get(i));
            }
        }

        public void playIntro() {
            this.playGreeting(this.animal);
        }

        public EntityPlayer func_70931_l_() {
            return this.customer;
        }

        public void func_70932_a_(EntityPlayer player) {
            this.customer = player;
        }

        public MerchantRecipeList func_70934_b(EntityPlayer player) {
            NBTTagCompound nbtTag = this.animal.getEntityData();
            if (this.currentList != null) {
                return this.currentList;
            }
            if (nbtTag.func_74764_b(STOCKS_KEY)) {
                NBTTagCompound nbtTagStocks = nbtTag.func_74775_l(STOCKS_KEY);
                this.currentList = nbtTagStocks.func_82582_d() ? new MerchantRecipeList() : new MerchantRecipeList(nbtTagStocks);
                return this.currentList;
            }
            this.currentList = new MerchantRecipeList();
            AnimalMerchant.populateList(this.animal, this.currentList);
            nbtTag.func_74782_a(STOCKS_KEY, (NBTBase)this.currentList.func_77202_a());
            return this.currentList;
        }

        public void func_70933_a(MerchantRecipe recipe) {
            if (this.animal != null && this.animal.func_70089_S() && !this.animal.field_70170_p.field_72995_K) {
                recipe.func_77399_f();
                if (this.currentList != null) {
                    NBTTagCompound nbtTag = this.animal.getEntityData();
                    nbtTag.func_74782_a(STOCKS_KEY, (NBTBase)this.currentList.func_77202_a());
                }
            }
            this.animal.func_70642_aH();
        }

        public void func_110297_a_(ItemStack itemstack) {
            this.animal.func_70642_aH();
        }

        public ITextComponent func_145748_c_() {
            return this.animal.func_145748_c_();
        }

        public World func_190670_t_() {
            return this.animal.field_70170_p;
        }

        public BlockPos func_190671_u_() {
            return this.animal.func_180425_c();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70930_a(MerchantRecipeList list2) {
        }

        private void playGreeting(EntityLiving animal) {
            animal.func_70642_aH();
            animal.func_70642_aH();
            animal.func_70642_aH();
        }
    }
}

