/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityBanshee;
import net.msrandom.witchery.entity.EntityPoltergeist;
import net.msrandom.witchery.entity.EntitySpectre;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemSpectralStone
extends Item {
    public ItemSpectralStone() {
        this.func_77625_d(16);
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static ItemStack makeStack(Class<? extends EntityCreature> entityType, int count) {
        ItemStack stack = new ItemStack((Item)WitcheryGeneralItems.SPECTRAL_STONE);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Type", EntityList.func_191306_a(entityType).toString());
        tag.func_74768_a("Quantity", Math.min(count, 7));
        stack.func_77982_d(tag);
        return stack;
    }

    private EntityType<?> getType(ItemStack stack) {
        return stack.func_77942_o() ? RegistryWrappers.ENTITIES.get(new ResourceLocation(WitcheryUtils.getOrCreateTag(stack).func_74779_i("Type"))) : null;
    }

    private int getQuantityFromStack(ItemStack stack) {
        return stack.func_77942_o() ? WitcheryUtils.getOrCreateTag(stack).func_74762_e("Quantity") : 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (this.func_194125_a(tab)) {
            items.add((Object)ItemSpectralStone.makeStack(EntitySpectre.class, 1));
            items.add((Object)ItemSpectralStone.makeStack(EntityBanshee.class, 1));
            items.add((Object)ItemSpectralStone.makeStack(EntityPoltergeist.class, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag extraTip) {
        EntityType<?> type2 = this.getType(stack);
        if (type2 != null) {
            int quantity = Math.min(this.getQuantityFromStack(stack), 4);
            EntityEntry entry2 = EntityRegistry.getEntry(type2.getEntityClass());
            if (entry2 != null) {
                list2.add(I18n.func_135052_a((String)("entity." + entry2.getName() + ".name"), (Object[])new Object[0]) + ": " + quantity);
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 400;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int countdown) {
        int elapsedTicks = this.func_77626_a(stack) - countdown;
        if (player instanceof EntityPlayer && elapsedTicks == 40) {
            WitcheryUtils.playSoundAt((EntityPlayer)player, SoundEvents.field_189107_dL, SoundCategory.PLAYERS, 0.5f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int countdown) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int elapsedTicks = this.func_77626_a(stack) - countdown;
            int quantity = Math.min(this.getQuantityFromStack(stack), 3);
            EntityType<?> type2 = this.getType(stack);
            if (type2 == null) {
                if (world.field_72995_K) {
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else if (elapsedTicks >= 40 && quantity > 0) {
                RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, player, true, 16.0);
                BlockPos coords = BlockUtil.getBlockCoords(world, mop, true);
                if (coords != null) {
                    if (!world.field_72995_K) {
                        for (int i = 0; i < quantity; ++i) {
                            int ax = world.field_73012_v.nextInt(3);
                            int az = world.field_73012_v.nextInt(3);
                            BlockPos pos = world.func_175645_m(coords.func_177982_a(ax - 1, 8, az - 1));
                            Object entity = type2.create(world);
                            if (entity == null) continue;
                            if (entity instanceof EntityLiving) {
                                EntityLiving living2 = (EntityLiving)entity;
                                living2.func_180482_a(((Entity)entity).field_70170_p.func_175649_E(entity.func_180425_c()), null);
                                living2.func_110163_bv();
                                PotionEnslaved.setEnslaverForMob(living2, player);
                                if (living2 instanceof EntityTameable) {
                                    ((EntityTameable)living2).func_184754_b(player.func_110124_au());
                                    ((EntityTameable)living2).func_70903_f(true);
                                } else if (entity instanceof EntityPoltergeist) {
                                    ((EntityPoltergeist)((Object)entity)).setSummoner(player);
                                }
                            }
                            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                            world.func_72838_d(entity);
                            WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.5, 0.0, 20);
                        }
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (stack.func_190916_E() > 1) {
                            ItemStack newStack = stack.func_77979_a(1);
                            newStack.func_77964_b(0);
                            if (!player.field_71071_by.func_70441_a(newStack)) {
                                if (!world.field_72995_K) {
                                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 1.5, player.field_70161_v + 0.5, newStack));
                                }
                            } else if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                            }
                        } else {
                            stack.func_77964_b(0);
                        }
                    }
                } else {
                    WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

