/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.block.BlockCrystalBall;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityEye;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntityTreefyd;
import net.msrandom.witchery.entity.EntityWingedMonkey;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.BloodStorage;
import net.msrandom.witchery.network.PacketEyePosition;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemTaglockKit
extends Item
implements BloodStorage {
    private final boolean bound;

    public ItemTaglockKit(boolean bound) {
        this.bound = bound;
        if (!bound) {
            this.func_77637_a(WitcheryGeneralItems.TAB);
        }
        this.func_77625_d(16);
    }

    public static boolean isTaglockRestricted(EntityPlayer collector, EntityLivingBase target) {
        if (!(target instanceof EntityPlayer) || collector.equals((Object)target)) {
            return false;
        }
        if (WitcheryConfigOptions.restrictTaglockCollectionOnNonPVPServers && !collector.func_184102_h().func_71219_W()) {
            return true;
        }
        EntityPlayer targetPlayer = (EntityPlayer)target;
        return WitcheryConfigOptions.restrictTaglockCollectionForStaffMembers && targetPlayer.func_184102_h().func_184103_al().func_152596_g(targetPlayer.func_146103_bH());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
        super.func_77624_a(stack, worldIn, list2, advTooltips);
        if (this.bound) {
            ITextComponent bound = ItemTaglockKit.getBoundEntityName(stack, 0);
            if (bound != null) {
                list2.add(bound.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d());
            }
        } else {
            list2.add(I18n.func_135052_a((String)(this.func_77658_a() + ".unbound"), (Object[])new Object[0]));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 1200;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase livingBase, int countdown) {
        if (livingBase instanceof EntityPlayerMP) {
            EntityLivingBase entity;
            EntityPlayerMP player = (EntityPlayerMP)livingBase;
            World world = player.field_70170_p;
            int elapsedTicks = this.func_77626_a(stack) - countdown;
            if (elapsedTicks % 20 == 0 && (entity = ItemTaglockKit.getBoundEntity(world, stack, 0)) != null && entity.field_71093_bK == player.field_71093_bK) {
                if (entity == player) {
                    if (elapsedTicks == 0) {
                        EntityEye eye = new EntityEye(world);
                        eye.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 90.0f);
                        world.func_72838_d((Entity)eye);
                        WitcheryNetworkChannel.sendTo(new PacketEyePosition((Entity)eye, true), player);
                    }
                } else {
                    WitcheryNetworkChannel.sendTo(new PacketEyePosition((Entity)entity, elapsedTicks == 0), player);
                }
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase player) {
        if (player instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketEyePosition(null, true), (EntityPlayerMP)player);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (player instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketEyePosition(null, true), (EntityPlayerMP)player);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = player.func_184586_b(hand);
        if (block == Blocks.field_150324_C || block instanceof BlockCoffin || block.func_149739_a().equals("tile.blockCarpentersBed") || block.isBed(state, (IBlockAccess)world, pos, (Entity)player)) {
            if (block == Blocks.field_150324_C && state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD && world.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D))).func_177230_c() != Blocks.field_150324_C) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                return !world.field_72995_K ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            if (player.func_70093_af()) {
                if (!world.field_72995_K) {
                    this.setPlayerTaglock(world, player, itemstack, player, hand);
                }
                return !world.field_72995_K ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            if (!world.field_72995_K) {
                boolean taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos, hand);
                if (!taglockSaved && block != Blocks.field_150324_C) {
                    if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.func_177974_f(), hand);
                    }
                    if (!taglockSaved && world.func_180495_p(pos.func_177968_d()).func_177230_c() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.func_177968_d(), hand);
                    }
                    if (!taglockSaved && world.func_180495_p(pos.func_177976_e()).func_177230_c() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.func_177976_e(), hand);
                    }
                    if (!taglockSaved && world.func_180495_p(pos.func_177978_c()).func_177230_c() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.func_177978_c(), hand);
                    }
                }
                if (taglockSaved) {
                    return EnumActionResult.SUCCESS;
                }
            }
            if (!world.field_72995_K) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            return !world.field_72995_K ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        if (block == WitcheryBlocks.CRYSTAL_BALL) {
            if (this.bound) {
                if (!world.field_72995_K && BlockCrystalBall.tryConsumePower(world, player, pos)) {
                    player.func_184598_c(hand);
                } else if (world.field_72995_K) {
                    player.func_184598_c(hand);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            return !world.field_72995_K ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    private boolean tryBindTaglockFromBed(ItemStack itemstack, EntityPlayer player, World world, BlockPos clickedBedLocation, EnumHand hand) {
        String boundName = "";
        EntityLivingBase boundEntity = ItemTaglockKit.getBoundEntity(world, itemstack, 0);
        if (boundEntity instanceof EntityPlayer) {
            boundName = boundEntity.func_70005_c_();
        }
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (EntityPlayer worldPlayer : world.field_73010_i) {
            BlockPos playerBedLocation = worldPlayer.getBedLocation(player.field_71093_bK);
            if (playerBedLocation == null || !playerBedLocation.equals((Object)clickedBedLocation)) continue;
            players.add(worldPlayer);
        }
        players.sort(Comparator.comparing(EntityPlayer::func_70005_c_));
        boolean taglockSaved = false;
        if (players.size() > 0) {
            if (boundName.isEmpty()) {
                taglockSaved = this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand);
            } else {
                boolean found = false;
                for (int i = 0; i < players.size() && !found; ++i) {
                    if (!((EntityPlayer)players.get(i)).func_70005_c_().equals(boundName)) continue;
                    taglockSaved = i == players.size() - 1 ? this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand) : this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(i + 1), hand);
                    found = true;
                }
                if (!found) {
                    taglockSaved = this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand);
                }
            }
        }
        return taglockSaved;
    }

    private boolean setPlayerTaglock(World world, EntityPlayer player, ItemStack itemstack, EntityPlayer victim, EnumHand hand) {
        if (!ItemTaglockKit.isTaglockRestricted(player, (EntityLivingBase)victim)) {
            ItemTaglockKit.setEntityTaglock(world, player, itemstack, (Entity)victim, hand);
            return true;
        }
        return false;
    }

    public static void setEntityTaglock(World world, EntityPlayer player, ItemStack itemstack, UUID victim, EnumHand hand) {
        Entity entity;
        if (!world.field_72995_K && (entity = ((WorldServer)world).func_175733_a(victim)) != null) {
            ItemTaglockKit.setEntityTaglock(world, player, itemstack, entity, hand);
        }
    }

    public static void setEntityTaglock(World world, EntityPlayer player, ItemStack itemstack, Entity victim, EnumHand hand) {
        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.BOUND_TAGLOCK_KIT);
        WitcheryGeneralItems.BOUND_TAGLOCK_KIT.updateBloodOwner(newStack, victim, 0);
        WitcheryUtils.playSoundAt(player, SoundEvents.field_187604_bf, player.func_184176_by(), 0.5f, 0.4f / ((float)player.field_70170_p.field_73012_v.nextDouble() * 0.4f + 0.8f));
        if (itemstack.func_190916_E() == 1) {
            player.func_184611_a(hand, newStack);
        } else {
            itemstack.func_190918_g(1);
            if (!player.field_71071_by.func_70441_a(newStack)) {
                player.func_71019_a(newStack, false);
            }
        }
    }

    public static void onEntityInteract(World world, EntityPlayer player, ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        if (!world.field_72995_K && stack.func_77973_b() instanceof ItemTaglockKit && event.getTarget() != null && event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            if (!(target instanceof EntityPlayer) || ItemTaglockKit.isSneakSuccessful(player, target)) {
                if (target instanceof EntityTreefyd || target instanceof EntityImp || target instanceof EntityWingedMonkey && !player.func_70093_af()) {
                    return;
                }
                ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.BOUND_TAGLOCK_KIT);
                ItemTaglockKit.setEntityTaglock(newStack, player, (Entity)target, true, 0);
                if (stack.func_190916_E() == 1) {
                    player.func_184611_a(event.getHand(), newStack);
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                } else {
                    stack.func_190918_g(1);
                    if (!player.field_71071_by.func_70441_a(newStack)) {
                        world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 1.5, player.field_70161_v + 0.5, newStack));
                    } else if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                }
            } else {
                event.getEntityPlayer().func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.func_77658_a() + ".player_noticed_taglock", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                target.func_145747_a(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.func_77658_a() + ".noticed_taglock", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            event.setCanceled(true);
        }
    }

    private static boolean isSneakSuccessful(EntityPlayer sneaker, EntityLivingBase target) {
        double chance;
        double targetFacing;
        if (ItemTaglockKit.isTaglockRestricted(sneaker, target)) {
            return false;
        }
        double sneakerFacing = (sneaker.field_70759_as + 90.0f) % 360.0f;
        if (sneakerFacing < 0.0) {
            sneakerFacing += 360.0;
        }
        if ((targetFacing = (double)((target.field_70759_as + 90.0f) % 360.0f)) < 0.0) {
            targetFacing += 360.0;
        }
        double ARC = 45.0;
        double diff = Math.abs(targetFacing - sneakerFacing);
        double d = chance = sneaker.func_82150_aj() ? 0.11 : 0.01;
        if (360.0 - diff % 360.0 < ARC || diff % 360.0 < ARC) {
            chance = sneaker.func_70093_af() ? 0.6 : 0.3;
        }
        return sneaker.field_70170_p.field_73012_v.nextDouble() < chance;
    }

    public static void setEntityTaglock(ItemStack stack, EntityPlayer player, Entity entity, boolean playSoundAtPlayer, int index) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ((BloodStorage)stack.func_77973_b()).updateBloodOwner(stack, entity, index);
        if (playSoundAtPlayer) {
            WitcheryUtils.playSoundAt(player, SoundEvents.field_187604_bf, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    public static void clearTaglock(ItemStack stack, int index) {
        if (!stack.func_190926_b()) {
            ((BloodStorage)stack.func_77973_b()).clearBlood(stack, index);
        }
    }

    public static boolean isTaglockPresent(ItemStack stack, int index) {
        return ((BloodStorage)stack.func_77973_b()).hasBlood(stack, index);
    }

    public static ITextComponent getBoundEntityName(ItemStack stack, int index) {
        return ((BloodStorage)stack.func_77973_b()).getBloodName(stack, index);
    }

    public static Class<? extends Entity> getBoundEntityType(ItemStack stack, int index) {
        return ((BloodStorage)stack.func_77973_b()).getEntityType(stack, index);
    }

    public static GameProfile getBoundPlayer(ItemStack stack, int index) {
        if (stack.func_77942_o()) {
            return NBTUtil.func_152459_a((NBTTagCompound)stack.func_77978_p().func_150295_c("Blood", 10).func_150305_b(index).func_74775_l("Profile"));
        }
        return null;
    }

    public static UUID getBoundCreatureID(ItemStack stack, int index) {
        if (stack.func_77942_o()) {
            GameProfile boundPlayer;
            NBTTagCompound blood = stack.func_77978_p().func_150295_c("Blood", 10).func_150305_b(index);
            if (!blood.func_186855_b("ID") && (boundPlayer = ItemTaglockKit.getBoundPlayer(stack, index)) != null) {
                return boundPlayer.getId();
            }
            return blood.func_186857_a("ID");
        }
        GameProfile boundPlayer = ItemTaglockKit.getBoundPlayer(stack, index);
        if (boundPlayer != null) {
            return boundPlayer.getId();
        }
        return new UUID(0L, 0L);
    }

    public static void bindTaglock(ItemStack stackTaglockKit, ItemStack stackPoppet, int index) {
        NBTTagCompound taglock = stackTaglockKit.func_77978_p().func_150295_c("Blood", 10).func_150305_b(0);
        ((BloodStorage)stackPoppet.func_77973_b()).updateBloodOwner(stackPoppet, taglock.func_186857_a("ID"), taglock.func_74764_b("Type") ? taglock.func_74779_i("Type") : null, taglock.func_74764_b("Name") ? taglock.func_74779_i("Name") : null, taglock.func_74764_b("Profile") ? taglock.func_74775_l("Profile") : null, index);
    }

    public static boolean containsTaglockForEntity(ItemStack stack, Entity entity, int index) {
        BloodStorage storage2;
        if (stack.func_77942_o() && (storage2 = (BloodStorage)stack.func_77973_b()).hasBlood(stack, index)) {
            return entity.func_110124_au().equals(ItemTaglockKit.getBoundCreatureID(stack, index));
        }
        return false;
    }

    public static EntityLivingBase getBoundEntity(World world, ItemStack stack, int index) {
        block5: {
            BloodStorage storage2 = (BloodStorage)stack.func_77973_b();
            if (!storage2.hasBlood(stack, index)) break block5;
            UUID uniqueId = ItemTaglockKit.getBoundCreatureID(stack, index);
            if (!world.field_72995_K) {
                MinecraftServer server = world.func_73046_m();
                for (WorldServer worldServer : server.field_71305_c) {
                    Entity entity = worldServer.func_175733_a(uniqueId);
                    if (!(entity instanceof EntityLivingBase)) continue;
                    return (EntityLivingBase)entity;
                }
            } else {
                EntityPlayer player = world.func_152378_a(uniqueId);
                if (player != null) {
                    return player;
                }
                for (Entity entity : world.field_72996_f) {
                    if (!(entity instanceof EntityLivingBase) || !entity.func_110124_au().equals(uniqueId)) continue;
                    return (EntityLivingBase)entity;
                }
            }
        }
        return null;
    }
}

