/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockVoidBramble;
import net.msrandom.witchery.client.model.ModelWitchesClothes;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.traits.Invisible;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemWitchesClothes
extends ItemArmor
implements Invisible {
    private static final int CHARGE_PER_PIECE = 2;
    private static final double WILD_EFFECT_CHANCE = 0.01;
    private static String noPlaceLikeHome;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelNecroChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesLegs;

    public ItemWitchesClothes(EntityEquipmentSlot armorSlot) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }

    public static int getMaxChargeLevel(EntityLivingBase entity) {
        int level = 0;
        for (int i = 2; i <= 5; ++i) {
            ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemWitchesClothes)) continue;
            level += 2;
        }
        return level;
    }

    public static void setChargeLevel(ItemStack stack, int level) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.func_77978_p();
        nbtRoot.func_74768_a("WitcheryBarkPieces", level);
    }

    public static int getChargeLevel(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (stack.func_77942_o() && (nbtRoot = stack.func_77978_p()).func_74764_b("WitcheryBarkPieces")) {
            return nbtRoot.func_74762_e("WitcheryBarkPieces");
        }
        return 0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type2) {
        if (!(stack.func_190926_b() || stack.func_77973_b() != WitcheryEquipmentItems.WITCH_HAT && stack.func_77973_b() != WitcheryEquipmentItems.WITCH_ROBES && stack.func_77973_b() != WitcheryEquipmentItems.NECROMANCERS_ROBES && stack.func_77973_b() != WitcheryEquipmentItems.ICY_SLIPPERS && stack.func_77973_b() != WitcheryEquipmentItems.RUBY_SLIPPERS && stack.func_77973_b() != WitcheryEquipmentItems.SEEPING_SHOES && stack.func_77973_b() != WitcheryEquipmentItems.BABAS_HAT)) {
            return "witchery:textures/entities/witchclothes" + (type2 == null ? "" : "_overlay") + ".png";
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == WitcheryEquipmentItems.BITING_BELT) {
            return "witchery:textures/entities/witchclothes_legs" + (type2 == null ? "" : "_overlay") + ".png";
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == WitcheryEquipmentItems.BARK_BELT) {
            return "witchery:textures/entities/witchclothes" + (type2 == null ? "2_legs" : "_legs_overlay") + ".png";
        }
        return null;
    }

    public boolean func_82816_b_(ItemStack stack) {
        return stack.func_190926_b() || stack.func_77973_b() != WitcheryEquipmentItems.BABAS_HAT;
    }

    public int func_82814_b(ItemStack stack) {
        if (!this.func_82816_b_(stack)) {
            return super.func_82814_b(stack);
        }
        if (stack.func_77973_b() == WitcheryEquipmentItems.RUBY_SLIPPERS) {
            return 0xDD0000;
        }
        int color2 = super.func_82814_b(stack);
        if (color2 == 10511680) {
            color2 = this == WitcheryEquipmentItems.ICY_SLIPPERS ? 7842303 : (this == WitcheryEquipmentItems.SEEPING_SHOES ? 0x226633 : (this == WitcheryEquipmentItems.BARK_BELT ? 6968628 : 2628115));
        }
        return color2;
    }

    public boolean isHatWorn(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == this;
    }

    public boolean isRobeWorn(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == this;
    }

    public boolean isBeltWorn(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == this;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelWitchesClothes(0.61f, false);
        }
        if (this.modelNecroChest == null) {
            this.modelNecroChest = new ModelWitchesClothes(0.61f, true);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelWitchesClothes(0.45f, false);
        }
        return armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.FEET ? (stack.func_77973_b() == WitcheryEquipmentItems.NECROMANCERS_ROBES ? this.modelNecroChest : this.modelClothesChest) : this.modelClothesLegs;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_190926_b()) {
            return EnumRarity.COMMON;
        }
        if (stack.func_77973_b() == WitcheryEquipmentItems.BABAS_HAT) {
            return EnumRarity.EPIC;
        }
        if (stack.func_77973_b() == WitcheryEquipmentItems.BARK_BELT) {
            return EnumRarity.RARE;
        }
        return EnumRarity.UNCOMMON;
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translateSplit(this.func_77658_a() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
        if (stack.func_77942_o()) {
            WitcheryUtils.addGoldenTooltips(PotionUtils.func_185189_a((ItemStack)stack), list2);
        }
    }

    public static void noPlaceLikeHome(EntityPlayer player) {
        NBTTagCompound nbtPlayer;
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && stack.func_77973_b() == WitcheryEquipmentItems.RUBY_SLIPPERS && !WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && (nbtPlayer = player.getEntityData()) != null) {
            int R = 3;
            AxisAlignedBB bounds = new AxisAlignedBB(player.field_70165_t - (double)R, player.field_70163_u - (double)R, player.field_70161_v - (double)R, player.field_70165_t + (double)R, player.field_70163_u + (double)R, player.field_70161_v + (double)R);
            List list2 = player.field_70170_p.func_72872_a(EntityItem.class, bounds);
            for (EntityItem waystoneEntity : list2) {
                int waystoneDimension;
                ItemStack waystoneStack = waystoneEntity.func_92059_d();
                if (waystoneStack.func_77973_b() != WitcheryIngredientItems.BOUND_WAYSTONE) continue;
                if (nbtPlayer.func_74764_b("WitcheryLastRubySlipperWayTime")) {
                    long cooldown;
                    long lastTime = nbtPlayer.func_74763_f("WitcheryLastRubySlipperWayTime");
                    long currentTime = MinecraftServer.func_130071_aq();
                    long timeSince = currentTime - lastTime;
                    if (timeSince < (cooldown = 60000L)) {
                        int cooldownRemaining = Math.max(1, (int)(cooldown - timeSince) / 60000);
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.slipper_cooldown", new Object[]{cooldownRemaining}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        return;
                    }
                }
                if (Infusion.acquireEnergy(player.field_70170_p, player, (waystoneDimension = waystoneStack.func_77942_o() ? WitcheryUtils.getOrCreateTag(waystoneStack).func_74762_e("Dimension") : 0) != player.field_71093_bK ? 80 : 40, true)) {
                    waystoneEntity.func_70106_y();
                    nbtPlayer.func_74772_a("WitcheryLastRubySlipperWayTime", MinecraftServer.func_130071_aq());
                    if (player.field_70170_p.field_73012_v.nextDouble() < 0.01) {
                        BlockVoidBramble.teleportRandomly(player.field_70170_p, player.func_180425_c(), (Entity)player, 500);
                    } else {
                        TeleportationUtil.teleportToLocation(player.field_70170_p, waystoneStack, (Entity)player, 2, true);
                    }
                }
                return;
            }
            if (nbtPlayer.func_74764_b("WitcheryLastRubySlipperTime")) {
                long cooldown;
                long lastTime = nbtPlayer.func_74763_f("WitcheryLastRubySlipperTime");
                long currentTime = MinecraftServer.func_130071_aq();
                long timeSince = currentTime - lastTime;
                if (timeSince < (cooldown = 1800000L) && !player.field_71075_bZ.field_75098_d) {
                    int cooldownRemaining2 = Math.max(1, (int)(cooldown - timeSince) / 60000);
                    player.func_145747_a(new TextComponentTranslation("rite.witchery.slipper_cooldown", new Object[]{cooldownRemaining2}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    return;
                }
            }
            BlockPos coords = player.getBedLocation(player.field_71093_bK);
            int dimension = player.field_71093_bK;
            World world = player.field_70170_p;
            if (coords == null) {
                coords = player.getBedLocation(0);
                dimension = 0;
                world = world.func_73046_m().func_71218_a(0);
                if (coords == null) {
                    coords = world.func_175694_M();
                    while (world.func_180495_p(coords).func_185915_l() && coords.func_177956_o() < 255) {
                        coords = coords.func_177984_a();
                    }
                }
            }
            if (coords != null) {
                nbtPlayer.func_74772_a("WitcheryLastRubySlipperTime", MinecraftServer.func_130071_aq());
                coords = Blocks.field_150324_C.getBedSpawnPosition(world.func_180495_p(coords), (IBlockAccess)world, coords, null);
                if (coords != null) {
                    if (Infusion.acquireEnergy(player.field_70170_p, player, dimension != player.field_71093_bK ? 120 : 80, true)) {
                        TeleportationUtil.teleportToLocation(coords.func_177984_a(), dimension, (Entity)player, true);
                    }
                    return;
                }
            }
        }
        player.func_145747_a(new TextComponentTranslation("chant.witchery.unknown_chant", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
    }
}

